/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Renderer;
import org.apache.pivot.wtk.SpinnerItemListener;
import org.apache.pivot.wtk.SpinnerListener;
import org.apache.pivot.wtk.SpinnerSelectionListener;
import org.apache.pivot.wtk.content.SpinnerItemRenderer;

public class Spinner
extends Container {
    private List<?> spinnerData = null;
    private ListHandler spinnerDataHandler = new ListHandler();
    private ItemRenderer itemRenderer = null;
    private boolean circular = false;
    private int selectedIndex = -1;
    private String selectedItemKey = null;
    private SpinnerListenerList spinnerListeners = new SpinnerListenerList();
    private SpinnerItemListenerList spinnerItemListeners = new SpinnerItemListenerList();
    private SpinnerSelectionListenerList spinnerSelectionListeners = new SpinnerSelectionListenerList();

    public Spinner() {
        this((List<?>)new ArrayList());
    }

    public Spinner(List<?> list) {
        this.setItemRenderer(new SpinnerItemRenderer());
        this.setSpinnerData(list);
        this.installThemeSkin(Spinner.class);
    }

    public List<?> getSpinnerData() {
        return this.spinnerData;
    }

    public void setSpinnerData(List<?> list) {
        if (list == null) {
            throw new IllegalArgumentException("spinnerData is null.");
        }
        List<?> list2 = this.spinnerData;
        if (list2 != list) {
            if (list2 != null) {
                this.selectedIndex = -1;
                list2.getListListeners().remove((Object)this.spinnerDataHandler);
            }
            list.getListListeners().add((Object)this.spinnerDataHandler);
            this.spinnerData = list;
            this.spinnerListeners.spinnerDataChanged(this, list2);
        }
    }

    public final void setSpinnerData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("spinnerData is null.");
        }
        try {
            this.setSpinnerData(JSONSerializer.parseList((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public void setItemRenderer(ItemRenderer itemRenderer) {
        if (itemRenderer == null) {
            throw new IllegalArgumentException("itemRenderer is null.");
        }
        ItemRenderer itemRenderer2 = this.itemRenderer;
        if (itemRenderer2 != itemRenderer) {
            this.itemRenderer = itemRenderer;
            this.spinnerListeners.itemRendererChanged(this, itemRenderer2);
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean bl) {
        if (bl != this.circular) {
            this.circular = bl;
            this.spinnerListeners.circularChanged(this);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        int n2 = this.selectedIndex;
        if (n2 != n) {
            this.selectedIndex = n;
            this.spinnerSelectionListeners.selectedIndexChanged(this, n2);
        }
    }

    public Object getSelectedItem() {
        int n = this.getSelectedIndex();
        Object object = null;
        if (n >= 0) {
            object = this.spinnerData.get(n);
        }
        return object;
    }

    public void setSelectedItem(Object object) {
        this.setSelectedIndex(object == null ? -1 : this.spinnerData.indexOf(object));
    }

    public String getSelectedItemKey() {
        return this.selectedItemKey;
    }

    public void setSelectedItemKey(String string) {
        String string2 = this.selectedItemKey;
        if (string2 != string) {
            this.selectedItemKey = string;
            this.spinnerListeners.selectedItemKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        if (this.selectedItemKey != null && JSONSerializer.containsKey(dictionary, (String)this.selectedItemKey)) {
            Object object = JSONSerializer.get(dictionary, (String)this.selectedItemKey);
            this.setSelectedItem(object);
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.selectedItemKey != null) {
            Object object = this.getSelectedItem();
            JSONSerializer.put(dictionary, (String)this.selectedItemKey, (Object)object);
        }
    }

    @Override
    public void clear() {
        if (this.selectedItemKey != null) {
            this.setSelectedItem(null);
        }
    }

    public Bounds getContentBounds() {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getContentBounds();
    }

    public ListenerList<SpinnerListener> getSpinnerListeners() {
        return this.spinnerListeners;
    }

    public ListenerList<SpinnerItemListener> getSpinnerItemListeners() {
        return this.spinnerItemListeners;
    }

    public ListenerList<SpinnerSelectionListener> getSpinnerSelectionListeners() {
        return this.spinnerSelectionListeners;
    }

    private static class SpinnerSelectionListenerList
    extends ListenerList<SpinnerSelectionListener>
    implements SpinnerSelectionListener {
        private SpinnerSelectionListenerList() {
        }

        @Override
        public void selectedIndexChanged(Spinner spinner, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerSelectionListener spinnerSelectionListener = (SpinnerSelectionListener)iterator.next();
                spinnerSelectionListener.selectedIndexChanged(spinner, n);
            }
        }
    }

    private static class SpinnerItemListenerList
    extends ListenerList<SpinnerItemListener>
    implements SpinnerItemListener {
        private SpinnerItemListenerList() {
        }

        @Override
        public void itemInserted(Spinner spinner, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerItemListener spinnerItemListener = (SpinnerItemListener)iterator.next();
                spinnerItemListener.itemInserted(spinner, n);
            }
        }

        @Override
        public void itemsRemoved(Spinner spinner, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerItemListener spinnerItemListener = (SpinnerItemListener)iterator.next();
                spinnerItemListener.itemsRemoved(spinner, n, n2);
            }
        }

        @Override
        public void itemUpdated(Spinner spinner, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerItemListener spinnerItemListener = (SpinnerItemListener)iterator.next();
                spinnerItemListener.itemUpdated(spinner, n);
            }
        }

        @Override
        public void itemsCleared(Spinner spinner) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerItemListener spinnerItemListener = (SpinnerItemListener)iterator.next();
                spinnerItemListener.itemsCleared(spinner);
            }
        }

        @Override
        public void itemsSorted(Spinner spinner) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerItemListener spinnerItemListener = (SpinnerItemListener)iterator.next();
                spinnerItemListener.itemsSorted(spinner);
            }
        }
    }

    private static class SpinnerListenerList
    extends ListenerList<SpinnerListener>
    implements SpinnerListener {
        private SpinnerListenerList() {
        }

        @Override
        public void spinnerDataChanged(Spinner spinner, List<?> list) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerListener spinnerListener = (SpinnerListener)iterator.next();
                spinnerListener.spinnerDataChanged(spinner, list);
            }
        }

        @Override
        public void itemRendererChanged(Spinner spinner, ItemRenderer itemRenderer) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerListener spinnerListener = (SpinnerListener)iterator.next();
                spinnerListener.itemRendererChanged(spinner, itemRenderer);
            }
        }

        @Override
        public void circularChanged(Spinner spinner) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerListener spinnerListener = (SpinnerListener)iterator.next();
                spinnerListener.circularChanged(spinner);
            }
        }

        @Override
        public void selectedItemKeyChanged(Spinner spinner, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpinnerListener spinnerListener = (SpinnerListener)iterator.next();
                spinnerListener.selectedItemKeyChanged(spinner, string);
            }
        }
    }

    private class ListHandler
    implements ListListener<Object> {
        private ListHandler() {
        }

        public void itemInserted(List<Object> list, int n) {
            if (n <= Spinner.this.selectedIndex) {
                Spinner.this.selectedIndex++;
            }
            Spinner.this.spinnerItemListeners.itemInserted(Spinner.this, n);
        }

        public void itemsRemoved(List<Object> list, int n, Sequence<Object> sequence) {
            int n2 = sequence.getLength();
            if (n + n2 <= Spinner.this.selectedIndex) {
                Spinner.this.selectedIndex--;
            } else if (n <= Spinner.this.selectedIndex) {
                Spinner.this.selectedIndex = -1;
            }
            Spinner.this.spinnerItemListeners.itemsRemoved(Spinner.this, n, n2);
        }

        public void itemUpdated(List<Object> list, int n, Object object) {
            Spinner.this.spinnerItemListeners.itemUpdated(Spinner.this, n);
        }

        public void listCleared(List<Object> list) {
            Spinner.this.selectedIndex = -1;
            Spinner.this.spinnerItemListeners.itemsCleared(Spinner.this);
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> comparator) {
            if (list.getComparator() != null) {
                Spinner.this.selectedIndex = -1;
                Spinner.this.spinnerItemListeners.itemsSorted(Spinner.this);
            }
        }
    }

    public static interface Skin {
        public Bounds getContentBounds();
    }

    public static interface ItemRenderer
    extends Renderer {
        public void render(Object var1, Spinner var2);
    }
}

