/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.SplitPaneListener;

public class SplitPane
extends Container {
    private Component topLeft = null;
    private Component bottomRight = null;
    private Orientation orientation = null;
    private Region primaryRegion = Region.TOP_LEFT;
    private ResizeMode resizeMode = ResizeMode.SPLIT_RATIO;
    private float splitRatio = 0.5f;
    private boolean locked = false;
    private SplitPaneListenerList splitPaneListeners = new SplitPaneListenerList();

    public SplitPane() {
        this(Orientation.HORIZONTAL);
    }

    public SplitPane(Orientation orientation) {
        this(orientation, null, null);
    }

    public SplitPane(Orientation orientation, Component component, Component component2) {
        this.orientation = orientation;
        this.installThemeSkin(SplitPane.class);
        this.setTopLeft(component);
        this.setBottomRight(component2);
    }

    public Component getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(Component component) {
        Component component2 = this.topLeft;
        if (component != component2) {
            this.topLeft = component;
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                if (component.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                this.add(component);
            }
            this.splitPaneListeners.topLeftChanged(this, component2);
        }
    }

    public Component getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(Component component) {
        Component component2 = this.bottomRight;
        if (component != component2) {
            this.bottomRight = component;
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                if (component.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                this.add(component);
            }
            this.splitPaneListeners.bottomRightChanged(this, component2);
        }
    }

    public Component getTop() {
        return this.orientation == Orientation.HORIZONTAL ? null : this.getTopLeft();
    }

    public void setTop(Component component) {
        this.setTopLeft(component);
    }

    public Component getBottom() {
        return this.orientation == Orientation.HORIZONTAL ? null : this.getBottomRight();
    }

    public void setBottom(Component component) {
        this.setBottomRight(component);
    }

    public Component getLeft() {
        return this.orientation == Orientation.VERTICAL ? null : this.getTopLeft();
    }

    public void setLeft(Component component) {
        this.setTopLeft(component);
    }

    public Component getRight() {
        return this.orientation == Orientation.VERTICAL ? null : this.getBottomRight();
    }

    public void setRight(Component component) {
        this.setBottomRight(component);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null.");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.splitPaneListeners.orientationChanged(this);
        }
    }

    public void setOrientation(String string) {
        if (string == null) {
            throw new IllegalArgumentException("orientation is null.");
        }
        this.setOrientation(Orientation.valueOf(string.toUpperCase()));
    }

    public Region getPrimaryRegion() {
        return this.primaryRegion;
    }

    public void setPrimaryRegion(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("primaryRegion is null.");
        }
        if (this.primaryRegion != region) {
            this.primaryRegion = region;
            this.splitPaneListeners.primaryRegionChanged(this);
        }
    }

    public void setPrimaryRegion(String string) {
        if (string == null) {
            throw new IllegalArgumentException("primaryRegion is null.");
        }
        this.setPrimaryRegion(Region.valueOf(string.toUpperCase()));
    }

    public float getSplitRatio() {
        return this.splitRatio;
    }

    public void setSplitRatio(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("splitRatio must be between 0 and 1.");
        }
        float f2 = this.splitRatio;
        if (f2 != f) {
            this.splitRatio = f;
            this.splitPaneListeners.splitRatioChanged(this, f2);
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        if (this.locked != bl) {
            this.locked = bl;
            this.splitPaneListeners.lockedChanged(this);
        }
    }

    public ResizeMode getResizeMode() {
        return this.resizeMode;
    }

    public void setResizeMode(ResizeMode resizeMode) {
        if (resizeMode == null) {
            throw new IllegalArgumentException("resizeMode is null.");
        }
        ResizeMode resizeMode2 = this.resizeMode;
        if (resizeMode2 != resizeMode) {
            this.resizeMode = resizeMode;
            this.splitPaneListeners.resizeModeChanged(this, resizeMode2);
        }
    }

    public void setResizeMode(String string) {
        if (string == null) {
            throw new IllegalArgumentException("resizeMode is null.");
        }
        this.setResizeMode(ResizeMode.valueOf(string.toUpperCase()));
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (component != this.topLeft && component != this.bottomRight) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    public ListenerList<SplitPaneListener> getSplitPaneListeners() {
        return this.splitPaneListeners;
    }

    private static class SplitPaneListenerList
    extends ListenerList<SplitPaneListener>
    implements SplitPaneListener {
        private SplitPaneListenerList() {
        }

        @Override
        public void topLeftChanged(SplitPane splitPane, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SplitPaneListener splitPaneListener = (SplitPaneListener)iterator.next();
                splitPaneListener.topLeftChanged(splitPane, component);
            }
        }

        @Override
        public void bottomRightChanged(SplitPane splitPane, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SplitPaneListener splitPaneListener = (SplitPaneListener)iterator.next();
                splitPaneListener.bottomRightChanged(splitPane, component);
            }
        }

        @Override
        public void orientationChanged(SplitPane splitPane) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SplitPaneListener splitPaneListener = (SplitPaneListener)iterator.next();
                splitPaneListener.orientationChanged(splitPane);
            }
        }

        @Override
        public void primaryRegionChanged(SplitPane splitPane) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SplitPaneListener splitPaneListener = (SplitPaneListener)iterator.next();
                splitPaneListener.primaryRegionChanged(splitPane);
            }
        }

        @Override
        public void splitRatioChanged(SplitPane splitPane, float f) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SplitPaneListener splitPaneListener = (SplitPaneListener)iterator.next();
                splitPaneListener.splitRatioChanged(splitPane, f);
            }
        }

        @Override
        public void lockedChanged(SplitPane splitPane) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SplitPaneListener splitPaneListener = (SplitPaneListener)iterator.next();
                splitPaneListener.lockedChanged(splitPane);
            }
        }

        @Override
        public void resizeModeChanged(SplitPane splitPane, ResizeMode resizeMode) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SplitPaneListener splitPaneListener = (SplitPaneListener)iterator.next();
                splitPaneListener.resizeModeChanged(splitPane, resizeMode);
            }
        }
    }

    public static enum ResizeMode {
        SPLIT_RATIO,
        PRIMARY_REGION;

    }

    public static enum Region {
        TOP_LEFT,
        BOTTOM_RIGHT;

    }
}

