/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.Vote;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.TabPaneAttributeListener;
import org.apache.pivot.wtk.TabPaneListener;
import org.apache.pivot.wtk.TabPaneSelectionListener;
import org.apache.pivot.wtk.media.Image;

public class TabPane
extends Container {
    private int selectedIndex = -1;
    private ArrayList<Component> tabs = new ArrayList();
    private TabSequence tabSequence = new TabSequence();
    private Component corner = null;
    private TabPaneListenerList tabPaneListeners = new TabPaneListenerList();
    private TabPaneSelectionListenerList tabPaneSelectionListeners = new TabPaneSelectionListenerList();
    private TabPaneAttributeListenerList tabPaneAttributeListeners = new TabPaneAttributeListenerList();

    public TabPane() {
        this.installThemeSkin(TabPane.class);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (n < -1 || n > this.tabs.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.selectedIndex;
        if (n2 != n) {
            Vote vote = this.tabPaneSelectionListeners.previewSelectedIndexChange(this, n);
            if (vote == Vote.APPROVE) {
                this.selectedIndex = n;
                this.tabPaneSelectionListeners.selectedIndexChanged(this, n2);
            } else {
                this.tabPaneSelectionListeners.selectedIndexChangeVetoed(this, vote);
            }
        }
    }

    public Component getSelectedTab() {
        return this.selectedIndex == -1 ? null : (Component)this.tabs.get(this.selectedIndex);
    }

    public TabSequence getTabs() {
        return this.tabSequence;
    }

    public Component getCorner() {
        return this.corner;
    }

    public void setCorner(Component component) {
        Component component2 = this.corner;
        if (component2 != component) {
            this.corner = null;
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                this.insert(component, 0);
            }
            this.corner = component;
            this.tabPaneListeners.cornerChanged(this, component2);
        }
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (component != this.corner && this.tabs.indexOf((Object)component) < 0) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    public ListenerList<TabPaneListener> getTabPaneListeners() {
        return this.tabPaneListeners;
    }

    public ListenerList<TabPaneSelectionListener> getTabPaneSelectionListeners() {
        return this.tabPaneSelectionListeners;
    }

    public ListenerList<TabPaneAttributeListener> getTabPaneAttributeListeners() {
        return this.tabPaneAttributeListeners;
    }

    public static String getLabel(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? null : attributes.label;
    }

    public static void setLabel(Component component, String string) {
        Attributes attributes = (Attributes)component.getAttributes();
        if (attributes == null) {
            throw new IllegalStateException();
        }
        String string2 = attributes.label;
        if (string2 != string) {
            attributes.label = string;
            TabPane tabPane = (TabPane)component.getParent();
            if (tabPane != null) {
                tabPane.tabPaneAttributeListeners.labelChanged(tabPane, component, string2);
            }
        }
    }

    public static Image getIcon(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? null : attributes.icon;
    }

    public static void setIcon(Component component, Image image) {
        Attributes attributes = (Attributes)component.getAttributes();
        if (attributes == null) {
            throw new IllegalStateException();
        }
        Image image2 = attributes.icon;
        if (image2 != image) {
            attributes.icon = image;
            TabPane tabPane = (TabPane)component.getParent();
            if (tabPane != null) {
                tabPane.tabPaneAttributeListeners.iconChanged(tabPane, component, image2);
            }
        }
    }

    public static final void setIcon(Component component, URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("icon is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(uRL);
        if (image == null) {
            try {
                image = Image.load(uRL);
            }
            catch (TaskExecutionException taskExecutionException) {
                throw new IllegalArgumentException(taskExecutionException);
            }
            ApplicationContext.getResourceCache().put(uRL, (Object)image);
        }
        TabPane.setIcon(component, image);
    }

    public static final void setIcon(Component component, String string) {
        if (string == null) {
            throw new IllegalArgumentException("icon is null.");
        }
        ClassLoader classLoader = ThreadUtilities.getClassLoader();
        TabPane.setIcon(component, classLoader.getResource(string));
    }

    public static boolean isCloseable(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? false : attributes.closeable;
    }

    public static void setCloseable(Component component, boolean bl) {
        Attributes attributes = (Attributes)component.getAttributes();
        if (attributes == null) {
            throw new IllegalStateException();
        }
        if (attributes.closeable != bl) {
            attributes.closeable = bl;
            TabPane tabPane = (TabPane)component.getParent();
            if (tabPane != null) {
                tabPane.tabPaneAttributeListeners.closeableChanged(tabPane, component);
            }
        }
    }

    private static class TabPaneAttributeListenerList
    extends ListenerList<TabPaneAttributeListener>
    implements TabPaneAttributeListener {
        private TabPaneAttributeListenerList() {
        }

        @Override
        public void labelChanged(TabPane tabPane, Component component, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TabPaneAttributeListener tabPaneAttributeListener = (TabPaneAttributeListener)iterator.next();
                tabPaneAttributeListener.labelChanged(tabPane, component, string);
            }
        }

        @Override
        public void iconChanged(TabPane tabPane, Component component, Image image) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TabPaneAttributeListener tabPaneAttributeListener = (TabPaneAttributeListener)iterator.next();
                tabPaneAttributeListener.iconChanged(tabPane, component, image);
            }
        }

        @Override
        public void closeableChanged(TabPane tabPane, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TabPaneAttributeListener tabPaneAttributeListener = (TabPaneAttributeListener)iterator.next();
                tabPaneAttributeListener.closeableChanged(tabPane, component);
            }
        }
    }

    private static class TabPaneSelectionListenerList
    extends ListenerList<TabPaneSelectionListener>
    implements TabPaneSelectionListener {
        private TabPaneSelectionListenerList() {
        }

        @Override
        public Vote previewSelectedIndexChange(TabPane tabPane, int n) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TabPaneSelectionListener tabPaneSelectionListener = (TabPaneSelectionListener)iterator.next();
                vote = vote.tally(tabPaneSelectionListener.previewSelectedIndexChange(tabPane, n));
            }
            return vote;
        }

        @Override
        public void selectedIndexChangeVetoed(TabPane tabPane, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TabPaneSelectionListener tabPaneSelectionListener = (TabPaneSelectionListener)iterator.next();
                tabPaneSelectionListener.selectedIndexChangeVetoed(tabPane, vote);
            }
        }

        @Override
        public void selectedIndexChanged(TabPane tabPane, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TabPaneSelectionListener tabPaneSelectionListener = (TabPaneSelectionListener)iterator.next();
                tabPaneSelectionListener.selectedIndexChanged(tabPane, n);
            }
        }
    }

    private static class TabPaneListenerList
    extends ListenerList<TabPaneListener>
    implements TabPaneListener {
        private TabPaneListenerList() {
        }

        @Override
        public void tabInserted(TabPane tabPane, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TabPaneListener tabPaneListener = (TabPaneListener)iterator.next();
                tabPaneListener.tabInserted(tabPane, n);
            }
        }

        @Override
        public void tabsRemoved(TabPane tabPane, int n, Sequence<Component> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TabPaneListener tabPaneListener = (TabPaneListener)iterator.next();
                tabPaneListener.tabsRemoved(tabPane, n, sequence);
            }
        }

        @Override
        public void cornerChanged(TabPane tabPane, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TabPaneListener tabPaneListener = (TabPaneListener)iterator.next();
                tabPaneListener.cornerChanged(tabPane, component);
            }
        }
    }

    private static class Attributes {
        public String label = null;
        public Image icon = null;
        public boolean closeable = false;

        private Attributes() {
        }
    }

    public final class TabSequence
    implements Sequence<Component>,
    Iterable<Component> {
        private TabSequence() {
        }

        public int add(Component component) {
            int n = this.getLength();
            this.insert(component, n);
            return n;
        }

        public void insert(Component component, int n) {
            if (component == null) {
                throw new IllegalArgumentException("tab is null.");
            }
            TabPane.this.add(component);
            TabPane.this.tabs.insert((Object)component, n);
            component.setAttributes(new Attributes());
            if (TabPane.this.selectedIndex >= n) {
                TabPane.this.selectedIndex++;
            }
            TabPane.this.tabPaneListeners.tabInserted(TabPane.this, n);
        }

        public Component update(int n, Component component) {
            throw new UnsupportedOperationException();
        }

        public int remove(Component component) {
            int n = this.indexOf(component);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Component> remove(int n, int n2) {
            int n3;
            Sequence sequence = TabPane.this.tabs.remove(n, n2);
            int n4 = sequence.getLength();
            for (n3 = 0; n3 < n4; ++n3) {
                ((Component)sequence.get(n3)).setAttributes(null);
            }
            if (TabPane.this.selectedIndex >= n) {
                if (TabPane.this.selectedIndex < n + n2) {
                    TabPane.this.selectedIndex = -1;
                } else {
                    TabPane.this.selectedIndex -= n2;
                }
            }
            TabPane.this.tabPaneListeners.tabsRemoved(TabPane.this, n, (Sequence<Component>)sequence);
            n4 = sequence.getLength();
            for (n3 = 0; n3 < n4; ++n3) {
                Component component = (Component)sequence.get(n3);
                TabPane.this.remove(component);
            }
            return sequence;
        }

        public Component get(int n) {
            return (Component)TabPane.this.tabs.get(n);
        }

        public int indexOf(Component component) {
            return TabPane.this.tabs.indexOf((Object)component);
        }

        public int getLength() {
            return TabPane.this.tabs.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)TabPane.this.tabs.iterator());
        }
    }
}

