/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.TablePaneAttributeListener;
import org.apache.pivot.wtk.TablePaneListener;

public class TablePane
extends Container {
    private ArrayList<Row> rows = null;
    private RowSequence rowSequence = new RowSequence();
    private ArrayList<Column> columns = null;
    private ColumnSequence columnSequence = new ColumnSequence();
    private TablePaneListenerList tablePaneListeners = new TablePaneListenerList();
    private TablePaneAttributeListenerList tablePaneAttributeListeners = new TablePaneAttributeListenerList();
    public static final String RELATIVE_SIZE_INDICATOR = "*";

    public TablePane() {
        this((Sequence<Column>)new ArrayList());
    }

    public TablePane(Sequence<Column> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("columns is null");
        }
        this.rows = new ArrayList();
        this.columns = new ArrayList(sequence);
        this.installThemeSkin(TablePane.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public RowSequence getRows() {
        return this.rowSequence;
    }

    public int getRowAt(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getRowAt(n);
    }

    public Bounds getRowBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getRowBounds(n);
    }

    public ColumnSequence getColumns() {
        return this.columnSequence;
    }

    public int getColumnAt(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getColumnAt(n);
    }

    public Bounds getColumnBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getColumnBounds(n);
    }

    public Component getCellComponent(int n, int n2) {
        Row row = (Row)this.rows.get(n);
        Component component = null;
        if (row.getLength() > n2) {
            component = row.get(n2);
        }
        return component;
    }

    public void setCellComponent(int n, int n2, Component component) {
        ((Row)this.rows.get(n)).update(n2, component);
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            for (Row row : this.rows) {
                if (row.indexOf(component) < 0) continue;
                throw new UnsupportedOperationException();
            }
        }
        return super.remove(n, n2);
    }

    public ListenerList<TablePaneListener> getTablePaneListeners() {
        return this.tablePaneListeners;
    }

    public ListenerList<TablePaneAttributeListener> getTablePaneAttributeListeners() {
        return this.tablePaneAttributeListeners;
    }

    public static int getRowSpan(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? -1 : attributes.rowSpan;
    }

    public static void setRowSpan(Component component, int n) {
        Attributes attributes = (Attributes)component.getAttributes();
        if (attributes == null) {
            throw new UnsupportedOperationException();
        }
        int n2 = attributes.rowSpan;
        if (n2 != n) {
            attributes.rowSpan = n;
            TablePane tablePane = (TablePane)component.getParent();
            if (tablePane != null) {
                tablePane.tablePaneAttributeListeners.rowSpanChanged(tablePane, component, n2);
            }
        }
    }

    public static int getColumnSpan(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? -1 : attributes.columnSpan;
    }

    public static void setColumnSpan(Component component, int n) {
        Attributes attributes = (Attributes)component.getAttributes();
        if (attributes == null) {
            throw new UnsupportedOperationException();
        }
        int n2 = attributes.columnSpan;
        if (n2 != n) {
            attributes.columnSpan = n;
            TablePane tablePane = (TablePane)component.getParent();
            if (tablePane != null) {
                tablePane.tablePaneAttributeListeners.columnSpanChanged(tablePane, component, n2);
            }
        }
    }

    private static class TablePaneAttributeListenerList
    extends ListenerList<TablePaneAttributeListener>
    implements TablePaneAttributeListener {
        private TablePaneAttributeListenerList() {
        }

        @Override
        public void rowSpanChanged(TablePane tablePane, Component component, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneAttributeListener tablePaneAttributeListener = (TablePaneAttributeListener)iterator.next();
                tablePaneAttributeListener.rowSpanChanged(tablePane, component, n);
            }
        }

        @Override
        public void columnSpanChanged(TablePane tablePane, Component component, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneAttributeListener tablePaneAttributeListener = (TablePaneAttributeListener)iterator.next();
                tablePaneAttributeListener.columnSpanChanged(tablePane, component, n);
            }
        }
    }

    private static class TablePaneListenerList
    extends ListenerList<TablePaneListener>
    implements TablePaneListener {
        private TablePaneListenerList() {
        }

        @Override
        public void rowInserted(TablePane tablePane, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.rowInserted(tablePane, n);
            }
        }

        @Override
        public void rowsRemoved(TablePane tablePane, int n, Sequence<Row> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.rowsRemoved(tablePane, n, sequence);
            }
        }

        @Override
        public void rowHeightChanged(Row row, int n, boolean bl) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.rowHeightChanged(row, n, bl);
            }
        }

        @Override
        public void rowHighlightedChanged(Row row) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.rowHighlightedChanged(row);
            }
        }

        @Override
        public void columnInserted(TablePane tablePane, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.columnInserted(tablePane, n);
            }
        }

        @Override
        public void columnsRemoved(TablePane tablePane, int n, Sequence<Column> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.columnsRemoved(tablePane, n, sequence);
            }
        }

        @Override
        public void columnWidthChanged(Column column, int n, boolean bl) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.columnWidthChanged(column, n, bl);
            }
        }

        @Override
        public void columnHighlightedChanged(Column column) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.columnHighlightedChanged(column);
            }
        }

        @Override
        public void cellInserted(Row row, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.cellInserted(row, n);
            }
        }

        @Override
        public void cellsRemoved(Row row, int n, Sequence<Component> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.cellsRemoved(row, n, sequence);
            }
        }

        @Override
        public void cellUpdated(Row row, int n, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TablePaneListener tablePaneListener = (TablePaneListener)iterator.next();
                tablePaneListener.cellUpdated(row, n, component);
            }
        }
    }

    private static class Attributes {
        public int rowSpan = 1;
        public int columnSpan = 1;

        private Attributes() {
        }
    }

    public static class Filler
    extends Component {
        public Filler() {
            this.installThemeSkin(Filler.class);
        }
    }

    public final class ColumnSequence
    implements Sequence<Column>,
    Iterable<Column> {
        private ColumnSequence() {
        }

        public int add(Column column) {
            int n = this.getLength();
            this.insert(column, n);
            return n;
        }

        public void insert(Column column, int n) {
            if (column == null) {
                throw new IllegalArgumentException("column is null.");
            }
            if (column.getTablePane() != null) {
                throw new IllegalArgumentException("column is already in use by another table pane.");
            }
            TablePane.this.columns.insert((Object)column, n);
            column.setTablePane(TablePane.this);
            TablePane.this.tablePaneListeners.columnInserted(TablePane.this, n);
        }

        public Column update(int n, Column column) {
            throw new UnsupportedOperationException();
        }

        public int remove(Column column) {
            int n = this.indexOf(column);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Column> remove(int n, int n2) {
            Sequence sequence = TablePane.this.columns.remove(n, n2);
            if (n2 > 0) {
                int n3 = sequence.getLength();
                for (int i = 0; i < n3; ++i) {
                    Column column = (Column)sequence.get(i);
                    column.setTablePane(null);
                }
                TablePane.this.tablePaneListeners.columnsRemoved(TablePane.this, n, (Sequence<Column>)sequence);
            }
            return sequence;
        }

        public Column get(int n) {
            return (Column)TablePane.this.columns.get(n);
        }

        public int indexOf(Column column) {
            return TablePane.this.columns.indexOf((Object)column);
        }

        public int getLength() {
            return TablePane.this.columns.getLength();
        }

        @Override
        public Iterator<Column> iterator() {
            return new ImmutableIterator((Iterator)TablePane.this.columns.iterator());
        }
    }

    public final class RowSequence
    implements Sequence<Row>,
    Iterable<Row> {
        private RowSequence() {
        }

        public int add(Row row) {
            int n = this.getLength();
            this.insert(row, n);
            return n;
        }

        public void insert(Row row, int n) {
            if (row == null) {
                throw new IllegalArgumentException("row is null.");
            }
            if (row.getTablePane() != null) {
                throw new IllegalArgumentException("row is already in use by another table pane.");
            }
            TablePane.this.rows.insert((Object)row, n);
            row.setTablePane(TablePane.this);
            int n2 = row.getLength();
            for (int i = 0; i < n2; ++i) {
                Component component = row.get(i);
                TablePane.this.add(component);
            }
            TablePane.this.tablePaneListeners.rowInserted(TablePane.this, n);
        }

        public Row update(int n, Row row) {
            throw new UnsupportedOperationException();
        }

        public int remove(Row row) {
            int n = this.indexOf(row);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Row> remove(int n, int n2) {
            Sequence sequence = TablePane.this.rows.remove(n, n2);
            if (n2 > 0) {
                int n3 = sequence.getLength();
                for (int i = 0; i < n3; ++i) {
                    Row row = (Row)sequence.get(i);
                    row.setTablePane(null);
                    int n4 = row.getLength();
                    for (int j = 0; j < n4; ++j) {
                        Component component = row.get(j);
                        TablePane.this.remove(component);
                    }
                }
                TablePane.this.tablePaneListeners.rowsRemoved(TablePane.this, n, (Sequence<Row>)sequence);
            }
            return sequence;
        }

        public Row get(int n) {
            return (Row)TablePane.this.rows.get(n);
        }

        public int indexOf(Row row) {
            return TablePane.this.rows.indexOf((Object)row);
        }

        public int getLength() {
            return TablePane.this.rows.getLength();
        }

        @Override
        public Iterator<Row> iterator() {
            return new ImmutableIterator((Iterator)TablePane.this.rows.iterator());
        }
    }

    public static interface Skin {
        public int getRowAt(int var1);

        public Bounds getRowBounds(int var1);

        public int getColumnAt(int var1);

        public Bounds getColumnBounds(int var1);
    }

    public static class Column {
        private TablePane tablePane = null;
        private int width;
        private boolean relative;
        private boolean highlighted;

        public Column() {
            this(-1, false, false);
        }

        public Column(int n) {
            this(n, false, false);
        }

        public Column(int n, boolean bl) {
            this(n, bl, false);
        }

        public Column(int n, boolean bl, boolean bl2) {
            this.width = n;
            this.relative = bl;
            this.highlighted = bl2;
        }

        public TablePane getTablePane() {
            return this.tablePane;
        }

        private void setTablePane(TablePane tablePane) {
            this.tablePane = tablePane;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void setWidth(int n) {
            this.setWidth(n, false);
        }

        public void setWidth(String string) {
            boolean bl = false;
            if (string.endsWith(TablePane.RELATIVE_SIZE_INDICATOR)) {
                bl = true;
                string = string.substring(0, string.length() - 1);
            }
            this.setWidth(Integer.parseInt(string), bl);
        }

        public void setWidth(int n, boolean bl) {
            int n2 = this.width;
            boolean bl2 = this.relative;
            if (n2 != n || bl2 != bl) {
                this.width = n;
                this.relative = bl;
                if (this.tablePane != null) {
                    this.tablePane.tablePaneListeners.columnWidthChanged(this, n2, bl2);
                }
            }
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public void setHighlighted(boolean bl) {
            if (bl != this.highlighted) {
                this.highlighted = bl;
                if (this.tablePane != null) {
                    this.tablePane.tablePaneListeners.columnHighlightedChanged(this);
                }
            }
        }

        public void setVisible(boolean bl) {
            if (this.tablePane != null) {
                int n = this.tablePane.columns.indexOf((Object)this);
                for (Row row : this.tablePane.rows) {
                    if (row.getLength() <= n) continue;
                    row.get(n).setVisible(bl);
                }
            }
        }
    }

    public static final class Row
    implements Sequence<Component>,
    Iterable<Component> {
        private int height;
        private boolean relative;
        private boolean highlighted;
        private ArrayList<Component> cells = new ArrayList();
        private TablePane tablePane = null;

        public Row() {
            this(-1, false, false);
        }

        public Row(int n) {
            this(n, false, false);
        }

        public Row(int n, boolean bl) {
            this(n, bl, false);
        }

        public Row(int n, boolean bl, boolean bl2) {
            this.height = n;
            this.relative = bl;
            this.highlighted = bl2;
        }

        public TablePane getTablePane() {
            return this.tablePane;
        }

        private void setTablePane(TablePane tablePane) {
            this.tablePane = tablePane;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void setHeight(int n) {
            this.setHeight(n, false);
        }

        public void setHeight(String string) {
            boolean bl = false;
            if (string.endsWith(TablePane.RELATIVE_SIZE_INDICATOR)) {
                bl = true;
                string = string.substring(0, string.length() - 1);
            }
            this.setHeight(Integer.parseInt(string), bl);
        }

        public void setHeight(int n, boolean bl) {
            int n2 = this.height;
            boolean bl2 = this.relative;
            if (n2 != n || bl2 != bl) {
                this.height = n;
                this.relative = bl;
                if (this.tablePane != null) {
                    this.tablePane.tablePaneListeners.rowHeightChanged(this, n2, bl2);
                }
            }
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public void setHighlighted(boolean bl) {
            if (bl != this.highlighted) {
                this.highlighted = bl;
                if (this.tablePane != null) {
                    this.tablePane.tablePaneListeners.rowHighlightedChanged(this);
                }
            }
        }

        public void setVisible(boolean bl) {
            if (this.tablePane != null) {
                for (Component component : this.cells) {
                    component.setVisible(bl);
                }
            }
        }

        public int add(Component component) {
            int n = this.getLength();
            this.insert(component, n);
            return n;
        }

        public void insert(Component component, int n) {
            if (component == null) {
                throw new IllegalArgumentException("Component is null.");
            }
            if (component.getParent() != null) {
                throw new IllegalArgumentException("Component already has a parent.");
            }
            this.cells.insert((Object)component, n);
            component.setAttributes(new Attributes());
            if (this.tablePane != null) {
                this.tablePane.add(component);
                this.tablePane.tablePaneListeners.cellInserted(this, n);
            }
        }

        public Component update(int n, Component component) {
            Component component2 = (Component)this.cells.get(n);
            if (component != component2) {
                if (component == null) {
                    throw new IllegalArgumentException("Component is null.");
                }
                if (component.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                this.cells.update(n, (Object)component);
                component2.setAttributes(null);
                component.setAttributes(new Attributes());
                if (this.tablePane != null) {
                    this.tablePane.add(component);
                    this.tablePane.tablePaneListeners.cellUpdated(this, n, component2);
                    this.tablePane.remove(component2);
                }
            }
            return component2;
        }

        public int remove(Component component) {
            int n = this.indexOf(component);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Component> remove(int n, int n2) {
            Component component;
            int n3;
            Sequence sequence = this.cells.remove(n, n2);
            int n4 = sequence.getLength();
            for (n3 = 0; n3 < n4; ++n3) {
                component = (Component)sequence.get(n3);
                component.setAttributes(null);
            }
            if (this.tablePane != null) {
                this.tablePane.tablePaneListeners.cellsRemoved(this, n, (Sequence<Component>)sequence);
                n4 = sequence.getLength();
                for (n3 = 0; n3 < n4; ++n3) {
                    component = (Component)sequence.get(n3);
                    this.tablePane.remove(component);
                }
            }
            return sequence;
        }

        public Component get(int n) {
            return (Component)this.cells.get(n);
        }

        public int indexOf(Component component) {
            return this.cells.indexOf((Object)component);
        }

        public int getLength() {
            return this.cells.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)this.cells.iterator());
        }
    }
}

