/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ViewportListener;

public abstract class Viewport
extends Container {
    private int scrollTop = 0;
    private int scrollLeft = 0;
    private Component view;
    private boolean consumeRepaint = false;
    private ViewportListenerList viewportListeners = new ViewportListenerList();

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public int getScrollTop() {
        return this.scrollTop;
    }

    public void setScrollTop(int n) {
        int n2 = this.scrollTop;
        if (n != n2) {
            this.scrollTop = n;
            this.viewportListeners.scrollTopChanged(this, n2);
        }
    }

    public int getScrollLeft() {
        return this.scrollLeft;
    }

    public void setScrollLeft(int n) {
        int n2 = this.scrollLeft;
        if (n != n2) {
            this.scrollLeft = n;
            this.viewportListeners.scrollLeftChanged(this, n2);
        }
    }

    public Component getView() {
        return this.view;
    }

    public void setView(Component component) {
        Component component2 = this.view;
        if (component != component2) {
            this.view = null;
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                this.insert(component, 0);
            }
            this.view = component;
            this.viewportListeners.viewChanged(this, component2);
        }
    }

    public boolean isConsumeRepaint() {
        return this.consumeRepaint;
    }

    public void setConsumeRepaint(boolean bl) {
        this.consumeRepaint = bl;
    }

    public Bounds getViewportBounds() {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getViewportBounds();
    }

    @Override
    public void repaint(int n, int n2, int n3, int n4, boolean bl) {
        if (!this.consumeRepaint) {
            super.repaint(n, n2, n3, n4, bl);
        }
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (component != this.view) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    public ListenerList<ViewportListener> getViewportListeners() {
        return this.viewportListeners;
    }

    private static class ViewportListenerList
    extends ListenerList<ViewportListener>
    implements ViewportListener {
        private ViewportListenerList() {
        }

        @Override
        public void scrollTopChanged(Viewport viewport, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ViewportListener viewportListener = (ViewportListener)iterator.next();
                viewportListener.scrollTopChanged(viewport, n);
            }
        }

        @Override
        public void scrollLeftChanged(Viewport viewport, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ViewportListener viewportListener = (ViewportListener)iterator.next();
                viewportListener.scrollLeftChanged(viewport, n);
            }
        }

        @Override
        public void viewChanged(Viewport viewport, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ViewportListener viewportListener = (ViewportListener)iterator.next();
                viewportListener.viewChanged(viewport, component);
            }
        }
    }

    public static interface Skin {
        public Bounds getViewportBounds();
    }
}

