/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.ListenerList;

public class CalendarDateSpinnerData
implements List<CalendarDate> {
    private GregorianCalendar calendar;
    private int calendarIndex;
    private transient int length;
    private List.ListListenerList<CalendarDate> listListeners = new List.ListListenerList();

    public CalendarDateSpinnerData() {
        this(new CalendarDate(1900, 0, 0), new CalendarDate(2099, 11, 30));
    }

    public CalendarDateSpinnerData(CalendarDate calendarDate, CalendarDate calendarDate2) {
        if (calendarDate == null) {
            throw new IllegalArgumentException("lowerBound is null.");
        }
        if (calendarDate2 == null) {
            throw new IllegalArgumentException("upperBound is null.");
        }
        if (calendarDate.compareTo(calendarDate2) > 0) {
            throw new IllegalArgumentException("lowerBound is after upperBound.");
        }
        this.calendar = new GregorianCalendar(calendarDate.year, calendarDate.month, calendarDate.day + 1);
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.calendarIndex = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(calendarDate2.year, calendarDate2.month, calendarDate2.day + 1);
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        long l = this.calendar.getTimeInMillis();
        long l2 = gregorianCalendar.getTimeInMillis();
        long l3 = (l2 - l) / 86400000L;
        this.length = (int)l3 + 1;
    }

    public int add(CalendarDate calendarDate) {
        throw new UnsupportedOperationException();
    }

    public void insert(CalendarDate calendarDate, int n) {
        throw new UnsupportedOperationException();
    }

    public CalendarDate update(int n, CalendarDate calendarDate) {
        throw new UnsupportedOperationException();
    }

    public int remove(CalendarDate calendarDate) {
        throw new UnsupportedOperationException();
    }

    public Sequence<CalendarDate> remove(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public CalendarDate get(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n);
        }
        this.calendar.add(6, n - this.calendarIndex);
        this.calendarIndex = n;
        int n2 = this.calendar.get(1);
        int n3 = this.calendar.get(2);
        int n4 = this.calendar.get(5) - 1;
        return new CalendarDate(n2, n3, n4);
    }

    public int indexOf(CalendarDate calendarDate) {
        long l = this.calendar.getTimeInMillis();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(calendarDate.year, calendarDate.month, calendarDate.day + 1);
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        long l2 = gregorianCalendar.getTimeInMillis();
        long l3 = (l2 - l) / 86400000L;
        int n = this.calendarIndex + (int)l3;
        return n < 0 || n >= this.length ? -1 : n;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int getLength() {
        return this.length;
    }

    public Comparator<CalendarDate> getComparator() {
        return null;
    }

    public void setComparator(Comparator<CalendarDate> comparator) {
        throw new UnsupportedOperationException();
    }

    public Iterator<CalendarDate> iterator() {
        return new DataIterator();
    }

    public ListenerList<ListListener<CalendarDate>> getListListeners() {
        return this.listListeners;
    }

    private class DataIterator
    implements Iterator<CalendarDate> {
        private int index = 0;

        private DataIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < CalendarDateSpinnerData.this.length;
        }

        @Override
        public CalendarDate next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return CalendarDateSpinnerData.this.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

