/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import org.apache.pivot.wtk.GraphicsUtilities;

public class ColorItem {
    private Color color;
    private String name;

    public ColorItem() {
        this(Color.BLACK, null);
    }

    public ColorItem(Color color) {
        this(color, null);
    }

    public ColorItem(Color color, String string) {
        this.setColor(color);
        this.setName(string);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
    }

    public void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(string));
    }

    public String getName() {
        String string = this.name;
        if (string == null) {
            string = String.format("#%02X%02X%02X", this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        }
        return string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean equals(Object object) {
        return object instanceof ColorItem && ((ColorItem)object).color.equals(this.color);
    }

    public int hashCode() {
        return this.color.hashCode();
    }
}

