/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TextDecoration;
import org.apache.pivot.wtk.content.ButtonData;
import org.apache.pivot.wtk.media.Image;

public class LinkButtonDataRenderer
extends TablePane
implements Button.DataRenderer {
    protected ImageView imageView = new ImageView();
    protected Label label = new Label();

    public LinkButtonDataRenderer() {
        this.getStyles().put("horizontalSpacing", (Object)4);
        this.getColumns().add(new TablePane.Column());
        this.getColumns().add(new TablePane.Column(1, true));
        TablePane.Row row = new TablePane.Row();
        row.add(this.imageView);
        row.add(this.label);
        this.getRows().add(row);
        this.label.getStyles().put("wrapText", (Object)true);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.validate();
    }

    @Override
    public void render(Object object, Button button, boolean bl) {
        Object object2;
        Image image = null;
        String string = null;
        if (object instanceof ButtonData) {
            object2 = (ButtonData)object;
            image = ((ButtonData)object2).getIcon();
            string = ((ButtonData)object2).getText();
        } else if (object instanceof Image) {
            image = (Image)object;
        } else if (object != null) {
            string = object.toString();
        }
        if (image == null) {
            this.imageView.setVisible(false);
        } else {
            this.imageView.setVisible(true);
            this.imageView.setImage(image);
            this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() ? 1.0f : 0.5f));
        }
        this.label.setText(string);
        if (string == null) {
            this.label.setVisible(false);
        } else {
            this.label.setVisible(true);
            object2 = (Font)button.getStyles().get("font");
            this.label.getStyles().put("font", object2);
            Color color = button.isEnabled() ? (Color)button.getStyles().get("color") : (Color)button.getStyles().get("disabledColor");
            this.label.getStyles().put("color", (Object)color);
        }
        this.label.getStyles().put("textDecoration", (Object)(bl ? TextDecoration.UNDERLINE : null));
    }
}

