/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import org.apache.pivot.collections.List;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.ListViewItemListener;
import org.apache.pivot.wtk.ListViewListener;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.content.ListItem;
import org.apache.pivot.wtk.content.ListViewItemRenderer;

public class ListViewItemEditor
implements ListView.ItemEditor {
    private ListView listView = null;
    private int index = -1;
    private TextInput textInput = null;
    private Window popup = null;
    private ListView.ItemEditor.ItemEditorListenerList itemEditorListeners = new ListView.ItemEditor.ItemEditorListenerList();
    private ComponentListener componentListener = new ComponentListener.Adapter(){

        @Override
        public void sizeChanged(Component component, int n, int n2) {
            ApplicationContext.queueCallback(new Runnable(){

                @Override
                public void run() {
                    ListViewItemEditor.this.reposition();
                }
            });
        }

        @Override
        public void locationChanged(Component component, int n, int n2) {
            ApplicationContext.queueCallback(new Runnable(){

                @Override
                public void run() {
                    ListViewItemEditor.this.reposition();
                }
            });
        }
    };
    private ListViewListener listViewListener = new ListViewListener.Adapter(){

        @Override
        public void listDataChanged(ListView listView, List<?> list) {
            ListViewItemEditor.this.cancelEdit();
        }

        @Override
        public void itemEditorChanged(ListView listView, ListView.ItemEditor itemEditor) {
            ListViewItemEditor.this.cancelEdit();
        }
    };
    private ListViewItemListener listViewItemListener = new ListViewItemListener.Adapter(){

        @Override
        public void itemInserted(ListView listView, int n) {
            ListViewItemEditor.this.cancelEdit();
        }

        @Override
        public void itemsRemoved(ListView listView, int n, int n2) {
            ListViewItemEditor.this.cancelEdit();
        }

        @Override
        public void itemUpdated(ListView listView, int n) {
            ListViewItemEditor.this.cancelEdit();
        }

        @Override
        public void itemsSorted(ListView listView) {
            ListViewItemEditor.this.cancelEdit();
        }
    };
    private ComponentKeyListener textInputKeyHandler = new ComponentKeyListener.Adapter(){

        @Override
        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            if (n == 10) {
                ListViewItemEditor.this.saveChanges();
            } else if (n == 27) {
                ListViewItemEditor.this.cancelEdit();
            }
            return false;
        }
    };
    private WindowStateListener popupWindowStateHandler = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)ListViewItemEditor.this.displayMouseHandler);
            ListViewItemEditor.this.listView.getComponentListeners().add((Object)ListViewItemEditor.this.componentListener);
            ListViewItemEditor.this.listView.getListViewListeners().add((Object)ListViewItemEditor.this.listViewListener);
            ListViewItemEditor.this.listView.getListViewItemListeners().add((Object)ListViewItemEditor.this.listViewItemListener);
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            display.getContainerMouseListeners().remove((Object)ListViewItemEditor.this.displayMouseHandler);
            ListViewItemEditor.this.listView.getComponentListeners().remove((Object)ListViewItemEditor.this.componentListener);
            ListViewItemEditor.this.listView.getListViewListeners().remove((Object)ListViewItemEditor.this.listViewListener);
            ListViewItemEditor.this.listView.getListViewItemListeners().remove((Object)ListViewItemEditor.this.listViewItemListener);
            window2.moveToFront();
            ListViewItemEditor.this.listView = null;
            ListViewItemEditor.this.index = -1;
            ListViewItemEditor.this.textInput = null;
            ListViewItemEditor.this.popup = null;
        }
    };
    private ContainerMouseListener displayMouseHandler = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(n, n2);
            if (ListViewItemEditor.this.popup != window) {
                ListViewItemEditor.this.saveChanges();
            }
            return false;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            return true;
        }
    };

    @Override
    public void editItem(ListView listView, int n) {
        if (this.listView != null) {
            throw new IllegalStateException("Currently editing.");
        }
        Vote vote = this.itemEditorListeners.previewEditItem(this, listView, n);
        if (vote == Vote.APPROVE) {
            this.listView = listView;
            this.index = n;
            List<?> list = listView.getListData();
            ListItem listItem = (ListItem)list.get(n);
            this.textInput = new TextInput();
            this.textInput.setText(listItem.getText());
            this.textInput.getComponentKeyListeners().add((Object)this.textInputKeyHandler);
            this.popup = new Window(this.textInput);
            this.popup.getWindowStateListeners().add((Object)this.popupWindowStateHandler);
            this.popup.open(listView.getWindow());
            this.reposition();
            this.textInput.selectAll();
            this.textInput.requestFocus();
            this.itemEditorListeners.itemEditing(this, listView, n);
        } else if (vote == Vote.DENY) {
            this.itemEditorListeners.editItemVetoed(this, vote);
        }
    }

    private void reposition() {
        List<?> list = this.listView.getListData();
        ListItem listItem = (ListItem)list.get(this.index);
        Bounds bounds = this.listView.getItemBounds(this.index);
        int n = this.listView.getItemIndent();
        bounds = new Bounds(bounds.x + n, bounds.y, bounds.width - n, bounds.height);
        ListViewItemRenderer listViewItemRenderer = (ListViewItemRenderer)this.listView.getItemRenderer();
        listViewItemRenderer.render(listItem, this.index, this.listView, false, false, false, false);
        listViewItemRenderer.setSize(bounds.width, bounds.height);
        Bounds bounds2 = listViewItemRenderer.getTextBounds();
        Insets insets = (Insets)this.textInput.getStyles().get("padding");
        Bounds bounds3 = new Bounds(bounds.x + bounds2.x - (insets.left + 1), bounds.y, bounds.width - bounds2.x + (insets.left + 1), bounds.height);
        this.listView.scrollAreaToVisible(bounds3.x, bounds3.y, bounds2.width + insets.left + 1, bounds3.height);
        bounds3 = this.listView.getVisibleArea(bounds3);
        Point point = this.listView.mapPointToAncestor(this.listView.getDisplay(), bounds3.x, bounds3.y);
        this.textInput.setPreferredWidth(bounds3.width);
        this.popup.setLocation(point.x, point.y + (bounds3.height - this.textInput.getPreferredHeight(-1)) / 2);
    }

    @Override
    public boolean isEditing() {
        return this.listView != null;
    }

    @Override
    public void saveChanges() {
        if (!this.isEditing()) {
            throw new IllegalStateException();
        }
        ListView listView = this.listView;
        int n = this.index;
        String string = this.textInput.getText();
        Vote vote = this.itemEditorListeners.previewSaveChanges(this, listView, n, string);
        if (vote == Vote.APPROVE) {
            List<?> list = listView.getListData();
            ListItem listItem = (ListItem)list.get(n);
            listItem.setText(string);
            if (list.getComparator() == null) {
                list.update(n, (Object)listItem);
            } else {
                list.remove(n, 1);
                list.add((Object)listItem);
                n = list.indexOf((Object)listItem);
                listView.setSelectedIndex(n);
                listView.scrollAreaToVisible(listView.getItemBounds(n));
            }
            this.itemEditorListeners.changesSaved(this, listView, n);
        } else if (vote == Vote.DENY) {
            this.itemEditorListeners.saveChangesVetoed(this, vote);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            throw new IllegalStateException();
        }
        ListView listView = this.listView;
        int n = this.index;
        this.popup.close();
        this.itemEditorListeners.editCancelled(this, listView, n);
    }

    @Override
    public ListenerList<ListView.ItemEditorListener> getItemEditorListeners() {
        return this.itemEditorListeners;
    }
}

