/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.ListItem;
import org.apache.pivot.wtk.media.Image;

public class ListViewItemRenderer
extends BoxPane
implements ListView.ItemRenderer {
    protected ImageView imageView = new ImageView();
    protected Label label = new Label();
    public static final int DEFAULT_ICON_WIDTH = 16;
    public static final int DEFAULT_ICON_HEIGHT = 16;
    public static boolean DEFAULT_SHOW_ICON = false;

    public ListViewItemRenderer() {
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.getStyles().put("padding", (Object)new Insets(2, 3, 2, 3));
        this.add(this.imageView);
        this.add(this.label);
        this.imageView.setVisible(DEFAULT_SHOW_ICON);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.validate();
    }

    @Override
    public void render(Object object, int n, ListView listView, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.renderStyles(listView, bl, bl3, bl4);
        Image image = null;
        String string = null;
        if (object instanceof ListItem) {
            ListItem listItem = (ListItem)object;
            image = listItem.getIcon();
            string = listItem.getText();
        } else if (object instanceof Image) {
            image = (Image)object;
        } else if (object != null) {
            string = object.toString();
        }
        this.imageView.setImage(image);
        this.label.setText(string);
    }

    protected void renderStyles(ListView listView, boolean bl, boolean bl2, boolean bl3) {
        this.imageView.getStyles().put("opacity", (Object)Float.valueOf(listView.isEnabled() ? 1.0f : 0.5f));
        Font font = (Font)listView.getStyles().get("font");
        this.label.getStyles().put("font", (Object)font);
        Color color = listView.isEnabled() && !bl3 ? (bl ? (listView.isFocused() ? (Color)listView.getStyles().get("selectionColor") : (Color)listView.getStyles().get("inactiveSelectionColor")) : (Color)listView.getStyles().get("color")) : (Color)listView.getStyles().get("disabledColor");
        this.label.getStyles().put("color", (Object)color);
    }

    public int getIconWidth() {
        return this.imageView.getPreferredWidth(-1);
    }

    public void setIconWidth(int n) {
        this.imageView.setPreferredWidth(n);
    }

    public int getIconHeight() {
        return this.imageView.getPreferredHeight(-1);
    }

    public void setIconHeight(int n) {
        this.imageView.setPreferredHeight(n);
    }

    public boolean getShowIcon() {
        return this.imageView.isVisible();
    }

    public void setShowIcon(boolean bl) {
        this.imageView.setVisible(bl);
    }

    public Bounds getTextBounds() {
        return this.label.isVisible() ? this.label.getBounds() : null;
    }
}

