/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.ButtonData;
import org.apache.pivot.wtk.content.MenuItemData;
import org.apache.pivot.wtk.media.Image;

public class MenuItemDataRenderer
extends TablePane
implements Button.DataRenderer {
    protected ImageView imageView = new ImageView();
    protected Label textLabel = new Label();
    protected Label keyboardShortcutLabel = new Label();

    public MenuItemDataRenderer() {
        this.getStyles().put("padding", (Object)new Insets(2));
        this.getColumns().add(new TablePane.Column(1, true));
        this.getColumns().add(new TablePane.Column());
        BoxPane boxPane = new BoxPane();
        boxPane.add(this.imageView);
        boxPane.add(this.textLabel);
        boxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        boxPane.getStyles().put("padding", (Object)new Insets(0, 0, 0, 6));
        TablePane.Row row = new TablePane.Row();
        row.add(boxPane);
        row.add(this.keyboardShortcutLabel);
        this.getRows().add(row);
        this.imageView.getStyles().put("backgroundColor", null);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.validate();
    }

    @Override
    public void render(Object object, Button button, boolean bl) {
        Object object2;
        Object object3;
        Image image = null;
        String string = null;
        Keyboard.KeyStroke keyStroke = null;
        if (object instanceof ButtonData) {
            object3 = (ButtonData)object;
            image = ((ButtonData)object3).getIcon();
            string = ((ButtonData)object3).getText();
            if (object3 instanceof MenuItemData) {
                object2 = (MenuItemData)object3;
                keyStroke = ((MenuItemData)object2).getKeyboardShortcut();
            }
        } else if (object instanceof Image) {
            image = (Image)object;
        } else if (object != null) {
            string = object.toString();
        }
        if (button.isSelected()) {
            image = (Image)button.getStyles().get("checkmarkImage");
        }
        object3 = (Menu.Item)button;
        object2 = (Menu)((Component)object3).getParent();
        int n = (Integer)((Component)object2).getStyles().get("margin");
        Insets insets = (Insets)this.getStyles().get("padding");
        this.imageView.setImage(image);
        this.imageView.setPreferredWidth(n - insets.left * 2);
        this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() ? 1.0f : 0.5f));
        this.textLabel.setText(string);
        Font font = (Font)((Component)object2).getStyles().get("font");
        this.textLabel.getStyles().put("font", (Object)font);
        this.keyboardShortcutLabel.getStyles().put("font", (Object)font.deriveFont(2));
        Color color = button.isEnabled() ? (bl ? (Color)((Component)object2).getStyles().get("activeColor") : (Color)((Component)object2).getStyles().get("color")) : (Color)((Component)object2).getStyles().get("disabledColor");
        this.textLabel.getStyles().put("color", (Object)color);
        this.keyboardShortcutLabel.getStyles().put("color", (Object)color);
        boolean bl2 = false;
        if (((Component)object2).getStyles().containsKey("showKeyboardShortcuts")) {
            bl2 = (Boolean)((Component)object2).getStyles().get("showKeyboardShortcuts");
        }
        if (bl2) {
            this.keyboardShortcutLabel.setVisible(true);
            this.keyboardShortcutLabel.setText(keyStroke == null ? null : keyStroke.toString());
        } else {
            this.keyboardShortcutLabel.setVisible(false);
        }
    }
}

