/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public class NumericSpinnerData
implements List<Integer> {
    private int lowerBound;
    private int upperBound;
    private int increment;
    private List.ListListenerList<Integer> listListeners = new List.ListListenerList();

    public NumericSpinnerData() {
        this(Short.MIN_VALUE, Short.MAX_VALUE, 1);
    }

    public NumericSpinnerData(int n, int n2) {
        this(n, n2, 1);
    }

    public NumericSpinnerData(int n, int n2, int n3) {
        if (n >= n2) {
            throw new IllegalArgumentException("Lower bound must be less than upper bound.");
        }
        long l = (n2 - n) / n3 + 1;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Bounded range is too large.");
        }
        this.lowerBound = n;
        this.upperBound = n2;
        this.increment = n3;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int n) {
        this.lowerBound = n;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int n) {
        this.upperBound = n;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int n) {
        this.increment = n;
    }

    public int add(Integer n) {
        throw new UnsupportedOperationException();
    }

    public void insert(Integer n, int n2) {
        throw new UnsupportedOperationException();
    }

    public Integer update(int n, Integer n2) {
        throw new UnsupportedOperationException();
    }

    public int remove(Integer n) {
        throw new UnsupportedOperationException();
    }

    public Sequence<Integer> remove(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public Integer get(int n) {
        if (n < 0 || n >= this.getLength()) {
            throw new IndexOutOfBoundsException("Invalid index: " + n);
        }
        return this.lowerBound + n * this.increment;
    }

    public int indexOf(Integer n) {
        int n2;
        int n3 = -1;
        if (n >= this.lowerBound && n <= this.upperBound && (n2 = n - this.lowerBound) % this.increment == 0) {
            n3 = n2 / this.increment;
        }
        return n3;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.getLength() == 0;
    }

    public int getLength() {
        return (this.upperBound - this.lowerBound) / this.increment + 1;
    }

    public Comparator<Integer> getComparator() {
        return null;
    }

    public void setComparator(Comparator<Integer> comparator) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Integer> iterator() {
        return new DataIterator();
    }

    public ListenerList<ListListener<Integer>> getListListeners() {
        return this.listListeners;
    }

    private class DataIterator
    implements Iterator<Integer> {
        private int lowerBound;
        private int upperBound;
        private int increment;
        private int value;

        private DataIterator() {
            this.lowerBound = NumericSpinnerData.this.lowerBound;
            this.upperBound = NumericSpinnerData.this.upperBound;
            this.increment = NumericSpinnerData.this.increment;
            this.value = this.lowerBound;
        }

        @Override
        public boolean hasNext() {
            return this.value <= this.upperBound;
        }

        @Override
        public Integer next() {
            if (this.lowerBound != NumericSpinnerData.this.lowerBound || this.upperBound != NumericSpinnerData.this.upperBound || this.increment != NumericSpinnerData.this.increment) {
                throw new ConcurrentModificationException();
            }
            if (this.value > this.upperBound) {
                throw new NoSuchElementException();
            }
            int n = this.value;
            this.value += this.increment;
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

