/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Graphics2D;
import org.apache.pivot.beans.BeanDictionary;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.CardPane;
import org.apache.pivot.wtk.CardPaneListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DragSource;
import org.apache.pivot.wtk.DropTarget;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.MenuHandler;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.ScrollPane;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewListener;
import org.apache.pivot.wtk.TableViewRowListener;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Viewport;
import org.apache.pivot.wtk.ViewportListener;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.CardPaneSkin;

public class TableViewRowEditor
implements TableView.RowEditor {
    private EditorPopup editorPopup = null;
    private HashMap<String, Component> cellEditors = new HashMap();
    private CardPaneSkin.SelectionChangeEffect editEffect = null;
    private int editEffectDuration = 250;
    private TableView.RowEditor.RowEditorListenerList rowEditorListeners = new TableView.RowEditor.RowEditorListenerList();
    private static final int IMAGE_CARD_INDEX = 0;
    private static final int EDITOR_CARD_INDEX = 1;
    private static final String READ_ONLY_KEY = "readOnly";

    public Dictionary<String, Component> getCellEditors() {
        return this.cellEditors;
    }

    public CardPaneSkin.SelectionChangeEffect getEditEffect() {
        return this.editEffect;
    }

    public void setEditEffect(CardPaneSkin.SelectionChangeEffect selectionChangeEffect) {
        this.editEffect = selectionChangeEffect;
    }

    public void setEditEffect(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.setEditEffect(CardPaneSkin.SelectionChangeEffect.valueOf(string.toUpperCase()));
    }

    public int getEditEffectDuration() {
        return this.editEffectDuration;
    }

    public void setEditEffectDuration(int n) {
        this.editEffectDuration = n;
    }

    @Override
    public void editRow(TableView tableView, int n, int n2) {
        if (this.editorPopup != null) {
            throw new IllegalStateException("Edit already in progress.");
        }
        if (tableView == null) {
            throw new IllegalArgumentException("tableView is null.");
        }
        if (n < 0 || n >= tableView.getTableData().getLength() || n2 < 0 || n2 >= tableView.getColumns().getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Vote vote = this.rowEditorListeners.previewEditRow(this, tableView, n, n2);
        if (vote == Vote.APPROVE) {
            this.editorPopup = new EditorPopup(tableView, n, n2);
            Container container = tableView.getParent();
            if (container instanceof ScrollPane) {
                this.editorPopup.setTableViewScrollPane((ScrollPane)container);
            }
            this.editorPopup.editRow();
            this.rowEditorListeners.rowEditing(this, tableView, n, n2);
        } else if (vote == Vote.DENY) {
            this.rowEditorListeners.editRowVetoed(this, vote);
        }
    }

    @Override
    public boolean isEditing() {
        return this.editorPopup != null;
    }

    @Override
    public void saveChanges() {
        if (this.editorPopup == null) {
            throw new IllegalStateException("No edit in progress.");
        }
        this.editorPopup.saveChanges();
    }

    @Override
    public void cancelEdit() {
        if (this.editorPopup == null) {
            throw new IllegalStateException("No edit in progress.");
        }
        this.editorPopup.cancelEdit();
    }

    @Override
    public ListenerList<TableView.RowEditorListener> getRowEditorListeners() {
        return this.rowEditorListeners;
    }

    private class EditorPopup
    extends Window
    implements ContainerMouseListener,
    ComponentListener,
    TableViewListener,
    TableViewRowListener {
        private final TableView tableView;
        private final int rowIndex;
        private final int columnIndex;
        private ScrollPane scrollPane;
        private CardPane cardPane;
        private TablePane tablePane;
        private boolean opening = false;
        private boolean closing = false;
        private boolean saving = false;
        private ScrollPane tableViewScrollPane = null;

        public EditorPopup(TableView tableView, int n, int n2) {
            Dictionary dictionary;
            this.tableView = tableView;
            this.rowIndex = n;
            this.columnIndex = n2;
            Object object = tableView.getTableData().get(n);
            BeanDictionary beanDictionary = null;
            if (object instanceof Dictionary) {
                dictionary = (Dictionary)object;
            } else {
                beanDictionary = new BeanDictionary(object);
                dictionary = beanDictionary;
            }
            this.scrollPane = new ScrollPane(ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.FILL);
            this.setContent(this.scrollPane);
            this.cardPane = new CardPane();
            this.scrollPane.setView(this.cardPane);
            this.cardPane.add(new ImageView(new ComponentImage(tableView, tableView.getRowBounds(n))));
            this.cardPane.setSelectedIndex(0);
            this.cardPane.getStyles().put("selectionChangeEffect", (Object)TableViewRowEditor.this.editEffect);
            this.cardPane.getStyles().put("selectionChangeDuration", (Object)TableViewRowEditor.this.editEffectDuration);
            this.tablePane = new TablePane();
            this.tablePane.getStyles().put("horizontalSpacing", (Object)1);
            this.cardPane.add(this.tablePane);
            TablePane.Row row = new TablePane.Row(1, true);
            this.tablePane.getRows().add(row);
            TableView.ColumnSequence columnSequence = tableView.getColumns();
            TablePane.ColumnSequence columnSequence2 = this.tablePane.getColumns();
            int n3 = columnSequence.getLength();
            for (int i = 0; i < n3; ++i) {
                TablePane.Column column = new TablePane.Column();
                columnSequence2.add(column);
                String string = columnSequence.get(i).getName();
                Component component = null;
                if (string != null) {
                    component = (Component)TableViewRowEditor.this.cellEditors.get((Object)string);
                }
                if (component == null) {
                    TextInput textInput = new TextInput();
                    textInput.setTextKey(string);
                    component = textInput;
                }
                if (!component.isEnabled() || beanDictionary != null && beanDictionary.isReadOnly(string)) {
                    component.getUserData().put(TableViewRowEditor.READ_ONLY_KEY, (Object)true);
                }
                row.add(component);
            }
            this.tablePane.load(dictionary);
            this.scrollPane.getViewportListeners().add((Object)new ViewportListener.Adapter(){

                @Override
                public void scrollLeftChanged(Viewport viewport, int n) {
                    if (EditorPopup.this.tableViewScrollPane != null) {
                        EditorPopup.this.tableViewScrollPane.setScrollLeft(viewport.getScrollLeft());
                    }
                }
            });
        }

        @Override
        public void open(Display display, Window window) {
            if (!this.isOpen()) {
                super.open(display, window);
                if (this.isOpen()) {
                    display.getContainerMouseListeners().add((Object)this);
                    this.tableView.getComponentListeners().add((Object)this);
                    this.tableView.getTableViewListeners().add((Object)this);
                    this.tableView.getTableViewRowListeners().add((Object)this);
                    if (this.tableViewScrollPane != null) {
                        this.scrollPane.setScrollLeft(this.tableViewScrollPane.getScrollLeft());
                    }
                    this.opening = true;
                    this.cardPane.getCardPaneListeners().add((Object)new CardPaneListener.Adapter(){

                        @Override
                        public void selectedIndexChanged(CardPane cardPane, int n) {
                            EditorPopup.this.opening = false;
                            Component component = EditorPopup.this.tablePane.getCellComponent(0, EditorPopup.this.columnIndex);
                            component.requestFocus();
                            cardPane.getCardPaneListeners().remove((Object)this);
                        }
                    });
                    this.cardPane.setSelectedIndex(1);
                }
            }
        }

        @Override
        public void close() {
            if (!this.isClosed() && !this.opening) {
                if (this.cardPane.getSelectedIndex() == 0) {
                    Display display = this.getDisplay();
                    display.getContainerMouseListeners().remove((Object)this);
                    Window window = this.getOwner();
                    super.close();
                    this.closing = false;
                    window.moveToFront();
                    TablePane.Row row = this.tablePane.getRows().get(0);
                    row.remove(0, row.getLength());
                    TableViewRowEditor.this.editorPopup = null;
                    if (this.saving) {
                        TableViewRowEditor.this.rowEditorListeners.changesSaved(TableViewRowEditor.this, this.tableView, this.rowIndex, this.columnIndex);
                    } else {
                        TableViewRowEditor.this.rowEditorListeners.editCancelled(TableViewRowEditor.this, this.tableView, this.rowIndex, this.columnIndex);
                    }
                } else if (!this.closing) {
                    this.closing = true;
                    this.tableView.getComponentListeners().remove((Object)this);
                    this.tableView.getTableViewListeners().remove((Object)this);
                    this.tableView.getTableViewRowListeners().remove((Object)this);
                    this.tablePane.setEnabled(false);
                    this.cardPane.getCardPaneListeners().add((Object)new CardPaneListener.Adapter(){

                        @Override
                        public void selectedIndexChanged(CardPane cardPane, int n) {
                            EditorPopup.this.close();
                            cardPane.getCardPaneListeners().remove((Object)this);
                        }
                    });
                    this.cardPane.setSelectedIndex(0);
                }
            }
        }

        @Override
        protected boolean keyPressed(int n, Keyboard.KeyLocation keyLocation) {
            if (n == 10) {
                this.saveChanges();
            } else if (n == 27) {
                this.cancelEdit();
            }
            return super.keyPressed(n, keyLocation);
        }

        public void setTableViewScrollPane(ScrollPane scrollPane) {
            this.tableViewScrollPane = scrollPane;
        }

        public void editRow() {
            this.open(this.tableView.getWindow());
            this.reposition();
        }

        public void saveChanges() {
            HashMap hashMap = new HashMap();
            this.tablePane.store((Dictionary<String, ?>)hashMap);
            Vote vote = TableViewRowEditor.this.rowEditorListeners.previewSaveChanges(TableViewRowEditor.this, this.tableView, this.rowIndex, this.columnIndex, (Dictionary<String, Object>)hashMap);
            if (vote == Vote.APPROVE) {
                this.saving = true;
                List<?> list = this.tableView.getTableData();
                Object object = list.get(this.rowIndex);
                Object object2 = object instanceof Dictionary ? (Dictionary)object : new BeanDictionary(object);
                this.tablePane.store((Dictionary<String, ?>)object2);
                if (list.getComparator() == null) {
                    list.update(this.rowIndex, object);
                } else {
                    list.remove(this.rowIndex, 1);
                    list.add(object);
                    int n = list.indexOf(object);
                    this.tableView.setSelectedIndex(n);
                    this.tableView.scrollAreaToVisible(this.tableView.getRowBounds(n));
                }
            } else if (vote == Vote.DENY) {
                this.saving = false;
                TableViewRowEditor.this.rowEditorListeners.saveChangesVetoed(TableViewRowEditor.this, vote);
            }
        }

        public void cancelEdit() {
            this.close();
        }

        private void reposition() {
            Bounds bounds = this.tableView.getRowBounds(this.rowIndex);
            this.tableView.scrollAreaToVisible(bounds);
            bounds = this.tableView.getVisibleArea(bounds);
            Point point = this.tableView.mapPointToAncestor(this.tableView.getDisplay(), bounds.x, bounds.y);
            this.setLocation(point.x, point.y);
            this.setPreferredSize(bounds.width, bounds.height + 1);
            TableView.ColumnSequence columnSequence = this.tableView.getColumns();
            TablePane.ColumnSequence columnSequence2 = this.tablePane.getColumns();
            TablePane.Row row = this.tablePane.getRows().get(0);
            int n = columnSequence.getLength();
            for (int i = 0; i < n; ++i) {
                TablePane.Column column = columnSequence2.get(i);
                int n2 = this.tableView.getColumnBounds((int)i).width;
                column.setWidth(n2);
                Component component = row.get(i);
                boolean bl = component.getUserData().get(TableViewRowEditor.READ_ONLY_KEY) != null;
                component.setEnabled(!bl && n2 > 0);
            }
        }

        @Override
        public boolean mouseMove(Container container, int n, int n2) {
            return false;
        }

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display;
            Window window;
            if (!(this.opening || this.closing || (window = (Window)(display = (Display)container).getComponentAt(n, n2)) == this || window != null && this.isOwner(window))) {
                this.saveChanges();
            }
            return this.opening;
        }

        @Override
        public boolean mouseUp(Container container, Mouse.Button button, int n, int n2) {
            return false;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            boolean bl = false;
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(n3, n4);
            if (!(window == this || window != null && this.isOwner(window))) {
                bl = true;
            }
            return bl;
        }

        @Override
        public void parentChanged(Component component, Container container) {
        }

        @Override
        public void sizeChanged(Component component, int n, int n2) {
            ApplicationContext.queueCallback(new Runnable(){

                @Override
                public void run() {
                    EditorPopup.this.reposition();
                }
            });
        }

        @Override
        public void preferredSizeChanged(Component component, int n, int n2) {
        }

        @Override
        public void preferredWidthLimitsChanged(Component component, int n, int n2) {
        }

        @Override
        public void preferredHeightLimitsChanged(Component component, int n, int n2) {
        }

        @Override
        public void locationChanged(Component component, int n, int n2) {
            ApplicationContext.queueCallback(new Runnable(){

                @Override
                public void run() {
                    EditorPopup.this.reposition();
                }
            });
        }

        @Override
        public void visibleChanged(Component component) {
            this.cancelEdit();
        }

        @Override
        public void styleUpdated(Component component, String string, Object object) {
        }

        @Override
        public void cursorChanged(Component component, Cursor cursor) {
        }

        @Override
        public void tooltipTextChanged(Component component, String string) {
        }

        @Override
        public void dragSourceChanged(Component component, DragSource dragSource) {
        }

        @Override
        public void dropTargetChanged(Component component, DropTarget dropTarget) {
        }

        @Override
        public void menuHandlerChanged(Component component, MenuHandler menuHandler) {
        }

        @Override
        public void tableDataChanged(TableView tableView, List<?> list) {
            this.cancelEdit();
        }

        @Override
        public void columnSourceChanged(TableView tableView, TableView tableView2) {
        }

        @Override
        public void rowEditorChanged(TableView tableView, TableView.RowEditor rowEditor) {
            this.cancelEdit();
        }

        @Override
        public void selectModeChanged(TableView tableView, TableView.SelectMode selectMode) {
        }

        @Override
        public void disabledRowFilterChanged(TableView tableView, Filter<?> filter) {
        }

        @Override
        public void rowInserted(TableView tableView, int n) {
            this.cancelEdit();
        }

        @Override
        public void rowsRemoved(TableView tableView, int n, int n2) {
            this.cancelEdit();
        }

        @Override
        public void rowUpdated(TableView tableView, int n) {
            this.cancelEdit();
        }

        @Override
        public void rowsCleared(TableView tableView) {
            this.cancelEdit();
        }

        @Override
        public void rowsSorted(TableView tableView) {
            this.cancelEdit();
        }
    }

    private static class ComponentImage
    extends Image {
        private Component component;
        private int x;
        private int y;
        private int width;
        private int height;

        public ComponentImage(Component component, Bounds bounds) {
            this(component, bounds.x, bounds.y, bounds.width, bounds.height);
        }

        public ComponentImage(Component component, int n, int n2, int n3, int n4) {
            this.component = component;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            graphics2D.translate(-this.x, -this.y);
            graphics2D.clipRect(this.x, this.y, this.width, this.height);
            this.component.paint(graphics2D);
        }
    }
}

