/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.effects.Decorator;

public class BaselineDecorator
implements Decorator {
    private Component component = null;
    private Graphics2D graphics = null;

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        this.component = component;
        this.graphics = graphics2D;
        return graphics2D;
    }

    @Override
    public void update() {
        Color color;
        int n;
        int n2;
        int n3 = this.component.getWidth();
        int n4 = this.component.getBaseline(n3, n2 = this.component.getHeight());
        if (n4 == -1) {
            n = n2 / 2;
            color = Color.BLUE;
        } else {
            n = n4;
            color = Color.RED;
        }
        this.graphics.setPaint(color);
        GraphicsUtilities.drawLine(this.graphics, 0, n, n3, Orientation.HORIZONTAL);
        this.component = null;
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

