/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class BlurDecorator
implements Decorator {
    private int blurMagnitude;
    private Graphics2D graphics = null;
    private BufferedImage bufferedImage = null;
    private Graphics2D bufferedImageGraphics = null;

    public BlurDecorator() {
        this(9);
    }

    public BlurDecorator(int n) {
        this.blurMagnitude = n;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        this.graphics = graphics2D;
        int n = component.getWidth();
        int n2 = component.getHeight();
        if (this.bufferedImage == null || this.bufferedImage.getWidth() != n || this.bufferedImage.getHeight() != n2) {
            this.bufferedImage = new BufferedImage(n, n2, 1);
        }
        this.bufferedImageGraphics = this.bufferedImage.createGraphics();
        this.bufferedImageGraphics.setClip(graphics2D.getClip());
        return this.bufferedImageGraphics;
    }

    @Override
    public void update() {
        this.bufferedImageGraphics.dispose();
        this.bufferedImageGraphics = null;
        this.bufferedImage.flush();
        float[] fArray = new float[this.blurMagnitude * this.blurMagnitude];
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray[i] = 1.0f / (float)n;
        }
        ConvolveOp convolveOp = new ConvolveOp(new Kernel(this.blurMagnitude, this.blurMagnitude, fArray), 1, null);
        this.bufferedImage = convolveOp.filter(this.bufferedImage, null);
        this.graphics.drawImage((Image)this.bufferedImage, 0, 0, null);
        this.bufferedImage = null;
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

