/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.effects.Decorator;

public class ScaleDecorator
implements Decorator {
    private float scaleX;
    private float scaleY;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;

    public ScaleDecorator() {
        this(1.0f, 1.0f);
    }

    public ScaleDecorator(float f, float f2) {
        this.setScale(f, f2);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f) {
        this.setScale(f, this.scaleY);
    }

    public void setScaleX(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("scaleX is null.");
        }
        this.setScaleX(number.floatValue());
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f) {
        this.setScale(this.scaleX, f);
    }

    public void setScaleY(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("scaleY is null.");
        }
        this.setScaleY(number.floatValue());
    }

    public void setScale(float f, float f2) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("scaleX is negative.");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("scaleY is negative.");
        }
        this.scaleX = f;
        this.scaleY = f2;
    }

    public void setScale(float f) {
        this.setScaleX(f);
        this.setScaleY(f);
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
    }

    public final void setHorizontalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.setHorizontalAlignment(HorizontalAlignment.valueOf(string.toUpperCase()));
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
    }

    public final void setVerticalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.setVerticalAlignment(VerticalAlignment.valueOf(string.toUpperCase()));
    }

    private int getTranslatedX(Component component) {
        int n;
        int n2 = component.getWidth();
        int n3 = (int)Math.ceil((float)n2 * this.scaleX);
        switch (this.horizontalAlignment) {
            case LEFT: {
                n = 0;
                break;
            }
            case RIGHT: {
                n = n2 - n3;
                break;
            }
            default: {
                n = (n2 - n3) / 2;
            }
        }
        return n;
    }

    private int getTranslatedY(Component component) {
        int n;
        int n2 = component.getHeight();
        int n3 = (int)Math.ceil((float)n2 * this.scaleY);
        switch (this.verticalAlignment) {
            case TOP: {
                n = 0;
                break;
            }
            case BOTTOM: {
                n = n2 - n3;
                break;
            }
            default: {
                n = (n2 - n3) / 2;
            }
        }
        return n;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Platform.getTextAntialiasingHint());
        int n = this.getTranslatedX(component);
        int n2 = this.getTranslatedY(component);
        if (n != 0 || n2 != 0) {
            graphics2D.translate(n, n2);
        }
        graphics2D.scale(Math.max(this.scaleX, Float.MIN_NORMAL), Math.max(this.scaleY, Float.MIN_NORMAL));
        return graphics2D;
    }

    @Override
    public void update() {
    }

    public void repaint(Component component, int n, int n2, int n3, int n4) {
        Container container = component.getParent();
        if (container != null) {
            int n5 = this.getTranslatedX(component);
            int n6 = this.getTranslatedY(component);
            n = (int)((float)n * this.scaleX + (float)component.getX() + (float)n5);
            n2 = (int)((float)n2 * this.scaleY + (float)component.getY() + (float)n6);
            n3 = (int)Math.ceil((float)n3 * this.scaleX);
            n4 = (int)Math.ceil((float)n4 * this.scaleY);
            container.repaint(n, n2, n3, n4);
        }
    }

    @Override
    public Bounds getBounds(Component component) {
        int n = (int)Math.ceil((float)component.getWidth() * this.scaleX);
        int n2 = (int)Math.ceil((float)component.getHeight() * this.scaleY);
        int n3 = this.getTranslatedX(component);
        int n4 = this.getTranslatedY(component);
        return new Bounds(n3, n4, n, n2);
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
    }
}

