/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.effects.TransitionListener;

public abstract class Transition {
    private int duration;
    private int rate;
    private boolean repeating;
    private boolean reversed = false;
    private TransitionListener transitionListener;
    private long startTime = 0L;
    private long currentTime = 0L;
    private ApplicationContext.ScheduledCallback transitionCallback = null;
    private final Runnable updateCallback = new Runnable(){

        @Override
        public void run() {
            Transition.this.currentTime = System.currentTimeMillis();
            long l = Transition.this.startTime + (long)Transition.this.duration;
            if (Transition.this.currentTime >= l) {
                if (Transition.this.repeating) {
                    Transition.this.startTime = l;
                } else {
                    Transition.this.currentTime = l;
                    Transition.this.stop();
                    if (Transition.this.transitionListener != null) {
                        Transition.this.transitionListener.transitionCompleted(Transition.this);
                    }
                }
            }
            Transition.this.update();
        }
    };

    public Transition(int n, int n2) {
        this(n, n2, false);
    }

    public Transition(int n, int n2, boolean bl) {
        this(n, n2, bl, false);
    }

    public Transition(int n, int n2, boolean bl, boolean bl2) {
        if (n <= 0) {
            throw new IllegalArgumentException("duration must be positive.");
        }
        this.duration = n;
        this.rate = n2;
        this.repeating = bl;
        this.reversed = bl2;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("duration is negative.");
        }
        if (this.transitionCallback != null) {
            throw new IllegalStateException("Transition is currently running.");
        }
        this.duration = n;
    }

    public int getRate() {
        return this.rate;
    }

    public void setRate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("rate is negative.");
        }
        if (this.transitionCallback != null) {
            throw new IllegalStateException("Transition is currently running.");
        }
        this.rate = n;
    }

    public int getInterval() {
        return (int)(1.0f / (float)this.rate * 1000.0f);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public int getElapsedTime() {
        long l = this.startTime + (long)this.duration;
        int n = this.reversed ? (int)(l - this.currentTime) : (int)(this.currentTime - this.startTime);
        return n;
    }

    public float getPercentComplete() {
        float f = (float)(this.currentTime - this.startTime) / (float)this.duration;
        if (this.reversed) {
            f = 1.0f - f;
        }
        return f;
    }

    public boolean isRunning() {
        return this.transitionCallback != null;
    }

    public final void start() {
        this.start(null);
    }

    public void start(TransitionListener transitionListener) {
        if (this.transitionCallback != null) {
            throw new IllegalStateException("Transition is currently running.");
        }
        this.transitionListener = transitionListener;
        this.currentTime = this.startTime = System.currentTimeMillis();
        this.transitionCallback = ApplicationContext.scheduleRecurringCallback(this.updateCallback, this.getInterval());
        this.update();
    }

    public void stop() {
        if (this.transitionCallback != null) {
            this.transitionCallback.cancel();
        }
        this.transitionCallback = null;
    }

    public void end() {
        if (this.transitionCallback != null) {
            this.currentTime = this.startTime + (long)this.duration;
            this.stop();
            this.update();
            this.transitionListener.transitionCompleted(this);
        }
    }

    protected abstract void update();

    public boolean isRepeating() {
        return this.repeating;
    }

    public void reverse() {
        this.reverse(null);
    }

    public void reverse(TransitionListener transitionListener) {
        if (this.transitionCallback == null) {
            throw new IllegalStateException("Transition is not currently running.");
        }
        this.transitionListener = transitionListener;
        long l = this.currentTime - this.startTime;
        long l2 = this.currentTime + l;
        this.startTime = l2 - (long)this.duration;
        this.reversed = !this.reversed;
    }

    public boolean isReversed() {
        return this.reversed;
    }
}

