/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.effects.Decorator;

public class TranslationDecorator
implements Decorator {
    private int x;
    private int y;
    private boolean clip;

    public TranslationDecorator() {
        this(0, 0, false);
    }

    public TranslationDecorator(boolean bl) {
        this(0, 0, bl);
    }

    public TranslationDecorator(int n, int n2, boolean bl) {
        this.setOffset(n, n2);
        this.setClip(bl);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public Point getOffset() {
        return new Point(this.x, this.y);
    }

    public void setOffset(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("offset is null.");
        }
        this.setOffset(point.x, point.y);
    }

    public void setOffset(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public boolean getClip() {
        return this.clip;
    }

    public void setClip(boolean bl) {
        this.clip = bl;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        if (this.clip) {
            Bounds bounds = component.getDecoratedBounds();
            graphics2D.clipRect(bounds.x - component.getX(), bounds.y - component.getY(), bounds.width, bounds.height);
        }
        graphics2D.translate(this.x, this.y);
        return graphics2D;
    }

    @Override
    public void update() {
    }

    @Override
    public Bounds getBounds(Component component) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        Bounds bounds = new Bounds(this.x, this.y, n, n2);
        if (this.clip) {
            bounds = bounds.intersect(0, 0, n, n2);
        }
        return bounds;
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return AffineTransform.getTranslateInstance(this.x, this.y);
    }
}

