/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.net.URL;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.media.Image;

public class WatermarkDecorator
implements Decorator {
    private float opacity = 0.075f;
    private double theta = 0.7853981633974483;
    private BoxPane boxPane = new BoxPane(Orientation.HORIZONTAL);
    private ImageView imageView = new ImageView();
    private Label label = new Label();
    private Component component = null;
    private Graphics2D graphics = null;

    public WatermarkDecorator() {
        this(null, null);
    }

    public WatermarkDecorator(String string) {
        this(string, null);
    }

    public WatermarkDecorator(Image image) {
        this(null, image);
    }

    public WatermarkDecorator(String string, Image image) {
        this.boxPane.add(this.imageView);
        this.boxPane.add(this.label);
        this.boxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.imageView.getStyles().put("opacity", (Object)Float.valueOf(this.opacity));
        Font font = (Font)this.label.getStyles().get("font");
        this.label.getStyles().put("font", (Object)font.deriveFont(1, 60.0f));
        this.label.setText(string);
        this.imageView.setImage(image);
        this.validate();
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        this.label.setText(string);
        this.validate();
    }

    public Font getFont() {
        return (Font)this.label.getStyles().get("font");
    }

    public void setFont(Font font) {
        this.label.getStyles().put("font", (Object)font);
        this.validate();
    }

    public final void setFont(String string) {
        this.setFont(Font.decode(string));
    }

    public Image getImage() {
        return this.imageView.getImage();
    }

    public void setImage(Image image) {
        this.imageView.setImage(image);
        this.validate();
    }

    public void setImage(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("imageURL is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(uRL);
        if (image == null) {
            try {
                image = Image.load(uRL);
            }
            catch (TaskExecutionException taskExecutionException) {
                throw new IllegalArgumentException(taskExecutionException);
            }
            ApplicationContext.getResourceCache().put(uRL, (Object)image);
        }
        this.setImage(image);
    }

    public void setImage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("image is null.");
        }
        ClassLoader classLoader = ThreadUtilities.getClassLoader();
        this.setImage(classLoader.getResource(string));
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float f) {
        this.opacity = f;
        this.imageView.getStyles().put("opacity", (Object)Float.valueOf(f));
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double d) {
        if (d < 0.0 || d > 1.5707963267948966) {
            throw new IllegalArgumentException("Theta must be between 0 nd PI / 2.");
        }
        this.theta = d;
    }

    private void validate() {
        this.boxPane.setSize(this.boxPane.getPreferredSize());
        this.boxPane.validate();
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        this.component = component;
        this.graphics = graphics2D;
        return graphics2D;
    }

    @Override
    public void update() {
        int n = this.component.getWidth();
        int n2 = this.component.getHeight();
        double d = Math.sin(this.theta);
        double d2 = Math.cos(this.theta);
        Graphics2D graphics2D = (Graphics2D)this.graphics.create();
        graphics2D.clipRect(0, 0, this.component.getWidth(), this.component.getHeight());
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        graphics2D.rotate(this.theta);
        int n3 = (int)(1.5 * (double)this.boxPane.getWidth());
        int n4 = 2 * this.boxPane.getHeight();
        int n5 = 0;
        int n6 = (int)((double)(-n) * d);
        graphics2D.translate(n5, n6);
        int n7 = (int)((double)n2 * d2);
        int n8 = 0;
        while (n6 < n7) {
            int n9 = (int)((double)n2 * d + (double)n * d2);
            while (n5 < n9) {
                this.boxPane.paint(graphics2D);
                graphics2D.translate(n3, 0);
                n5 += n3;
            }
            graphics2D.translate(-n5, n4);
            n5 = 0;
            graphics2D.translate((int)((0.5f - (float)n8) * (float)this.boxPane.getWidth()), 0);
            n6 += n4;
            n8 = 1 - n8;
        }
        graphics2D.dispose();
        this.component = null;
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

