/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.media.DrawingListener;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.drawing.Canvas;
import org.apache.pivot.wtk.media.drawing.CanvasListener;

public class Drawing
extends Image {
    private Canvas canvas = null;
    private Paint background = null;
    private Dimensions size = null;
    private int baseline = -1;
    private CanvasListener canvasListener = new CanvasListener(){

        @Override
        public void regionUpdated(Canvas canvas, int n, int n2, int n3, int n4) {
            Drawing.this.imageListeners.regionUpdated(Drawing.this, n, n2, n3, n4);
        }

        @Override
        public void canvasInvalidated(Canvas canvas) {
            int n = ((Drawing)Drawing.this).size.width;
            int n2 = ((Drawing)Drawing.this).size.height;
            Drawing.this.invalidate();
            Drawing.this.imageListeners.sizeChanged(Drawing.this, n, n2);
        }
    };
    private DrawingListenerList drawingListeners = new DrawingListenerList();

    public Drawing() {
        this.setCanvas(new Canvas());
    }

    @Override
    public int getWidth() {
        this.validate();
        return this.size.width;
    }

    @Override
    public int getHeight() {
        this.validate();
        return this.size.height;
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    public void setBaseline(int n) {
        int n2 = this.baseline;
        if (n != n2) {
            this.baseline = n;
            this.imageListeners.baselineChanged(this, n2);
        }
    }

    private void invalidate() {
        this.size = null;
    }

    private void validate() {
        if (this.size == null) {
            int n;
            int n2;
            if (this.canvas == null) {
                n2 = 0;
                n = 0;
            } else {
                Bounds bounds = this.canvas.getBounds();
                n2 = Math.max(bounds.x + bounds.width, 0);
                n = Math.max(bounds.y + bounds.height, 0);
            }
            this.size = new Dimensions(n2, n);
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(Canvas canvas) {
        Canvas canvas2 = this.canvas;
        if (canvas2 != canvas) {
            this.canvas = canvas;
            if (canvas2 != null) {
                canvas2.getCanvasListeners().remove((Object)this.canvasListener);
            }
            if (canvas != null) {
                canvas.getCanvasListeners().add((Object)this.canvasListener);
            }
            this.size = null;
            this.drawingListeners.canvasChanged(this, canvas2);
        }
    }

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint paint) {
        Paint paint2 = this.background;
        if (paint2 != paint) {
            this.background = paint;
            this.drawingListeners.backgroundChanged(this, paint2);
        }
    }

    public final void setBackground(String string) {
        if (string == null) {
            throw new IllegalArgumentException("background is null.");
        }
        this.setBackground(GraphicsUtilities.decodePaint(string));
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.clipRect(0, 0, n, n2);
        if (this.background != null) {
            graphics2D.setPaint(this.background);
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (this.canvas != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.canvas.draw(graphics2D);
        }
    }

    public ListenerList<DrawingListener> getDrawingListeners() {
        return this.drawingListeners;
    }

    private static class DrawingListenerList
    extends ListenerList<DrawingListener>
    implements DrawingListener {
        private DrawingListenerList() {
        }

        @Override
        public void canvasChanged(Drawing drawing, Canvas canvas) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DrawingListener drawingListener = (DrawingListener)iterator.next();
                drawingListener.canvasChanged(drawing, canvas);
            }
        }

        @Override
        public void backgroundChanged(Drawing drawing, Paint paint) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DrawingListener drawingListener = (DrawingListener)iterator.next();
                drawingListener.backgroundChanged(drawing, paint);
            }
        }
    }
}

