/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.media.MovieListener;

public abstract class Movie
implements Visual {
    private int currentFrame = -1;
    private int frameRate = 26;
    private boolean looping = false;
    private ApplicationContext.ScheduledCallback scheduledCallback = null;
    protected MovieListenerList movieListeners = new MovieListenerList();
    private final Runnable nextFrameCallback = new Runnable(){

        @Override
        public void run() {
            if (Movie.this.currentFrame == Movie.this.getTotalFrames() - 1) {
                if (Movie.this.looping) {
                    Movie.this.setCurrentFrame(0);
                } else {
                    Movie.this.stop();
                }
            } else {
                Movie.this.setCurrentFrame(Movie.this.currentFrame + 1);
            }
        }
    };

    @Override
    public int getBaseline() {
        return -1;
    }

    public Dimensions getSize() {
        return new Dimensions(this.getWidth(), this.getHeight());
    }

    public abstract int getTotalFrames();

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(int n) {
        int n2 = this.currentFrame;
        if (n2 != n) {
            this.currentFrame = n;
            this.movieListeners.currentFrameChanged(this, n2);
        }
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int n) {
        this.frameRate = n;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean bl) {
        if (this.looping != bl) {
            this.looping = bl;
            this.movieListeners.loopingChanged(this);
        }
    }

    public void play() {
        if (this.scheduledCallback != null) {
            throw new IllegalStateException("Movie is already playing.");
        }
        this.scheduledCallback = ApplicationContext.scheduleRecurringCallback(this.nextFrameCallback, (int)(1.0 / (double)this.frameRate * 1000.0));
        this.movieListeners.movieStarted(this);
    }

    public void stop() {
        if (this.scheduledCallback != null) {
            this.scheduledCallback.cancel();
        }
        this.scheduledCallback = null;
        this.movieListeners.movieStopped(this);
    }

    public boolean isPlaying() {
        return this.scheduledCallback != null;
    }

    public ListenerList<MovieListener> getMovieListeners() {
        return this.movieListeners;
    }

    protected static class MovieListenerList
    extends ListenerList<MovieListener>
    implements MovieListener {
        protected MovieListenerList() {
        }

        @Override
        public void sizeChanged(Movie movie, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MovieListener movieListener = (MovieListener)iterator.next();
                movieListener.sizeChanged(movie, n, n2);
            }
        }

        @Override
        public void baselineChanged(Movie movie, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MovieListener movieListener = (MovieListener)iterator.next();
                movieListener.baselineChanged(movie, n);
            }
        }

        @Override
        public void currentFrameChanged(Movie movie, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MovieListener movieListener = (MovieListener)iterator.next();
                movieListener.currentFrameChanged(movie, n);
            }
        }

        @Override
        public void loopingChanged(Movie movie) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MovieListener movieListener = (MovieListener)iterator.next();
                movieListener.loopingChanged(movie);
            }
        }

        @Override
        public void movieStarted(Movie movie) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MovieListener movieListener = (MovieListener)iterator.next();
                movieListener.movieStarted(movie);
            }
        }

        @Override
        public void movieStopped(Movie movie) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MovieListener movieListener = (MovieListener)iterator.next();
                movieListener.movieStopped(movie);
            }
        }

        @Override
        public void regionUpdated(Movie movie, int n, int n2, int n3, int n4) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MovieListener movieListener = (MovieListener)iterator.next();
                movieListener.regionUpdated(movie, n, n2, n3, n4);
            }
        }
    }
}

