/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.apache.pivot.wtk.media.Image;

public class Picture
extends Image {
    private BufferedImage bufferedImage = null;
    private int baseline = -1;

    public Picture(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("bufferedImage is null.");
        }
        this.bufferedImage = bufferedImage;
    }

    @Override
    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    public void resample(int n) {
        this.resample(n, Interpolation.NEAREST_NEIGHBOR);
    }

    public void resample(int n, Interpolation interpolation) {
        int n2;
        int n3 = this.getWidth();
        float f = (float)n3 / (float)(n2 = this.getHeight());
        if (f > 1.0f) {
            n3 = n;
            n2 = (int)((float)n / f);
        } else {
            n3 = (int)((float)n * f);
            n2 = n;
        }
        this.resample(n3, n2, interpolation);
    }

    public void resample(int n, int n2) {
        this.resample(n, n2, Interpolation.NEAREST_NEIGHBOR);
    }

    public void resample(int n, int n2, Interpolation interpolation) {
        if (interpolation == null) {
            throw new IllegalArgumentException("interpolation is null.");
        }
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n3 != n || n4 != n2) {
            int n5 = this.bufferedImage.getType();
            float f = (float)n / (float)n3;
            float f2 = (float)n2 / (float)n4;
            BufferedImage bufferedImage = new BufferedImage(n, n2, n5);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            if (this.bufferedImage.getTransparency() != 1) {
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setComposite(AlphaComposite.SrcOver);
            }
            Object object = 0;
            switch (interpolation) {
                case NEAREST_NEIGHBOR: {
                    object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    break;
                }
                case BILINEAR: {
                    object = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                    break;
                }
                case BICUBIC: {
                    object = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                }
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.scale(f, f2);
            this.paint(graphics2D);
            graphics2D.dispose();
            this.bufferedImage = bufferedImage;
            this.imageListeners.sizeChanged(this, n3, n4);
        }
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    public void setBaseline(int n) {
        int n2 = this.baseline;
        if (n != n2) {
            this.baseline = n;
            this.imageListeners.baselineChanged(this, n2);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        graphics2D.drawImage((java.awt.Image)this.bufferedImage, 0, 0, null);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public static enum Interpolation {
        NEAREST_NEIGHBOR,
        BILINEAR,
        BICUBIC;

    }
}

