/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media.drawing;

import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.media.drawing.ArcListener;
import org.apache.pivot.wtk.media.drawing.Shape2D;

public class Arc
extends Shape2D {
    private Arc2D.Float arc2D = new Arc2D.Float();
    private ArcListenerList arcListeners = new ArcListenerList();

    public int getWidth() {
        return (int)this.arc2D.width;
    }

    public void setWidth(int n) {
        this.setSize(n, (int)this.arc2D.height);
    }

    public int getHeight() {
        return (int)this.arc2D.height;
    }

    public void setHeight(int n) {
        this.setSize((int)this.arc2D.width, n);
    }

    public void setSize(int n, int n2) {
        int n3 = (int)this.arc2D.width;
        int n4 = (int)this.arc2D.height;
        if (n3 != n || n4 != n2) {
            this.arc2D.width = n;
            this.arc2D.height = n2;
            this.invalidate();
            this.arcListeners.sizeChanged(this, n3, n4);
        }
    }

    public float getStart() {
        return this.arc2D.start;
    }

    public void setStart(float f) {
        float f2 = this.arc2D.start;
        if (f2 != f) {
            this.arc2D.start = f;
            this.invalidate();
            this.arcListeners.startChanged(this, f2);
        }
    }

    public float getExtent() {
        return this.arc2D.extent;
    }

    public void setExtent(float f) {
        float f2 = this.arc2D.extent;
        if (f2 != f) {
            this.arc2D.extent = f;
            this.invalidate();
            this.arcListeners.extentChanged(this, f2);
        }
    }

    public Type getType() {
        Type type = null;
        switch (this.arc2D.getArcType()) {
            case 1: {
                type = Type.CHORD;
                break;
            }
            case 0: {
                type = Type.OPEN;
                break;
            }
            case 2: {
                type = Type.PIE;
            }
        }
        return type;
    }

    public void setType(Type type) {
        Type type2 = this.getType();
        if (type2 != type) {
            switch (type) {
                case CHORD: {
                    this.arc2D.setArcType(1);
                    break;
                }
                case OPEN: {
                    this.arc2D.setArcType(0);
                    break;
                }
                case PIE: {
                    this.arc2D.setArcType(2);
                }
            }
            this.invalidate();
            this.arcListeners.typeChanged(this, type2);
        }
    }

    public void setType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("type is null.");
        }
        this.setType(Type.valueOf(string.toUpperCase()));
    }

    @Override
    protected Shape getShape2D() {
        return this.arc2D;
    }

    public ListenerList<ArcListener> getArcListeners() {
        return this.arcListeners;
    }

    private static class ArcListenerList
    extends ListenerList<ArcListener>
    implements ArcListener {
        private ArcListenerList() {
        }

        @Override
        public void sizeChanged(Arc arc, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ArcListener arcListener = (ArcListener)iterator.next();
                arcListener.sizeChanged(arc, n, n2);
            }
        }

        @Override
        public void startChanged(Arc arc, float f) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ArcListener arcListener = (ArcListener)iterator.next();
                arcListener.startChanged(arc, f);
            }
        }

        @Override
        public void extentChanged(Arc arc, float f) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ArcListener arcListener = (ArcListener)iterator.next();
                arcListener.extentChanged(arc, f);
            }
        }

        @Override
        public void typeChanged(Arc arc, Type type) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ArcListener arcListener = (ArcListener)iterator.next();
                arcListener.typeChanged(arc, type);
            }
        }
    }

    public static enum Type {
        CHORD,
        OPEN,
        PIE;

    }
}

