/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media.drawing;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.media.drawing.EllipseListener;
import org.apache.pivot.wtk.media.drawing.Shape2D;

public class Ellipse
extends Shape2D {
    private Ellipse2D.Float ellipse2D = new Ellipse2D.Float();
    private EllipseListenerList ellipseListeners = new EllipseListenerList();

    public int getWidth() {
        return (int)this.ellipse2D.width;
    }

    public void setWidth(int n) {
        this.setSize(n, (int)this.ellipse2D.height);
    }

    public int getHeight() {
        return (int)this.ellipse2D.height;
    }

    public void setHeight(int n) {
        this.setSize((int)this.ellipse2D.width, n);
    }

    public void setSize(int n, int n2) {
        int n3 = (int)this.ellipse2D.width;
        int n4 = (int)this.ellipse2D.height;
        if (n3 != n || n4 != n2) {
            this.ellipse2D.width = n;
            this.ellipse2D.height = n2;
            this.invalidate();
            this.ellipseListeners.sizeChanged(this, n3, n4);
        }
    }

    @Override
    protected Shape getShape2D() {
        return this.ellipse2D;
    }

    public ListenerList<EllipseListener> getEllipseListeners() {
        return this.ellipseListeners;
    }

    private static class EllipseListenerList
    extends ListenerList<EllipseListener>
    implements EllipseListener {
        private EllipseListenerList() {
        }

        @Override
        public void sizeChanged(Ellipse ellipse, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                EllipseListener ellipseListener = (EllipseListener)iterator.next();
                ellipseListener.sizeChanged(ellipse, n, n2);
            }
        }
    }
}

