/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media.drawing;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.media.drawing.GroupListener;
import org.apache.pivot.wtk.media.drawing.Shape;

public class Group
extends Shape
implements Sequence<Shape>,
Iterable<Shape> {
    private ArrayList<Shape> shapes = new ArrayList();
    private GroupListenerList groupListeners = new GroupListenerList();

    @Override
    public void setFill(Paint paint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStroke(Paint paint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStrokeThickness(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(int n, int n2) {
        boolean bl = false;
        for (Shape shape : this.shapes) {
            if (!shape.contains(n - shape.getX(), n2 - shape.getY())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Shape getShapeAt(int n, int n2) {
        int n3;
        Shape shape = null;
        for (n3 = this.shapes.getLength() - 1; n3 >= 0; --n3) {
            shape = (Shape)this.shapes.get(n3);
            if (!shape.isVisible()) continue;
            Bounds bounds = shape.getTransformedBounds();
            Point point = shape.getOrigin();
            if (!(bounds = bounds.translate(point.x, point.y)).contains(n, n2)) continue;
            AffineTransform affineTransform = shape.getTransforms().getAffineTransform();
            java.awt.Point point2 = new java.awt.Point(n - point.x, n2 - point.y);
            try {
                affineTransform.inverseTransform(point2, point2);
                if (!shape.contains(point2.x, point2.y)) continue;
                break;
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        if (n3 < 0) {
            shape = null;
        }
        return shape;
    }

    public Shape getDescendantAt(int n, int n2) {
        Shape shape = this.getShapeAt(n, n2);
        if (shape instanceof Group) {
            Group group = (Group)shape;
            Point point = group.getOrigin();
            shape = group.getDescendantAt(n - point.x, n2 - point.y);
        }
        if (shape == null) {
            shape = this;
        }
        return shape;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Bounds bounds = new Bounds(graphics2D.getClipBounds());
        for (Shape shape : this.shapes) {
            if (!shape.isVisible()) continue;
            int n = shape.getX();
            int n2 = shape.getY();
            Bounds bounds2 = shape.getTransformedBounds();
            if (!(bounds2 = bounds2.translate(n, n2)).intersects(bounds)) continue;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.translate(n, n2);
            graphics2D2.transform(shape.getTransforms().getAffineTransform());
            shape.draw(graphics2D2);
            graphics2D2.dispose();
        }
    }

    @Override
    protected void validate() {
        if (!this.isValid()) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.shapes.getLength();
            for (int i = 0; i < n5; ++i) {
                Shape shape = (Shape)this.shapes.get(i);
                if (!shape.isVisible()) continue;
                shape.validate();
                int n6 = shape.getX();
                int n7 = shape.getY();
                Bounds bounds = shape.getTransformedBounds();
                if (i == 0) {
                    n = n7 + bounds.y;
                    n2 = n6 + bounds.x;
                    n3 = n7 + bounds.y + bounds.height - 1;
                    n4 = n6 + bounds.x + bounds.width - 1;
                    continue;
                }
                n = Math.min(n7 + bounds.y, n);
                n2 = Math.min(n6 + bounds.x, n2);
                n3 = Math.max(n7 + bounds.y + bounds.height - 1, n3);
                n4 = Math.max(n6 + bounds.x + bounds.width - 1, n4);
            }
            this.setBounds(n2, n, n4 - n2 + 1, n3 - n + 1);
        }
    }

    public int add(Shape shape) {
        int n = this.shapes.getLength();
        this.insert(shape, n);
        return n;
    }

    public void insert(Shape shape, int n) {
        if (shape.getParent() != null) {
            throw new IllegalArgumentException();
        }
        shape.setParent(this);
        this.shapes.insert((Object)shape, n);
        this.invalidate();
        this.groupListeners.shapeInserted(this, n);
    }

    public Shape update(int n, Shape shape) {
        throw new UnsupportedOperationException();
    }

    public int remove(Shape shape) {
        int n = this.shapes.indexOf((Object)shape);
        if (n != -1) {
            this.remove(n, 1);
        }
        return n;
    }

    public Sequence<Shape> remove(int n, int n2) {
        Sequence sequence = this.shapes.remove(n, n2);
        int n3 = sequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Shape shape = (Shape)sequence.get(i);
            shape.setParent(null);
        }
        if (sequence.getLength() > 0) {
            this.invalidate();
            this.groupListeners.shapesRemoved(this, n, n2);
        }
        return sequence;
    }

    public Shape get(int n) {
        return (Shape)this.shapes.get(n);
    }

    public int indexOf(Shape shape) {
        return this.shapes.indexOf((Object)shape);
    }

    public int getLength() {
        return this.shapes.getLength();
    }

    @Override
    public Iterator<Shape> iterator() {
        return new ImmutableIterator((Iterator)this.shapes.iterator());
    }

    public ListenerList<GroupListener> getGroupListeners() {
        return this.groupListeners;
    }

    private static class GroupListenerList
    extends ListenerList<GroupListener>
    implements GroupListener {
        private GroupListenerList() {
        }

        @Override
        public void shapeInserted(Group group, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                GroupListener groupListener = (GroupListener)iterator.next();
                groupListener.shapeInserted(group, n);
            }
        }

        @Override
        public void shapesRemoved(Group group, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                GroupListener groupListener = (GroupListener)iterator.next();
                groupListener.shapesRemoved(group, n, n2);
            }
        }
    }
}

