/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media.drawing;

import java.awt.Shape;
import java.awt.geom.QuadCurve2D;
import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.media.drawing.QuadCurveListener;
import org.apache.pivot.wtk.media.drawing.Shape2D;

public class QuadCurve
extends Shape2D {
    private QuadCurve2D.Float quadCurve2D = new QuadCurve2D.Float();
    private QuadCurveListenerList quadCurveListeners = new QuadCurveListenerList();

    public int getX1() {
        return (int)this.quadCurve2D.x1;
    }

    public void setX1(int n) {
        this.setEndpoints(n, this.getY1(), this.getX2(), this.getY2());
    }

    public int getY1() {
        return (int)this.quadCurve2D.y1;
    }

    public void setY1(int n) {
        this.setEndpoints(this.getX1(), n, this.getX2(), this.getY2());
    }

    public int getX2() {
        return (int)this.quadCurve2D.x2;
    }

    public void setX2(int n) {
        this.setEndpoints(this.getX1(), this.getY1(), n, this.getY2());
    }

    public int getY2() {
        return (int)this.quadCurve2D.y2;
    }

    public void setY2(int n) {
        this.setEndpoints(this.getX1(), this.getY1(), this.getX2(), n);
    }

    public void setEndpoints(int n, int n2, int n3, int n4) {
        int n5 = this.getX1();
        int n6 = this.getY1();
        int n7 = this.getX2();
        int n8 = this.getY2();
        if (n5 != n || n6 != n2 || n7 != n3 || n8 != n4) {
            this.quadCurve2D.x1 = n;
            this.quadCurve2D.y1 = n2;
            this.quadCurve2D.x2 = n3;
            this.quadCurve2D.y2 = n4;
            this.invalidate();
            this.quadCurveListeners.endpointsChanged(this, n5, n6, n7, n8);
        }
    }

    public int getControlX() {
        return (int)this.quadCurve2D.ctrlx;
    }

    public void setControlX(int n) {
        this.setControlPoint(n, this.getControlY());
    }

    public int getControlY() {
        return (int)this.quadCurve2D.ctrly;
    }

    public void setControlY(int n) {
        this.setControlPoint(this.getControlX(), n);
    }

    public void setControlPoint(int n, int n2) {
        int n3 = this.getControlX();
        int n4 = this.getControlY();
        if (n3 != n || n4 != n2) {
            this.quadCurve2D.ctrlx = n;
            this.quadCurve2D.ctrly = n2;
            this.invalidate();
            this.quadCurveListeners.controlPointChanged(this, n3, n4);
        }
    }

    @Override
    protected Shape getShape2D() {
        return this.quadCurve2D;
    }

    public ListenerList<QuadCurveListener> getQuadCurveListeners() {
        return this.quadCurveListeners;
    }

    private static class QuadCurveListenerList
    extends ListenerList<QuadCurveListener>
    implements QuadCurveListener {
        private QuadCurveListenerList() {
        }

        @Override
        public void endpointsChanged(QuadCurve quadCurve, int n, int n2, int n3, int n4) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                QuadCurveListener quadCurveListener = (QuadCurveListener)iterator.next();
                quadCurveListener.endpointsChanged(quadCurve, n, n2, n3, n4);
            }
        }

        @Override
        public void controlPointChanged(QuadCurve quadCurve, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                QuadCurveListener quadCurveListener = (QuadCurveListener)iterator.next();
                quadCurveListener.controlPointChanged(quadCurve, n, n2);
            }
        }
    }
}

