/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media.drawing;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.media.drawing.RectangleListener;
import org.apache.pivot.wtk.media.drawing.Shape2D;

public class Rectangle
extends Shape2D {
    private RectangularShape rectangularShape = new Rectangle2D.Float();
    private RectangleListenerList rectangleListeners = new RectangleListenerList();

    public int getWidth() {
        return (int)this.rectangularShape.getWidth();
    }

    public void setWidth(int n) {
        this.setSize(n, this.getHeight());
    }

    public int getHeight() {
        return (int)this.rectangularShape.getHeight();
    }

    public void setHeight(int n) {
        this.setSize(this.getWidth(), n);
    }

    public void setSize(int n, int n2) {
        int n3 = (int)this.rectangularShape.getWidth();
        int n4 = (int)this.rectangularShape.getHeight();
        if (n3 != n || n4 != n2) {
            if (this.rectangularShape instanceof Rectangle2D) {
                Rectangle2D.Float float_ = (Rectangle2D.Float)this.rectangularShape;
                float_.width = n;
                float_.height = n2;
            } else {
                RoundRectangle2D.Float float_ = (RoundRectangle2D.Float)this.rectangularShape;
                float_.width = n;
                float_.height = n2;
            }
            this.invalidate();
            this.rectangleListeners.sizeChanged(this, n3, n4);
        }
    }

    public int getCornerRadius() {
        int n;
        if (this.rectangularShape instanceof Rectangle2D) {
            n = 0;
        } else {
            RoundRectangle2D.Float float_ = (RoundRectangle2D.Float)this.rectangularShape;
            n = (int)float_.archeight;
        }
        return n;
    }

    public void setCornerRadius(int n) {
        int n2 = this.getCornerRadius();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n == 0) {
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            float_.width = n3;
            float_.height = n4;
            this.rectangularShape = new Rectangle2D.Float();
        } else {
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float();
            float_.width = n3;
            float_.height = n4;
            float_.arcwidth = n;
            float_.archeight = n;
            this.rectangularShape = float_;
        }
        this.invalidate();
        this.rectangleListeners.cornerRadiusChanged(this, n2);
    }

    @Override
    protected Shape getShape2D() {
        return this.rectangularShape;
    }

    public ListenerList<RectangleListener> getRectangleListeners() {
        return this.rectangleListeners;
    }

    private static class RectangleListenerList
    extends ListenerList<RectangleListener>
    implements RectangleListener {
        private RectangleListenerList() {
        }

        @Override
        public void sizeChanged(Rectangle rectangle, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RectangleListener rectangleListener = (RectangleListener)iterator.next();
                rectangleListener.sizeChanged(rectangle, n, n2);
            }
        }

        @Override
        public void cornerRadiusChanged(Rectangle rectangle, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RectangleListener rectangleListener = (RectangleListener)iterator.next();
                rectangleListener.cornerRadiusChanged(rectangle, n);
            }
        }
    }
}

