/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.BorderListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.CornerRadii;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class BorderSkin
extends ContainerSkin
implements BorderListener {
    private FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
    private Font font;
    private Color color;
    private Color titleColor;
    private int thickness;
    private Insets padding;
    private CornerRadii cornerRadii;

    public BorderSkin() {
        Theme theme = Theme.getTheme();
        this.setBackgroundColor(Color.WHITE);
        this.font = theme.getFont().deriveFont(1);
        this.color = Color.BLACK;
        this.titleColor = Color.BLACK;
        this.thickness = 1;
        this.padding = Insets.NONE;
        this.cornerRadii = CornerRadii.NONE;
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Border border = (Border)component;
        border.getBorderListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int n) {
        Object object;
        int n2 = 0;
        Border border = (Border)this.getComponent();
        int n3 = this.thickness;
        String string = border.getTitle();
        if (string != null && string.length() > 0) {
            object = this.font.getStringBounds(string, this.fontRenderContext);
            n2 = (int)Math.ceil(((RectangularShape)object).getWidth());
            LineMetrics lineMetrics = this.font.getLineMetrics(string, this.fontRenderContext);
            n3 = Math.max((int)Math.ceil(lineMetrics.getHeight()), n3);
        }
        if ((object = border.getContent()) != null) {
            if (n != -1) {
                n = Math.max(n - (n3 + this.thickness) - this.padding.top - this.padding.bottom, 0);
            }
            n2 = ((Component)object).getPreferredWidth(n);
        }
        return n2 += this.padding.left + this.padding.right + this.thickness * 2;
    }

    @Override
    public int getPreferredHeight(int n) {
        Object object;
        int n2 = 0;
        Border border = (Border)this.getComponent();
        int n3 = this.thickness;
        String string = border.getTitle();
        if (string != null && string.length() > 0) {
            object = this.font.getLineMetrics(string, this.fontRenderContext);
            n3 = Math.max((int)Math.ceil(((LineMetrics)object).getHeight()), n3);
        }
        if ((object = border.getContent()) != null) {
            if (n != -1) {
                n = Math.max(n - this.thickness * 2 - this.padding.left - this.padding.right, 0);
            }
            n2 = ((Component)object).getPreferredHeight(n);
        }
        return n2 += this.padding.top + this.padding.bottom + (n3 + this.thickness);
    }

    @Override
    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    @Override
    public int getBaseline(int n, int n2) {
        int n3 = -1;
        Border border = (Border)this.getComponent();
        int n4 = this.thickness;
        Component component = border.getContent();
        if (component != null) {
            String string = border.getTitle();
            if (string != null && string.length() > 0) {
                LineMetrics lineMetrics = this.font.getLineMetrics(string, this.fontRenderContext);
                n4 = Math.max((int)Math.ceil(lineMetrics.getHeight()), n4);
            }
            int n5 = Math.max(n - this.thickness * 2 - (this.padding.left + this.padding.right), 0);
            int n6 = Math.max(n2 - (n4 + this.thickness) - (this.padding.top + this.padding.bottom), 0);
            n3 = component.getBaseline(n5, n6);
        }
        if (n3 != -1) {
            n3 += this.padding.top + n4;
        }
        return n3;
    }

    @Override
    public void layout() {
        Object object;
        int n = this.getWidth();
        int n2 = this.getHeight();
        Border border = (Border)this.getComponent();
        int n3 = this.thickness;
        String string = border.getTitle();
        if (string != null && string.length() > 0) {
            object = this.font.getLineMetrics(string, this.fontRenderContext);
            n3 = Math.max((int)Math.ceil(((LineMetrics)object).getHeight()), n3);
        }
        if ((object = border.getContent()) != null) {
            ((Component)object).setLocation(this.padding.left + this.thickness, this.padding.top + n3);
            int n4 = Math.max(n - (this.padding.left + this.padding.right + this.thickness * 2), 0);
            int n5 = Math.max(n2 - (this.padding.top + this.padding.bottom + (n3 + this.thickness)), 0);
            ((Component)object).setSize(n4, n5);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        Border border = (Border)this.getComponent();
        int n = this.thickness;
        float f = 0.0f;
        String string = border.getTitle();
        if (string != null && string.length() > 0) {
            LineMetrics lineMetrics = this.font.getLineMetrics(string, this.fontRenderContext);
            f = lineMetrics.getAscent();
            n = Math.max((int)Math.ceil(lineMetrics.getHeight()), n);
        }
        int n2 = this.cornerRadii.topLeft;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = this.thickness / 2;
        int n6 = n / 2;
        int n7 = Math.max(n3 - this.thickness, 0);
        int n8 = Math.max(n4 - (int)Math.ceil((double)(n + this.thickness) * 0.5), 0);
        Color color = this.getBackgroundColor();
        if (color != null) {
            graphics2D.setPaint(color);
            if (n2 > 0) {
                graphics2D.fillRoundRect(n5, n6, n7, n8, n2, n2);
            } else {
                graphics2D.fillRect(n5, n6, n7, n8);
            }
        }
        if (string != null) {
            if (this.fontRenderContext.isAntiAliased()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Platform.getTextAntialiasingHint());
            }
            if (this.fontRenderContext.usesFractionalMetrics()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            Rectangle2D rectangle2D = this.font.getStringBounds(string, this.fontRenderContext);
            rectangle2D = new Rectangle2D.Double(this.padding.left + this.thickness, ((double)n - rectangle2D.getHeight()) / 2.0, rectangle2D.getWidth() + 1.0, rectangle2D.getHeight());
            graphics2D.setFont(this.font);
            graphics2D.setPaint(this.titleColor);
            graphics2D.drawString(string, (int)rectangle2D.getX(), (int)(rectangle2D.getY() + (double)f));
            Area area = new Area(graphics2D.getClip());
            area.subtract(new Area(rectangle2D));
            graphics2D.clip(area);
        }
        if (this.thickness > 0) {
            graphics2D.setPaint(this.color);
            if (n2 > 0) {
                graphics2D.setStroke(new BasicStroke(this.thickness));
                graphics2D.draw(new RoundRectangle2D.Double(0.5 * (double)this.thickness, 0.5 * (double)n, n7, n8, n2, n2));
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                int n9 = (n - this.thickness) / 2;
                GraphicsUtilities.drawRect(graphics2D, 0, n9, n3, Math.max(n4 - n9, 0), this.thickness);
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(BorderSkin.decodeFont(string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("titleColor is null.");
        }
        this.titleColor = color;
        this.repaintComponent();
    }

    public final void setTitleColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("titleColor is null.");
        }
        this.setTitleColor(GraphicsUtilities.decodeColor(string));
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("thickness is negative.");
        }
        this.thickness = n;
        this.invalidateComponent();
    }

    public void setThickness(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("thickness is null.");
        }
        this.setThickness(number.intValue());
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(string));
    }

    public CornerRadii getCornerRadii() {
        return this.cornerRadii;
    }

    public void setCornerRadii(CornerRadii cornerRadii) {
        if (cornerRadii == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        this.cornerRadii = cornerRadii;
        this.repaintComponent();
    }

    public final void setCornerRadii(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        this.setCornerRadii(new CornerRadii(dictionary));
    }

    public final void setCornerRadii(int n) {
        this.setCornerRadii(new CornerRadii(n));
    }

    public final void setCornerRadii(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        this.setCornerRadii(number.intValue());
    }

    public final void setCornerRadii(String string) {
        if (string == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        this.setCornerRadii(CornerRadii.decode(string));
    }

    @Override
    public void titleChanged(Border border, String string) {
        this.invalidateComponent();
    }

    @Override
    public void contentChanged(Border border, Component component) {
        this.invalidateComponent();
    }
}

