/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.util.Locale;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.Filter;
import org.apache.pivot.wtk.Calendar;
import org.apache.pivot.wtk.CalendarButton;
import org.apache.pivot.wtk.CalendarButtonListener;
import org.apache.pivot.wtk.CalendarButtonSelectionListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class CalendarButtonSkin
extends ButtonSkin
implements CalendarButtonListener,
CalendarButtonSelectionListener {
    protected Calendar calendar;
    protected Window calendarPopup;
    protected boolean pressed = false;
    private ComponentMouseButtonListener calendarPopupMouseButtonListener = new ComponentMouseButtonListener.Adapter(){

        @Override
        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            CalendarButton calendarButton = (CalendarButton)CalendarButtonSkin.this.getComponent();
            CalendarButtonSkin.this.calendarPopup.close();
            CalendarDate calendarDate = CalendarButtonSkin.this.calendar.getSelectedDate();
            calendarButton.setSelectedDate(calendarDate);
            return true;
        }
    };
    private ComponentKeyListener calendarPopupKeyListener = new ComponentKeyListener.Adapter(){

        @Override
        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            CalendarButton calendarButton = (CalendarButton)CalendarButtonSkin.this.getComponent();
            switch (n) {
                case 27: {
                    CalendarButtonSkin.this.calendarPopup.close();
                    break;
                }
                case 9: 
                case 10: {
                    Direction direction;
                    CalendarButtonSkin.this.calendarPopup.close();
                    if (n == 9) {
                        direction = Keyboard.isPressed(Keyboard.Modifier.SHIFT) ? Direction.BACKWARD : Direction.FORWARD;
                        calendarButton.transferFocus(direction);
                    }
                    direction = CalendarButtonSkin.this.calendar.getSelectedDate();
                    calendarButton.setSelectedDate((CalendarDate)direction);
                    break;
                }
            }
            return false;
        }
    };
    private WindowStateListener calendarPopupWindowStateListener = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)CalendarButtonSkin.this.displayMouseListener);
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            display.getContainerMouseListeners().remove((Object)CalendarButtonSkin.this.displayMouseListener);
            CalendarButtonSkin.this.getComponent().getWindow().moveToFront();
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display = (Display)container;
            Component component = display.getDescendantAt(n, n2);
            if (!CalendarButtonSkin.this.calendarPopup.isAncestor(component) && component != CalendarButtonSkin.this.getComponent()) {
                CalendarButtonSkin.this.calendarPopup.close();
            }
            return false;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            boolean bl = false;
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(n3, n4);
            if (window != CalendarButtonSkin.this.calendarPopup) {
                bl = true;
            }
            return bl;
        }
    };

    public CalendarButtonSkin() {
        this.calendar = new Calendar();
        this.calendarPopup = new Window();
        this.calendarPopup.getComponentMouseButtonListeners().add((Object)this.calendarPopupMouseButtonListener);
        this.calendarPopup.getComponentKeyListeners().add((Object)this.calendarPopupKeyListener);
        this.calendarPopup.getWindowStateListeners().add((Object)this.calendarPopupWindowStateListener);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        CalendarButton calendarButton = (CalendarButton)component;
        calendarButton.getCalendarButtonListeners().add((Object)this);
        calendarButton.getCalendarButtonSelectionListeners().add((Object)this);
        this.calendar.setLocale(calendarButton.getLocale());
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.calendarPopup.close();
        this.pressed = false;
    }

    @Override
    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        if (!component.isFocused() && !this.calendarPopup.containsFocus()) {
            this.calendarPopup.close();
        }
        this.pressed = false;
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        this.pressed = true;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        this.pressed = false;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        boolean bl = super.mouseClick(component, button, n, n2, n3);
        CalendarButton calendarButton = (CalendarButton)this.getComponent();
        calendarButton.requestFocus();
        calendarButton.press();
        return bl;
    }

    @Override
    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        if (n == 32) {
            this.pressed = true;
            this.repaintComponent();
            bl = true;
        } else {
            bl = super.keyPressed(component, n, keyLocation);
        }
        return bl;
    }

    @Override
    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        CalendarButton calendarButton = (CalendarButton)this.getComponent();
        if (n == 32) {
            this.pressed = false;
            this.repaintComponent();
            calendarButton.press();
        } else {
            bl = super.keyReleased(component, n, keyLocation);
        }
        return bl;
    }

    @Override
    public void localeChanged(CalendarButton calendarButton, Locale locale) {
        this.calendar.setLocale(calendarButton.getLocale());
    }

    @Override
    public void disabledDateFilterChanged(CalendarButton calendarButton, Filter<CalendarDate> filter) {
        this.calendar.setDisabledDateFilter(calendarButton.getDisabledDateFilter());
    }

    @Override
    public void selectedDateKeyChanged(CalendarButton calendarButton, String string) {
    }

    @Override
    public void selectedDateChanged(CalendarButton calendarButton, CalendarDate calendarDate) {
        CalendarDate calendarDate2 = calendarButton.getSelectedDate();
        calendarButton.setButtonData(calendarDate2);
        this.calendar.setSelectedDate(calendarDate2);
        if (calendarDate2 != null) {
            this.calendar.setYear(calendarDate2.year);
            this.calendar.setMonth(calendarDate2.month);
        }
    }
}

