/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.CardPane;
import org.apache.pivot.wtk.CardPaneListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.effects.FadeDecorator;
import org.apache.pivot.wtk.effects.ScaleDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quartic;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class CardPaneSkin
extends ContainerSkin
implements CardPaneListener {
    private Insets padding = Insets.NONE;
    private boolean sizeToSelection = false;
    private SelectionChangeEffect selectionChangeEffect = null;
    private int selectionChangeDuration = 250;
    private boolean circular = false;
    private SelectionChangeTransition selectionChangeTransition = null;
    public static final int DEFAULT_SELECTION_CHANGE_DURATION = 250;
    public static final int SELECTION_CHANGE_RATE = 30;

    @Override
    public void install(Component component) {
        super.install(component);
        CardPane cardPane = (CardPane)component;
        cardPane.getCardPaneListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int n) {
        int n2 = 0;
        if (this.sizeToSelection || n == -1) {
            Dimensions dimensions = this.getPreferredSize();
            n2 = dimensions.width;
        } else {
            CardPane cardPane = (CardPane)this.getComponent();
            for (Component component : cardPane) {
                n2 = Math.max(n2, component.getPreferredWidth(n));
            }
            n2 += this.padding.left + this.padding.right;
        }
        return n2;
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2 = 0;
        if (this.sizeToSelection || n == -1) {
            Dimensions dimensions = this.getPreferredSize();
            n2 = dimensions.height;
        } else {
            CardPane cardPane = (CardPane)this.getComponent();
            for (Component component : cardPane) {
                n2 = Math.max(n2, component.getPreferredHeight(n));
            }
            n2 += this.padding.top + this.padding.bottom;
        }
        return n2;
    }

    @Override
    public Dimensions getPreferredSize() {
        int n = 0;
        int n2 = 0;
        CardPane cardPane = (CardPane)this.getComponent();
        if (this.sizeToSelection) {
            if (this.selectionChangeTransition == null) {
                Component component = cardPane.getSelectedCard();
                if (component != null) {
                    Dimensions dimensions = component.getPreferredSize();
                    n = dimensions.width;
                    n2 = dimensions.height;
                }
            } else {
                int n3;
                int n4;
                int n5;
                int n6;
                float f = this.selectionChangeTransition.getPercentComplete();
                if (this.selectionChangeTransition.fromCard == null) {
                    n6 = 0;
                    n5 = 0;
                } else {
                    Dimensions dimensions = this.selectionChangeTransition.fromCard.getPreferredSize();
                    n6 = dimensions.width;
                    n5 = dimensions.height;
                }
                if (this.selectionChangeTransition.toCard == null) {
                    n4 = 0;
                    n3 = 0;
                } else {
                    Dimensions dimensions = this.selectionChangeTransition.toCard.getPreferredSize();
                    n4 = dimensions.width;
                    n3 = dimensions.height;
                }
                n = n6 + (int)((float)(n4 - n6) * f);
                n2 = n5 + (int)((float)(n3 - n5) * f);
            }
        } else {
            for (Component component : cardPane) {
                Dimensions dimensions = component.getPreferredSize();
                n = Math.max(dimensions.width, n);
                n2 = Math.max(dimensions.height, n2);
            }
        }
        return new Dimensions(n += this.padding.left + this.padding.right, n2 += this.padding.top + this.padding.bottom);
    }

    @Override
    public int getBaseline(int n, int n2) {
        int n3;
        int n4;
        CardPane cardPane;
        Component component;
        int n5 = -1;
        if (this.sizeToSelection && (component = (cardPane = (CardPane)this.getComponent()).getSelectedCard()) != null && (n5 = component.getBaseline(n4 = Math.max(n - (this.padding.left + this.padding.right), 0), n3 = Math.max(n2 - (this.padding.top + this.padding.bottom), 0))) != -1) {
            n5 += this.padding.top;
        }
        return n5;
    }

    @Override
    public void layout() {
        CardPane cardPane = (CardPane)this.getComponent();
        int n = Math.max(this.getWidth() - (this.padding.left + this.padding.right), 0);
        int n2 = Math.max(this.getHeight() - (this.padding.top + this.padding.bottom), 0);
        for (Component component : cardPane) {
            component.setLocation(this.padding.left, this.padding.top);
            component.setSize(n, n2);
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(string));
    }

    public boolean getSizeToSelection() {
        return this.sizeToSelection;
    }

    public void setSizeToSelection(boolean bl) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        this.sizeToSelection = bl;
        this.invalidateComponent();
    }

    public SelectionChangeEffect getSelectionChangeEffect() {
        return this.selectionChangeEffect;
    }

    public void setSelectionChangeEffect(SelectionChangeEffect selectionChangeEffect) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        this.selectionChangeEffect = selectionChangeEffect;
    }

    public void setSelectionChangeEffect(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.setSelectionChangeEffect(SelectionChangeEffect.valueOf(string.toUpperCase()));
    }

    public int getSelectionChangeDuration() {
        return this.selectionChangeDuration;
    }

    public void setSelectionChangeDuration(int n) {
        this.selectionChangeDuration = n;
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean bl) {
        this.circular = bl;
    }

    @Override
    public void componentInserted(Container container, int n) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        super.componentInserted(container, n);
        CardPane cardPane = (CardPane)container;
        Component component = cardPane.get(n);
        component.setVisible(false);
        if (cardPane.getLength() == 1) {
            cardPane.setSelectedIndex(0);
        }
        this.invalidateComponent();
    }

    @Override
    public void componentsRemoved(Container container, int n, Sequence<Component> sequence) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        super.componentsRemoved(container, n, sequence);
        int n2 = sequence.getLength();
        for (int i = 0; i < n2; ++i) {
            Component component = (Component)sequence.get(i);
            component.setVisible(true);
        }
        this.invalidateComponent();
    }

    @Override
    public Vote previewSelectedIndexChange(CardPane cardPane, int n) {
        if (cardPane.isShowing() && this.selectionChangeEffect != null && this.selectionChangeTransition == null) {
            int n2 = cardPane.getSelectedIndex();
            switch (this.selectionChangeEffect) {
                case CROSSFADE: {
                    this.selectionChangeTransition = new CrossfadeTransition(n2, n);
                    break;
                }
                case HORIZONTAL_SLIDE: 
                case VERTICAL_SLIDE: {
                    if (n2 == -1 || n == -1) break;
                    this.selectionChangeTransition = new SlideTransition(n2, n);
                    break;
                }
                case HORIZONTAL_FLIP: {
                    if (n2 == -1 || n == -1) break;
                    this.selectionChangeTransition = new FlipTransition(Orientation.HORIZONTAL, n2, n);
                    break;
                }
                case VERTICAL_FLIP: {
                    if (n2 == -1 || n == -1) break;
                    this.selectionChangeTransition = new FlipTransition(Orientation.VERTICAL, n2, n);
                    break;
                }
                case ZOOM: {
                    if (n2 == -1 || n == -1) break;
                    this.selectionChangeTransition = new ZoomTransition(n2, n);
                }
            }
            if (this.selectionChangeTransition != null) {
                this.selectionChangeTransition.start(new TransitionListener(){

                    @Override
                    public void transitionCompleted(Transition transition) {
                        CardPane cardPane = (CardPane)CardPaneSkin.this.getComponent();
                        SelectionChangeTransition selectionChangeTransition = (SelectionChangeTransition)transition;
                        int n = cardPane.indexOf(selectionChangeTransition.toCard);
                        cardPane.setSelectedIndex(n);
                        CardPaneSkin.this.selectionChangeTransition = null;
                    }
                });
            }
        }
        Vote vote = this.selectionChangeTransition == null || !this.selectionChangeTransition.isRunning() ? Vote.APPROVE : Vote.DEFER;
        return vote;
    }

    @Override
    public void selectedIndexChangeVetoed(CardPane cardPane, Vote vote) {
        if (vote == Vote.DENY && this.selectionChangeTransition != null) {
            this.selectionChangeTransition.stop();
            this.selectionChangeTransition = null;
            if (this.sizeToSelection) {
                this.invalidateComponent();
            }
        }
    }

    @Override
    public void selectedIndexChanged(CardPane cardPane, int n) {
        Component component;
        int n2 = cardPane.getSelectedIndex();
        if (n2 != -1) {
            component = cardPane.get(n2);
            component.setVisible(true);
        }
        if (n != -1) {
            component = cardPane.get(n);
            component.setVisible(false);
        }
        if (n2 == -1 || n == -1 || this.sizeToSelection) {
            this.invalidateComponent();
        }
    }

    public class ZoomTransition
    extends CrossfadeTransition {
        private ScaleDecorator fromScaleDecorator;
        private ScaleDecorator toScaleDecorator;

        public ZoomTransition(int n, int n2) {
            super(n, n2);
            this.fromScaleDecorator = new ScaleDecorator();
            this.toScaleDecorator = new ScaleDecorator();
        }

        @Override
        public void start(TransitionListener transitionListener) {
            if (this.fromCard != null) {
                this.fromCard.getDecorators().add(this.fromScaleDecorator);
            }
            if (this.toCard != null) {
                this.toCard.getDecorators().add(this.toScaleDecorator);
                this.toCard.setVisible(true);
            }
            super.start(transitionListener);
        }

        @Override
        public void stop() {
            super.stop();
            if (this.fromCard != null) {
                this.fromCard.getDecorators().remove(this.fromScaleDecorator);
                this.fromCard.setVisible(false);
            }
            if (this.toCard != null) {
                this.toCard.getDecorators().remove(this.toScaleDecorator);
            }
        }

        @Override
        protected void update() {
            float f = this.getPercentComplete();
            if (this.direction == 1) {
                this.fromScaleDecorator.setScale(1.0f + f);
                this.toScaleDecorator.setScale(f);
            } else {
                this.fromScaleDecorator.setScale(1.0f - f);
                this.toScaleDecorator.setScale(2.0f - f);
            }
            super.update();
        }
    }

    public class FlipTransition
    extends SelectionChangeTransition {
        private Orientation orientation;
        private double theta;
        private ScaleDecorator scaleDecorator;

        public FlipTransition(Orientation orientation, int n, int n2) {
            super(n, n2);
            this.scaleDecorator = new ScaleDecorator();
            this.orientation = orientation;
        }

        @Override
        public void start(TransitionListener transitionListener) {
            this.theta = 0.0;
            CardPaneSkin.this.getComponent().getDecorators().add(this.scaleDecorator);
            super.start(transitionListener);
        }

        @Override
        public void stop() {
            CardPaneSkin.this.getComponent().getDecorators().remove(this.scaleDecorator);
            super.stop();
        }

        @Override
        protected void update() {
            float f = this.getPercentComplete();
            if (f < 1.0f) {
                this.theta = Math.PI * (double)f;
                float f2 = (float)Math.abs(Math.cos(this.theta));
                if (this.orientation == Orientation.HORIZONTAL) {
                    this.scaleDecorator.setScale(f2, 1.0f);
                } else {
                    this.scaleDecorator.setScale(1.0f, f2);
                }
                this.fromCard.setVisible(this.theta < 1.5707963267948966);
                this.toCard.setVisible(this.theta >= 1.5707963267948966);
                CardPaneSkin.this.repaintComponent();
            }
        }
    }

    public class SlideTransition
    extends SelectionChangeTransition {
        private Easing slideEasing;

        public SlideTransition(int n, int n2) {
            super(n, n2);
            this.slideEasing = new Quartic();
        }

        @Override
        public void start(TransitionListener transitionListener) {
            this.toCard.setVisible(true);
            super.start(transitionListener);
        }

        @Override
        public void stop() {
            this.fromCard.setVisible(false);
            super.stop();
        }

        @Override
        protected void update() {
            int n = CardPaneSkin.this.getWidth();
            int n2 = CardPaneSkin.this.getHeight();
            float f = this.slideEasing.easeOut(this.getElapsedTime(), 0.0f, 1.0f, this.getDuration());
            int n3 = (int)((float)n * f) * -this.direction;
            int n4 = (int)((float)n2 * f) * -this.direction;
            if (CardPaneSkin.this.selectionChangeEffect == SelectionChangeEffect.HORIZONTAL_SLIDE) {
                this.fromCard.setLocation(((CardPaneSkin)CardPaneSkin.this).padding.left + n3, ((CardPaneSkin)CardPaneSkin.this).padding.top);
                this.toCard.setLocation(((CardPaneSkin)CardPaneSkin.this).padding.left - n * -this.direction + n3, ((CardPaneSkin)CardPaneSkin.this).padding.top);
            } else {
                this.fromCard.setLocation(((CardPaneSkin)CardPaneSkin.this).padding.left, ((CardPaneSkin)CardPaneSkin.this).padding.top + n4);
                this.toCard.setLocation(((CardPaneSkin)CardPaneSkin.this).padding.left, ((CardPaneSkin)CardPaneSkin.this).padding.top - n2 * -this.direction + n4);
            }
        }
    }

    public class CrossfadeTransition
    extends SelectionChangeTransition {
        private FadeDecorator fadeOutDecorator;
        private FadeDecorator fadeInDecorator;

        public CrossfadeTransition(int n, int n2) {
            super(n, n2);
            this.fadeOutDecorator = new FadeDecorator();
            this.fadeInDecorator = new FadeDecorator();
        }

        @Override
        public void start(TransitionListener transitionListener) {
            if (this.fromCard != null) {
                this.fromCard.getDecorators().add(this.fadeOutDecorator);
            }
            if (this.toCard != null) {
                this.toCard.getDecorators().add(this.fadeInDecorator);
                this.toCard.setVisible(true);
            }
            super.start(transitionListener);
        }

        @Override
        public void stop() {
            super.stop();
            if (this.fromCard != null) {
                this.fromCard.getDecorators().remove(this.fadeOutDecorator);
                this.fromCard.setVisible(false);
            }
            if (this.toCard != null) {
                this.toCard.getDecorators().remove(this.fadeInDecorator);
            }
        }

        @Override
        protected void update() {
            float f = this.getPercentComplete();
            this.fadeOutDecorator.setOpacity(1.0f - f);
            this.fadeInDecorator.setOpacity(f);
            if (CardPaneSkin.this.sizeToSelection) {
                CardPaneSkin.this.invalidateComponent();
            } else {
                CardPaneSkin.this.repaintComponent();
            }
        }
    }

    public abstract class SelectionChangeTransition
    extends Transition {
        public final int from;
        public final int to;
        public final Component fromCard;
        public final Component toCard;
        public final int direction;

        public SelectionChangeTransition(int n, int n2) {
            super(CardPaneSkin.this.selectionChangeDuration, 30, false);
            this.from = n;
            this.to = n2;
            CardPane cardPane = (CardPane)CardPaneSkin.this.getComponent();
            this.fromCard = n == -1 ? null : cardPane.get(n);
            this.toCard = n2 == -1 ? null : cardPane.get(n2);
            int n3 = cardPane.getLength();
            this.direction = CardPaneSkin.this.circular && n3 >= 3 ? (n == n3 - 1 && n2 == 0 ? 1 : (n == 0 && n2 == n3 - 1 ? -1 : Integer.signum(n2 - n))) : Integer.signum(n2 - n);
        }
    }

    public static enum SelectionChangeEffect {
        CROSSFADE,
        HORIZONTAL_SLIDE,
        VERTICAL_SLIDE,
        HORIZONTAL_FLIP,
        VERTICAL_FLIP,
        ZOOM;

    }
}

