/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Font;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.ComponentMouseListener;
import org.apache.pivot.wtk.ComponentMouseWheelListener;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DragSource;
import org.apache.pivot.wtk.DropTarget;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.MenuHandler;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Tooltip;

public abstract class ComponentSkin
implements Skin,
ComponentListener,
ComponentStateListener,
ComponentMouseListener,
ComponentMouseButtonListener,
ComponentMouseWheelListener,
ComponentKeyListener {
    private Component component = null;
    private int width = 0;
    private int height = 0;
    private ShowTooltipCallback showTooltipCallback = new ShowTooltipCallback();
    private ApplicationContext.ScheduledCallback scheduledShowTooltipCallback = null;
    public static final int SHOW_TOOLTIP_TIMEOUT = 1000;

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    @Override
    public final int getBaseline() {
        return this.getBaseline(this.width, this.height);
    }

    @Override
    public int getBaseline(int n, int n2) {
        return -1;
    }

    @Override
    public void install(Component component) {
        assert (this.component == null) : "Skin is already installed on a component.";
        component.getComponentListeners().add((Object)this);
        component.getComponentStateListeners().add((Object)this);
        component.getComponentMouseListeners().add((Object)this);
        component.getComponentMouseButtonListeners().add((Object)this);
        component.getComponentMouseWheelListeners().add((Object)this);
        component.getComponentKeyListeners().add((Object)this);
        this.component = component;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void parentChanged(Component component, Container container) {
    }

    @Override
    public void sizeChanged(Component component, int n, int n2) {
    }

    @Override
    public void preferredSizeChanged(Component component, int n, int n2) {
    }

    @Override
    public void preferredWidthLimitsChanged(Component component, int n, int n2) {
    }

    @Override
    public void preferredHeightLimitsChanged(Component component, int n, int n2) {
    }

    @Override
    public void locationChanged(Component component, int n, int n2) {
    }

    @Override
    public void visibleChanged(Component component) {
    }

    @Override
    public void styleUpdated(Component component, String string, Object object) {
    }

    @Override
    public void cursorChanged(Component component, Cursor cursor) {
    }

    @Override
    public void tooltipTextChanged(Component component, String string) {
    }

    @Override
    public void dragSourceChanged(Component component, DragSource dragSource) {
    }

    @Override
    public void dropTargetChanged(Component component, DropTarget dropTarget) {
    }

    @Override
    public void menuHandlerChanged(Component component, MenuHandler menuHandler) {
    }

    @Override
    public void enabledChanged(Component component) {
    }

    @Override
    public void focusedChanged(Component component, Component component2) {
    }

    @Override
    public boolean mouseMove(Component component, int n, int n2) {
        if (this.scheduledShowTooltipCallback != null) {
            this.scheduledShowTooltipCallback.cancel();
            this.scheduledShowTooltipCallback = null;
        }
        if (this.getComponent().getTooltipText() != null) {
            this.scheduledShowTooltipCallback = ApplicationContext.scheduleCallback(this.showTooltipCallback, 1000L);
        }
        return false;
    }

    @Override
    public void mouseOver(Component component) {
    }

    @Override
    public void mouseOut(Component component) {
        if (this.scheduledShowTooltipCallback != null) {
            this.scheduledShowTooltipCallback.cancel();
            this.scheduledShowTooltipCallback = null;
        }
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        if (this.scheduledShowTooltipCallback != null) {
            this.scheduledShowTooltipCallback.cancel();
            this.scheduledShowTooltipCallback = null;
        }
        return false;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        return false;
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        return false;
    }

    @Override
    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        return false;
    }

    @Override
    public boolean keyTyped(Component component, char c) {
        return false;
    }

    @Override
    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        if (n == 9 && this.getComponent().isFocused()) {
            Direction direction = Keyboard.isPressed(Keyboard.Modifier.SHIFT) ? Direction.BACKWARD : Direction.FORWARD;
            Component component2 = Component.getFocusedComponent();
            component2.transferFocus(direction);
            Component component3 = Component.getFocusedComponent();
            if (component2 != component3) {
                component3.scrollAreaToVisible(0, 0, component3.getWidth(), component3.getHeight());
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        return false;
    }

    protected void invalidateComponent() {
        if (this.component != null) {
            this.component.invalidate();
            this.component.repaint();
        }
    }

    protected void repaintComponent() {
        this.repaintComponent(false);
    }

    protected void repaintComponent(boolean bl) {
        if (this.component != null) {
            this.component.repaint(bl);
        }
    }

    protected void repaintComponent(Bounds bounds) {
        assert (bounds != null) : "area is null.";
        if (this.component != null) {
            this.component.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    protected void repaintComponent(int n, int n2, int n3, int n4) {
        if (this.component != null) {
            this.component.repaint(n, n2, n3, n4);
        }
    }

    protected void repaintComponent(int n, int n2, int n3, int n4, boolean bl) {
        if (this.component != null) {
            this.component.repaint(n, n2, n3, n4, bl);
        }
    }

    public static Font decodeFont(String string) {
        Font font;
        if (string.startsWith("{")) {
            try {
                font = Theme.deriveFont(JSONSerializer.parseMap((String)string));
            }
            catch (SerializationException serializationException) {
                throw new IllegalArgumentException(serializationException);
            }
        } else {
            font = Font.decode(string);
        }
        return font;
    }

    private class ShowTooltipCallback
    implements Runnable {
        private ShowTooltipCallback() {
        }

        @Override
        public void run() {
            Component component = ComponentSkin.this.getComponent();
            String string = component.getTooltipText();
            if (string != null) {
                Tooltip tooltip = new Tooltip(string);
                Point point = component.getDisplay().getMouseLocation();
                int n = point.x;
                int n2 = point.y;
                Display display = component.getDisplay();
                int n3 = tooltip.getPreferredHeight();
                if (n2 + n3 > display.getHeight()) {
                    n2 -= n3;
                }
                tooltip.setLocation(n + 16, n2);
                tooltip.open(component.getWindow());
            }
        }
    }
}

