/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.FlowPane;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class FlowPaneSkin
extends ContainerSkin {
    private HorizontalAlignment alignment = HorizontalAlignment.LEFT;
    private Insets padding = Insets.NONE;
    private int horizontalSpacing = 2;
    private int verticalSpacing = 2;
    private boolean alignToBaseline = true;

    @Override
    public int getPreferredWidth(int n) {
        FlowPane flowPane = (FlowPane)this.getComponent();
        int n2 = 0;
        int n3 = 0;
        int n4 = flowPane.getLength();
        for (int i = 0; i < n4; ++i) {
            Component component = flowPane.get(i);
            if (!component.isVisible()) continue;
            n2 += component.getPreferredWidth();
            ++n3;
        }
        if (n3 > 1) {
            n2 += this.horizontalSpacing * (n3 - 1);
        }
        return n2 += this.padding.left + this.padding.right;
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2;
        FlowPane flowPane = (FlowPane)this.getComponent();
        if (n == -1) {
            if (this.alignToBaseline) {
                Dimensions dimensions = this.getPreferredSize();
                n2 = dimensions.height;
            } else {
                n2 = 0;
                int n3 = flowPane.getLength();
                for (int i = 0; i < n3; ++i) {
                    Component component = flowPane.get(i);
                    if (!component.isVisible()) continue;
                    n2 = Math.max(n2, component.getPreferredHeight());
                }
            }
        } else {
            int n4;
            n2 = 0;
            int n5 = Math.max(n - (this.padding.left + this.padding.right), 0);
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = flowPane.getLength();
            for (n4 = 0; n4 < n10; ++n4) {
                Component component = flowPane.get(n4);
                if (!component.isVisible()) continue;
                Dimensions dimensions = component.getPreferredSize();
                if (n7 + dimensions.width > n5 && n7 > 0) {
                    n2 += n8 + n9;
                    ++n6;
                    n7 = 0;
                    n8 = 0;
                    n9 = 0;
                }
                n7 += dimensions.width + this.horizontalSpacing;
                if (this.alignToBaseline) {
                    int n11 = component.getBaseline(dimensions.width, dimensions.height);
                    n8 = Math.max(n8, n11);
                    n9 = Math.max(n9, dimensions.height - n11);
                    continue;
                }
                n8 = Math.max(n8, dimensions.height);
            }
            n4 = n8 + n9;
            if (n4 > 0) {
                n2 += n4;
                ++n6;
            }
            if (n6 > 0) {
                n2 += this.verticalSpacing * (n6 - 1);
            }
        }
        return n2 += this.padding.top + this.padding.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        FlowPane flowPane = (FlowPane)this.getComponent();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = flowPane.getLength();
        for (int i = 0; i < n5; ++i) {
            Component component = flowPane.get(i);
            if (!component.isVisible()) continue;
            Dimensions dimensions = component.getPreferredSize();
            n += dimensions.width;
            if (this.alignToBaseline) {
                int n6 = component.getBaseline(dimensions.width, dimensions.height);
                n2 = Math.max(n2, n6);
                n3 = Math.max(n3, dimensions.height - n6);
            } else {
                n2 = Math.max(n2, dimensions.height);
            }
            ++n4;
        }
        if (n4 > 1) {
            n += this.horizontalSpacing * (n4 - 1);
        }
        return new Dimensions(n += this.padding.left + this.padding.right, n2 + n3 + this.padding.top + this.padding.bottom);
    }

    @Override
    public int getBaseline(int n, int n2) {
        FlowPane flowPane = (FlowPane)this.getComponent();
        int n3 = -1;
        if (this.alignToBaseline) {
            int n4 = Math.max(n - (this.padding.left + this.padding.right), 0);
            int n5 = 0;
            int n6 = flowPane.getLength();
            for (int i = 0; i < n6; ++i) {
                Component component = flowPane.get(i);
                if (!component.isVisible()) continue;
                Dimensions dimensions = component.getPreferredSize();
                if (n5 + dimensions.width > n4 && n5 > 0) break;
                n3 = Math.max(n3, component.getBaseline(dimensions.width, dimensions.height));
                n5 += dimensions.width + this.horizontalSpacing;
            }
            n3 += this.padding.top;
        }
        return n3;
    }

    @Override
    public void layout() {
        int n;
        FlowPane flowPane = (FlowPane)this.getComponent();
        int n2 = this.getWidth();
        int n3 = Math.max(n2 - (this.padding.left + this.padding.right), 0);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n4 = 0;
        int n5 = flowPane.getLength();
        for (n = 0; n < n5; ++n) {
            Component component = flowPane.get(n);
            if (!component.isVisible()) continue;
            Dimensions dimensions = component.getPreferredSize();
            component.setSize(dimensions);
            if (n4 + dimensions.width > n3 && n4 > 0) {
                arrayList.add((Object)arrayList2);
                arrayList2 = new ArrayList();
                n4 = 0;
            }
            arrayList2.add((Object)component);
            n4 += dimensions.width + this.horizontalSpacing;
        }
        if (arrayList2.getLength() > 0) {
            arrayList.add((Object)arrayList2);
        }
        n = this.padding.top;
        int n6 = arrayList.getLength();
        for (n5 = 0; n5 < n6; ++n5) {
            Object object2;
            arrayList2 = (ArrayList)arrayList.get(n5);
            n4 = 0;
            int n7 = 0;
            int n8 = -1;
            for (Object object2 : arrayList2) {
                n4 += ((Component)object2).getWidth();
                n7 = Math.max(n7, ((Component)object2).getHeight());
                n8 = Math.max(n8, ((Component)object2).getBaseline(((Component)object2).getWidth(), ((Component)object2).getHeight()));
            }
            n4 += this.horizontalSpacing * (arrayList2.getLength() - 1);
            int n9 = 0;
            switch (this.alignment) {
                case LEFT: {
                    n9 = this.padding.left;
                    break;
                }
                case CENTER: {
                    n9 = (n2 - n4) / 2;
                    break;
                }
                case RIGHT: {
                    n9 = n2 - n4 - this.padding.right;
                }
            }
            object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                Component component = (Component)object2.next();
                int n10 = component.getBaseline(component.getWidth(), component.getHeight());
                int n11 = this.alignToBaseline && n8 != -1 && n10 != -1 ? n8 - n10 : n7 - component.getHeight();
                component.setLocation(n9, n11 + n);
                n9 += component.getWidth() + this.horizontalSpacing;
            }
            n += n7 + this.verticalSpacing;
        }
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("alignment is null.");
        }
        this.alignment = horizontalAlignment;
        this.invalidateComponent();
    }

    public final void setAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("alignment is null.");
        }
        this.setAlignment(HorizontalAlignment.valueOf(string.toUpperCase()));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(string));
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("horizontalSpacing is negative.");
        }
        this.horizontalSpacing = n;
        this.invalidateComponent();
    }

    public final void setHorizontalSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("horizontalSpacing is null.");
        }
        this.setHorizontalSpacing(number.intValue());
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("verticalSpacing is negative.");
        }
        this.verticalSpacing = n;
        this.invalidateComponent();
    }

    public final void setVerticalSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("verticalSpacing is null.");
        }
        this.setVerticalSpacing(number.intValue());
    }

    public boolean getAlignToBaseline() {
        return this.alignToBaseline;
    }

    public void setAlignToBaseline(boolean bl) {
        this.alignToBaseline = bl;
        this.invalidateComponent();
    }
}

