/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.ImageViewListener;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.ImageListener;
import org.apache.pivot.wtk.skin.ComponentSkin;

public class ImageViewSkin
extends ComponentSkin
implements ImageViewListener {
    private Color backgroundColor = null;
    private float opacity = 1.0f;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private boolean fill = false;
    private boolean preserveAspectRatio = true;
    private int imageX = 0;
    private int imageY = 0;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private ImageListener imageListener = new ImageListener(){

        @Override
        public void sizeChanged(Image image, int n, int n2) {
            ImageViewSkin.this.invalidateComponent();
        }

        @Override
        public void baselineChanged(Image image, int n) {
            ImageViewSkin.this.invalidateComponent();
        }

        @Override
        public void regionUpdated(Image image, int n, int n2, int n3, int n4) {
            Bounds bounds = new Bounds(ImageViewSkin.this.imageX + (int)Math.floor((float)n * ImageViewSkin.this.scaleX), ImageViewSkin.this.imageY + (int)Math.floor((float)n2 * ImageViewSkin.this.scaleY), (int)Math.ceil((float)n3 * ImageViewSkin.this.scaleX) + 1, (int)Math.ceil((float)n4 * ImageViewSkin.this.scaleY) + 1);
            ImageViewSkin.this.repaintComponent(bounds);
        }
    };

    @Override
    public void install(Component component) {
        super.install(component);
        ImageView imageView = (ImageView)component;
        imageView.getImageViewListeners().add((Object)this);
        Image image = imageView.getImage();
        if (image != null) {
            image.getImageListeners().add((Object)this.imageListener);
        }
    }

    @Override
    public int getPreferredWidth(int n) {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        return image == null ? 0 : image.getWidth();
    }

    @Override
    public int getPreferredHeight(int n) {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        return image == null ? 0 : image.getHeight();
    }

    @Override
    public Dimensions getPreferredSize() {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        return image == null ? new Dimensions(0, 0) : new Dimensions(image.getWidth(), image.getHeight());
    }

    @Override
    public int getBaseline(int n, int n2) {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        int n3 = -1;
        if (image != null && (n3 = image.getBaseline()) != -1) {
            Dimensions dimensions = image.getSize();
            if (this.fill) {
                if (this.preserveAspectRatio) {
                    float f = (float)n / (float)n2;
                    float f2 = (float)dimensions.width / (float)dimensions.height;
                    if (f > f2) {
                        n3 = (int)((float)n3 * ((float)n2 / (float)dimensions.height));
                    } else {
                        float f3 = (float)n / (float)dimensions.width;
                        n3 = (int)((float)n3 * f3);
                        n3 += (int)((float)n2 - (float)dimensions.height * f3) / 2;
                    }
                } else {
                    n3 = (int)((float)n3 * ((float)n2 / (float)dimensions.height));
                }
            } else if (this.verticalAlignment == VerticalAlignment.CENTER) {
                n3 += (n2 - dimensions.height) / 2;
            } else if (this.verticalAlignment == VerticalAlignment.BOTTOM) {
                n3 += n2 - dimensions.height;
            }
        }
        return n3;
    }

    @Override
    public void layout() {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        if (image != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Dimensions dimensions = image.getSize();
            if (this.fill) {
                if (this.preserveAspectRatio) {
                    float f = (float)n / (float)n2;
                    float f2 = (float)dimensions.width / (float)dimensions.height;
                    if (f > f2) {
                        this.imageY = 0;
                        this.scaleY = (float)n2 / (float)dimensions.height;
                        this.imageX = (int)((float)n - (float)dimensions.width * this.scaleY) / 2;
                        this.scaleX = this.scaleY;
                    } else {
                        this.imageX = 0;
                        this.scaleX = (float)n / (float)dimensions.width;
                        this.imageY = (int)((float)n2 - (float)dimensions.height * this.scaleX) / 2;
                        this.scaleY = this.scaleX;
                    }
                } else {
                    this.imageX = 0;
                    this.scaleX = (float)n / (float)dimensions.width;
                    this.imageY = 0;
                    this.scaleY = (float)n2 / (float)dimensions.height;
                }
            } else {
                this.imageX = this.horizontalAlignment == HorizontalAlignment.CENTER ? (n - dimensions.width) / 2 : (this.horizontalAlignment == HorizontalAlignment.RIGHT ? n - dimensions.width : 0);
                this.scaleX = 1.0f;
                this.imageY = this.verticalAlignment == VerticalAlignment.CENTER ? (n2 - dimensions.height) / 2 : (this.verticalAlignment == VerticalAlignment.BOTTOM ? n2 - dimensions.height : 0);
                this.scaleY = 1.0f;
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.backgroundColor != null) {
            graphics2D.setPaint(this.backgroundColor);
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (image != null) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.translate(this.imageX, this.imageY);
            graphics2D2.scale(this.scaleX, this.scaleY);
            float f = 1.0f;
            Composite composite = graphics2D2.getComposite();
            if (composite instanceof AlphaComposite) {
                AlphaComposite alphaComposite = (AlphaComposite)composite;
                f = alphaComposite.getAlpha();
            }
            if (this.opacity < f) {
                graphics2D2.setComposite(AlphaComposite.getInstance(3, this.opacity));
            }
            image.paint(graphics2D2);
            graphics2D2.dispose();
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(string));
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Opacity out of range [0,1].");
        }
        this.opacity = f;
        this.repaintComponent();
    }

    public final void setOpacity(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("opacity is null.");
        }
        this.setOpacity(number.floatValue());
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
        this.layout();
        this.repaintComponent();
    }

    public final void setHorizontalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.setHorizontalAlignment(HorizontalAlignment.valueOf(string.toUpperCase()));
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
        this.layout();
        this.repaintComponent();
    }

    public final void setVerticalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.setVerticalAlignment(VerticalAlignment.valueOf(string.toUpperCase()));
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
        this.layout();
        this.repaintComponent();
    }

    public boolean getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public void setPreserveAspectRatio(boolean bl) {
        this.preserveAspectRatio = bl;
        this.layout();
        this.repaintComponent();
    }

    @Override
    public void imageChanged(ImageView imageView, Image image) {
        Image image2;
        if (image != null) {
            image.getImageListeners().remove((Object)this.imageListener);
        }
        if ((image2 = imageView.getImage()) != null) {
            image2.getImageListeners().add((Object)this.imageListener);
        }
        this.invalidateComponent();
    }

    @Override
    public void asynchronousChanged(ImageView imageView) {
    }

    @Override
    public void imageKeyChanged(ImageView imageView, String string) {
    }
}

