/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.LabelListener;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.TextDecoration;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.skin.ComponentSkin;

public class LabelSkin
extends ComponentSkin
implements LabelListener {
    private Font font;
    private Color color;
    private Color backgroundColor;
    private TextDecoration textDecoration;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private Insets padding;
    private boolean wrapText;
    private ArrayList<GlyphVector> glyphVectors = null;
    private float textHeight = -1.0f;
    private static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);

    public LabelSkin() {
        Theme theme = Theme.getTheme();
        this.font = theme.getFont();
        this.color = Color.BLACK;
        this.backgroundColor = null;
        this.textDecoration = null;
        this.horizontalAlignment = HorizontalAlignment.LEFT;
        this.verticalAlignment = VerticalAlignment.TOP;
        this.padding = Insets.NONE;
        this.wrapText = false;
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Label label = (Label)this.getComponent();
        label.getLabelListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int n) {
        int n2;
        Label label = (Label)this.getComponent();
        String string = label.getText();
        if (string != null && string.length() > 0) {
            Rectangle2D rectangle2D = this.font.getStringBounds(string, FONT_RENDER_CONTEXT);
            n2 = (int)Math.ceil(rectangle2D.getWidth());
        } else {
            n2 = 0;
        }
        return n2 += this.padding.left + this.padding.right;
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2;
        float f;
        Label label = (Label)this.getComponent();
        String string = label.getText();
        LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
        float f2 = f = lineMetrics.getHeight();
        if (string != null && this.wrapText && n != -1 && (n2 = string.length()) > 0) {
            n -= this.padding.left + this.padding.right;
            float f3 = 0.0f;
            int n3 = -1;
            for (int i = 0; i < n2; ++i) {
                Rectangle2D rectangle2D;
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    n3 = i;
                }
                if (!((f3 = (float)((double)f3 + (rectangle2D = this.font.getStringBounds(string, i, i + 1, FONT_RENDER_CONTEXT)).getWidth())) > (float)n) || n3 == -1) continue;
                i = n3;
                f3 = 0.0f;
                n3 = -1;
                f2 += f;
            }
        }
        return (int)Math.ceil(f2 += (float)(this.padding.top + this.padding.bottom));
    }

    @Override
    public Dimensions getPreferredSize() {
        int n;
        Object object;
        Label label = (Label)this.getComponent();
        String string = label.getText();
        if (string != null && string.length() > 0) {
            object = this.font.getStringBounds(string, FONT_RENDER_CONTEXT);
            n = (int)Math.ceil(((RectangularShape)object).getWidth());
        } else {
            n = 0;
        }
        object = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
        int n2 = (int)Math.ceil(((LineMetrics)object).getHeight()) + (this.padding.top + this.padding.bottom);
        return new Dimensions(n += this.padding.left + this.padding.right, n2);
    }

    @Override
    public int getBaseline(int n, int n2) {
        LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
        float f = lineMetrics.getAscent();
        float f2 = this.wrapText ? (float)Math.max(this.getPreferredHeight(n) - (this.padding.top + this.padding.bottom), 0) : (float)((int)Math.ceil(lineMetrics.getHeight()));
        int n3 = -1;
        switch (this.verticalAlignment) {
            case TOP: {
                n3 = Math.round((float)this.padding.top + f);
                break;
            }
            case CENTER: {
                n3 = Math.round(((float)n2 - f2) / 2.0f + f);
                break;
            }
            case BOTTOM: {
                n3 = Math.round((float)n2 - (f2 + (float)this.padding.bottom) + f);
            }
        }
        return n3;
    }

    @Override
    public void layout() {
        int n;
        Label label = (Label)this.getComponent();
        String string = label.getText();
        this.glyphVectors = new ArrayList();
        this.textHeight = 0.0f;
        if (string != null && (n = string.length()) > 0) {
            if (this.wrapText) {
                Cloneable cloneable;
                Cloneable cloneable2;
                int n2;
                int n3 = this.getWidth() - (this.padding.left + this.padding.right);
                float f = 0.0f;
                int n4 = -1;
                int n5 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    char c = string.charAt(n2);
                    if (Character.isWhitespace(c)) {
                        n4 = n2;
                    }
                    if (!((f = (float)((double)f + ((RectangularShape)(cloneable2 = this.font.getStringBounds(string, n2, n2 + 1, FONT_RENDER_CONTEXT))).getWidth())) > (float)n3) || n4 == -1) continue;
                    n2 = n4;
                    f = 0.0f;
                    n4 = -1;
                    if (n2 - 1 - n5 > 0) {
                        cloneable = new StringCharacterIterator(string, n5, n2, n5);
                        GlyphVector glyphVector = this.font.createGlyphVector(FONT_RENDER_CONTEXT, (CharacterIterator)cloneable);
                        this.glyphVectors.add((Object)glyphVector);
                        Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
                        this.textHeight = (float)((double)this.textHeight + rectangle2D.getHeight());
                    }
                    n5 = n2 + 1;
                }
                if (n2 - 1 - n5 > 0) {
                    StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string, n5, n2, n5);
                    cloneable2 = this.font.createGlyphVector(FONT_RENDER_CONTEXT, stringCharacterIterator);
                    this.glyphVectors.add((Object)cloneable2);
                    cloneable = ((GlyphVector)cloneable2).getLogicalBounds();
                    this.textHeight = (float)((double)this.textHeight + cloneable.getHeight());
                }
            } else {
                GlyphVector glyphVector = this.font.createGlyphVector(FONT_RENDER_CONTEXT, string);
                this.glyphVectors.add((Object)glyphVector);
                Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
                this.textHeight = (float)((double)this.textHeight + rectangle2D.getHeight());
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.backgroundColor != null) {
            graphics2D.setPaint(this.backgroundColor);
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (this.glyphVectors.getLength() > 0) {
            graphics2D.setFont(this.font);
            graphics2D.setPaint(this.color);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (FONT_RENDER_CONTEXT.isAntiAliased()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Platform.getTextAntialiasingHint());
            }
            if (FONT_RENDER_CONTEXT.usesFractionalMetrics()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
            float f = lineMetrics.getAscent();
            float f2 = lineMetrics.getHeight();
            float f3 = 0.0f;
            switch (this.verticalAlignment) {
                case TOP: {
                    f3 = this.padding.top;
                    break;
                }
                case BOTTOM: {
                    f3 = (float)n2 - (this.textHeight + (float)this.padding.bottom);
                    break;
                }
                case CENTER: {
                    f3 = ((float)n2 - this.textHeight) / 2.0f;
                }
            }
            int n3 = this.glyphVectors.getLength();
            for (int i = 0; i < n3; ++i) {
                GlyphVector glyphVector = (GlyphVector)this.glyphVectors.get(i);
                Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
                float f4 = (float)rectangle2D.getWidth();
                float f5 = 0.0f;
                switch (this.horizontalAlignment) {
                    case LEFT: {
                        f5 = this.padding.left;
                        break;
                    }
                    case RIGHT: {
                        f5 = (float)n - (f4 + (float)this.padding.right);
                        break;
                    }
                    case CENTER: {
                        f5 = ((float)n - f4) / 2.0f;
                    }
                }
                graphics2D.drawGlyphVector(glyphVector, f5, f3 + f);
                if (this.textDecoration != null) {
                    graphics2D.setStroke(new BasicStroke());
                    float f6 = 0.0f;
                    switch (this.textDecoration) {
                        case UNDERLINE: {
                            f6 = f3 + f + 2.0f;
                            break;
                        }
                        case STRIKETHROUGH: {
                            f6 = f3 + f2 / 2.0f + 1.0f;
                        }
                    }
                    Line2D.Float float_ = new Line2D.Float(f5, f6, f5 + f4, f6);
                    graphics2D.draw(float_);
                }
                f3 = (float)((double)f3 + rectangle2D.getHeight());
            }
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(LabelSkin.decodeFont(string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(string));
    }

    public TextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(TextDecoration textDecoration) {
        this.textDecoration = textDecoration;
        this.repaintComponent();
    }

    public final void setTextDecoration(String string) {
        if (string == null) {
            throw new IllegalArgumentException("textDecoration is null.");
        }
        this.setTextDecoration(TextDecoration.valueOf(string.toUpperCase()));
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
        this.repaintComponent();
    }

    public final void setHorizontalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.setHorizontalAlignment(HorizontalAlignment.valueOf(string.toUpperCase()));
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
        this.repaintComponent();
    }

    public final void setVerticalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.setVerticalAlignment(VerticalAlignment.valueOf(string.toUpperCase()));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(string));
    }

    public boolean getWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean bl) {
        this.wrapText = bl;
        this.invalidateComponent();
    }

    @Override
    public void textChanged(Label label, String string) {
        this.invalidateComponent();
    }

    @Override
    public void textKeyChanged(Label label, String string) {
    }
}

