/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class MenuBarItemSkin
extends ButtonSkin
implements MenuBar.ItemListener {
    protected MenuPopup menuPopup = new MenuPopup();
    private boolean closeMenuPopup = false;
    private ComponentKeyListener menuPopupComponentKeyListener = new ComponentKeyListener.Adapter(){

        @Override
        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            boolean bl = false;
            MenuBar.Item item = (MenuBar.Item)MenuBarItemSkin.this.getComponent();
            MenuBar menuBar = (MenuBar)item.getParent();
            if (n == 37 || n == 9 && Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                menuBar.activatePreviousItem();
                bl = true;
            } else if (n == 39 || n == 9) {
                menuBar.activateNextItem();
                bl = true;
            }
            return bl;
        }
    };
    private WindowStateListener menuPopupWindowStateListener = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)MenuBarItemSkin.this.displayMouseListener);
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            Window window3;
            MenuBar.Item item = (MenuBar.Item)MenuBarItemSkin.this.getComponent();
            item.setActive(false);
            MenuBar menuBar = (MenuBar)item.getParent();
            if (menuBar.getActiveItem() == null && (window3 = menuBar.getWindow()).isOpen()) {
                window3.moveToFront();
            }
            display.getContainerMouseListeners().remove((Object)MenuBarItemSkin.this.displayMouseListener);
            MenuBarItemSkin.this.closeMenuPopup = false;
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display = (Display)container;
            Component component = display.getDescendantAt(n, n2);
            if (!MenuBarItemSkin.this.menuPopup.isAncestor(component) && component != MenuBarItemSkin.this.getComponent()) {
                MenuBarItemSkin.this.menuPopup.close(component instanceof Display || !MenuBarItemSkin.this.menuPopup.isOwner(component.getWindow()));
            }
            return false;
        }
    };

    public MenuBarItemSkin() {
        this.menuPopup.getComponentKeyListeners().add((Object)this.menuPopupComponentKeyListener);
        this.menuPopup.getWindowStateListeners().add((Object)this.menuPopupWindowStateListener);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        MenuBar.Item item = (MenuBar.Item)component;
        item.getItemListeners().add((Object)this);
        this.menuPopup.setMenu(item.getMenu());
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void mouseOver(Component component) {
        super.mouseOver(component);
        MenuBar.Item item = (MenuBar.Item)this.getComponent();
        MenuBar menuBar = (MenuBar)item.getParent();
        if (menuBar.getActiveItem() != null) {
            item.setActive(true);
        }
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        MenuBar.Item item = (MenuBar.Item)this.getComponent();
        this.closeMenuPopup = item.isActive();
        item.setActive(true);
        return bl;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        if (this.closeMenuPopup) {
            this.menuPopup.close();
        }
        return bl;
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        boolean bl = super.mouseClick(component, button, n, n2, n3);
        MenuBar.Item item = (MenuBar.Item)this.getComponent();
        item.press();
        return bl;
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.menuPopup.close(true);
    }

    @Override
    public void menuChanged(MenuBar.Item item, Menu menu) {
        this.menuPopup.setMenu(item.getMenu());
        this.repaintComponent();
    }

    @Override
    public void activeChanged(MenuBar.Item item) {
        if (item.isActive()) {
            Display display = item.getDisplay();
            Point point = item.mapPointToAncestor(display, 0, this.getHeight());
            this.menuPopup.setLocation(point.x, point.y);
            this.menuPopup.open(item.getWindow());
            this.menuPopup.requestFocus();
        } else {
            this.menuPopup.close(true);
        }
        this.repaintComponent();
    }
}

