/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class MenuItemSkin
extends ButtonSkin
implements Menu.ItemListener {
    protected MenuPopup menuPopup = new MenuPopup();
    private WindowStateListener menuPopupWindowStateListener = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)MenuItemSkin.this.displayMouseListener);
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            display.getContainerMouseListeners().remove((Object)MenuItemSkin.this.displayMouseListener);
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display = (Display)container;
            Component component = display.getDescendantAt(n, n2);
            if (!MenuItemSkin.this.menuPopup.isAncestor(component) && component != MenuItemSkin.this.getComponent()) {
                MenuItemSkin.this.menuPopup.close();
            }
            return false;
        }
    };
    protected int buttonPressInterval = 200;
    protected ApplicationContext.ScheduledCallback buttonPressCallback = null;

    public MenuItemSkin() {
        this.menuPopup.getWindowStateListeners().add((Object)this.menuPopupWindowStateListener);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Menu.Item item = (Menu.Item)component;
        item.getItemListeners().add((Object)this);
        this.menuPopup.setMenu(item.getMenu());
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void mouseOver(Component component) {
        super.mouseOver(component);
        final Menu.Item item = (Menu.Item)this.getComponent();
        item.setActive(true);
        if (this.buttonPressCallback != null) {
            this.buttonPressCallback.cancel();
            this.buttonPressCallback = null;
        }
        if (item.getMenu() != null) {
            this.buttonPressCallback = ApplicationContext.scheduleCallback(new Runnable(){

                @Override
                public void run() {
                    item.press();
                }
            }, this.buttonPressInterval);
        }
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        if (this.buttonPressCallback != null) {
            this.buttonPressCallback.cancel();
            this.buttonPressCallback = null;
        }
        if (!this.menuPopup.isOpen()) {
            Menu.Item item = (Menu.Item)this.getComponent();
            item.setActive(false);
        }
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        if (this.buttonPressCallback != null) {
            this.buttonPressCallback.cancel();
            this.buttonPressCallback = null;
        }
        return bl;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        Menu.Item item = (Menu.Item)this.getComponent();
        if (item.isActive()) {
            item.press();
        }
        return bl;
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.menuPopup.close(true);
    }

    @Override
    public void buttonPressed(Button button) {
        Menu.Item item = (Menu.Item)this.getComponent();
        Menu menu = item.getMenu();
        if (menu != null && !this.menuPopup.isOpen()) {
            Display display = item.getDisplay();
            Point point = item.mapPointToAncestor(display, this.getWidth(), 0);
            this.menuPopup.setLocation(point.x, point.y);
            this.menuPopup.open(item.getWindow());
            this.menuPopup.requestFocus();
        }
    }

    @Override
    public void nameChanged(Menu.Item item, String string) {
    }

    @Override
    public void menuChanged(Menu.Item item, Menu menu) {
        this.menuPopup.setMenu(item.getMenu());
        this.repaintComponent();
    }

    @Override
    public void activeChanged(Menu.Item item) {
        if (!item.isActive()) {
            this.menuPopup.close(true);
        }
        this.repaintComponent();
    }
}

