/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.MovieView;
import org.apache.pivot.wtk.MovieViewListener;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.media.Movie;
import org.apache.pivot.wtk.media.MovieListener;
import org.apache.pivot.wtk.skin.ComponentSkin;

public class MovieViewSkin
extends ComponentSkin
implements MovieViewListener {
    private Color backgroundColor = null;
    private float scale = 1.0f;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private int movieX = 0;
    private int movieY = 0;
    private MovieListener movieListener = new MovieListener.Adapter(){

        @Override
        public void sizeChanged(Movie movie, int n, int n2) {
            MovieViewSkin.this.invalidateComponent();
        }

        @Override
        public void regionUpdated(Movie movie, int n, int n2, int n3, int n4) {
            MovieViewSkin.this.repaintComponent(MovieViewSkin.this.movieX + (int)Math.floor((float)n * MovieViewSkin.this.scale), MovieViewSkin.this.movieY + (int)Math.floor((float)n2 * MovieViewSkin.this.scale), (int)Math.ceil((float)n3 * MovieViewSkin.this.scale) + 1, (int)Math.ceil((float)n4 * MovieViewSkin.this.scale) + 1);
        }
    };

    @Override
    public void install(Component component) {
        super.install(component);
        MovieView movieView = (MovieView)component;
        movieView.getMovieViewListeners().add((Object)this);
        Movie movie = movieView.getMovie();
        if (movie != null) {
            movie.getMovieListeners().add((Object)this.movieListener);
        }
    }

    @Override
    public int getPreferredWidth(int n) {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        return movie == null ? 0 : Math.round((float)movie.getWidth() * this.scale);
    }

    @Override
    public int getPreferredHeight(int n) {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        return movie == null ? 0 : Math.round((float)movie.getHeight() * this.scale);
    }

    @Override
    public Dimensions getPreferredSize() {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        return movie == null ? new Dimensions(0, 0) : new Dimensions(Math.round((float)movie.getWidth() * this.scale), Math.round((float)movie.getHeight() * this.scale));
    }

    @Override
    public void layout() {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        if (movie != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = movie.getWidth();
            int n4 = movie.getHeight();
            switch (this.horizontalAlignment) {
                case CENTER: {
                    this.movieX = (n - n3) / 2;
                    break;
                }
                case RIGHT: {
                    this.movieX = n - n3;
                    break;
                }
                default: {
                    this.movieX = 0;
                }
            }
            switch (this.verticalAlignment) {
                case CENTER: {
                    this.movieY = (n2 - n4) / 2;
                    break;
                }
                case BOTTOM: {
                    this.movieY = n2 - n4;
                    break;
                }
                default: {
                    this.movieY = 0;
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.backgroundColor != null) {
            graphics2D.setPaint(this.backgroundColor);
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (movie != null) {
            if (this.scale != 1.0f) {
                graphics2D.scale(this.scale, this.scale);
            }
            graphics2D.translate(this.movieX, this.movieY);
            movie.paint(graphics2D);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(string));
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("scale must be positive.");
        }
        this.scale = f;
        this.invalidateComponent();
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        if (this.horizontalAlignment != horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            this.layout();
            this.repaintComponent();
        }
    }

    public final void setHorizontalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.setHorizontalAlignment(HorizontalAlignment.valueOf(string.toUpperCase()));
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        if (this.verticalAlignment != verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
            this.layout();
            this.repaintComponent();
        }
    }

    public final void setVerticalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.setVerticalAlignment(VerticalAlignment.valueOf(string.toUpperCase()));
    }

    @Override
    public void movieChanged(MovieView movieView, Movie movie) {
        Movie movie2;
        if (movie != null) {
            movie.getMovieListeners().remove((Object)this.movieListener);
        }
        if ((movie2 = movieView.getMovie()) != null) {
            movie2.getMovieListeners().add((Object)this.movieListener);
        }
        this.invalidateComponent();
    }
}

