/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class PushButtonSkin
extends ButtonSkin {
    protected boolean pressed = false;

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.pressed = false;
    }

    @Override
    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        this.pressed = false;
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        this.pressed = true;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        this.pressed = false;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        boolean bl = super.mouseClick(component, button, n, n2, n3);
        PushButton pushButton = (PushButton)this.getComponent();
        pushButton.press();
        return bl;
    }

    @Override
    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        if (n == 32) {
            this.pressed = true;
            this.repaintComponent();
        } else {
            bl = super.keyPressed(component, n, keyLocation);
        }
        return bl;
    }

    @Override
    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        PushButton pushButton = (PushButton)this.getComponent();
        if (n == 32) {
            this.pressed = false;
            this.repaintComponent();
            pushButton.press();
        } else {
            bl = super.keyReleased(component, n, keyLocation);
        }
        return bl;
    }
}

