/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Separator;
import org.apache.pivot.wtk.SeparatorListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;

public class SeparatorSkin
extends ComponentSkin
implements SeparatorListener {
    private FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
    private Font font;
    private Color color;
    private Color headingColor;
    private int thickness;
    private Insets padding;

    public SeparatorSkin() {
        Theme theme = Theme.getTheme();
        this.font = theme.getFont().deriveFont(1);
        this.color = Color.BLACK;
        this.headingColor = Color.BLACK;
        this.thickness = 1;
        this.padding = new Insets(4, 0, 4, 4);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Separator separator = (Separator)component;
        separator.getSeparatorListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int n) {
        int n2 = 0;
        Separator separator = (Separator)this.getComponent();
        String string = separator.getHeading();
        if (string != null && string.length() > 0) {
            Rectangle2D rectangle2D = this.font.getStringBounds(string, this.fontRenderContext);
            n2 = (int)Math.ceil(rectangle2D.getWidth()) + (this.padding.left + this.padding.right);
        }
        return n2;
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2 = this.thickness;
        Separator separator = (Separator)this.getComponent();
        String string = separator.getHeading();
        if (string != null && string.length() > 0) {
            LineMetrics lineMetrics = this.font.getLineMetrics(string, this.fontRenderContext);
            n2 = Math.max((int)Math.ceil(lineMetrics.getAscent() + lineMetrics.getDescent() + lineMetrics.getLeading()), n2);
        }
        return n2 += this.padding.top + this.padding.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    @Override
    public void layout() {
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        Separator separator = (Separator)this.getComponent();
        int n = this.getWidth();
        int n2 = this.padding.top;
        String string = separator.getHeading();
        if (string != null && string.length() > 0) {
            LineMetrics lineMetrics = this.font.getLineMetrics(string, this.fontRenderContext);
            if (this.fontRenderContext.isAntiAliased()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Platform.getTextAntialiasingHint());
            }
            if (this.fontRenderContext.usesFractionalMetrics()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            graphics2D.setFont(this.font);
            graphics2D.setPaint(this.headingColor);
            graphics2D.drawString(string, (float)this.padding.left, lineMetrics.getAscent() + (float)this.padding.top);
            Rectangle2D rectangle2D = this.font.getStringBounds(string, this.fontRenderContext);
            Area area = new Area(graphics2D.getClip());
            area.subtract(new Area(new Rectangle2D.Double(this.padding.left, this.padding.top, rectangle2D.getWidth() + (double)this.padding.right, rectangle2D.getHeight())));
            graphics2D.clip(area);
            n2 = (int)((float)n2 + ((lineMetrics.getAscent() + lineMetrics.getDescent()) / 2.0f + 1.0f));
        }
        graphics2D.setStroke(new BasicStroke(this.thickness));
        graphics2D.setColor(this.color);
        graphics2D.drawLine(0, n2, n, n2);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(SeparatorSkin.decodeFont(string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getHeadingColor() {
        return this.headingColor;
    }

    public void setHeadingColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("headingColor is null.");
        }
        this.headingColor = color;
        this.repaintComponent();
    }

    public final void setHeadingColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("headingColor is null.");
        }
        this.setHeadingColor(GraphicsUtilities.decodeColor(string));
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("thickness is negative.");
        }
        this.thickness = n;
        this.invalidateComponent();
    }

    public final void setThickness(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("thickness is null.");
        }
        this.setThickness(number.intValue());
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(string));
    }

    @Override
    public void headingChanged(Separator separator, String string) {
        this.invalidateComponent();
    }
}

