/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.StackPane;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class StackPaneSkin
extends ContainerSkin {
    private Insets padding = Insets.NONE;

    @Override
    public int getPreferredWidth(int n) {
        int n2 = 0;
        StackPane stackPane = (StackPane)this.getComponent();
        for (Component component : stackPane) {
            n2 = Math.max(n2, component.getPreferredWidth(n));
        }
        return n2 += this.padding.left + this.padding.right;
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2 = 0;
        StackPane stackPane = (StackPane)this.getComponent();
        for (Component component : stackPane) {
            n2 = Math.max(n2, component.getPreferredHeight(n));
        }
        return n2 += this.padding.top + this.padding.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        int n = 0;
        int n2 = 0;
        StackPane stackPane = (StackPane)this.getComponent();
        for (Component component : stackPane) {
            Dimensions dimensions = component.getPreferredSize();
            n = Math.max(n, dimensions.width);
            n2 = Math.max(n2, dimensions.height);
        }
        return new Dimensions(n += this.padding.left + this.padding.right, n2 += this.padding.top + this.padding.bottom);
    }

    @Override
    public int getBaseline(int n, int n2) {
        return -1;
    }

    @Override
    public void layout() {
        StackPane stackPane = (StackPane)this.getComponent();
        int n = this.getWidth() - (this.padding.left + this.padding.right);
        int n2 = this.getHeight() - (this.padding.top + this.padding.bottom);
        for (Component component : stackPane) {
            component.setLocation(this.padding.left, this.padding.top);
            component.setSize(n, n2);
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(string));
    }
}

