/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.CharacterIterator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.TextAreaListener;
import org.apache.pivot.wtk.TextAreaSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.ImageListener;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.text.Document;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.ElementListener;
import org.apache.pivot.wtk.text.ImageNode;
import org.apache.pivot.wtk.text.ImageNodeListener;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.NodeListener;
import org.apache.pivot.wtk.text.Paragraph;
import org.apache.pivot.wtk.text.TextNode;
import org.apache.pivot.wtk.text.TextNodeListener;

public class TextAreaSkin
extends ComponentSkin
implements TextArea.Skin,
TextAreaListener,
TextAreaSelectionListener {
    private DocumentView documentView = null;
    private int caretX = 0;
    private Rectangle caret = new Rectangle();
    private Area selection = null;
    private boolean caretOn = false;
    private int anchor = -1;
    private Direction scrollDirection = null;
    private int mouseX = -1;
    private BlinkCaretCallback blinkCaretCallback = new BlinkCaretCallback();
    private ApplicationContext.ScheduledCallback scheduledBlinkCaretCallback = null;
    private ScrollSelectionCallback scrollSelectionCallback = new ScrollSelectionCallback();
    private ApplicationContext.ScheduledCallback scheduledScrollSelectionCallback = null;
    private Font font;
    private Color color;
    private Color inactiveColor;
    private Color backgroundColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Insets margin = new Insets(4);
    private boolean wrapText = true;
    private static final int PARAGRAPH_TERMINATOR_WIDTH = 4;
    private static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private static final int SCROLL_RATE = 30;

    public TextAreaSkin() {
        Theme theme = Theme.getTheme();
        this.font = theme.getFont();
        this.color = Color.BLACK;
        this.inactiveColor = Color.GRAY;
        this.backgroundColor = null;
        this.selectionColor = Color.LIGHT_GRAY;
        this.selectionBackgroundColor = Color.BLACK;
        this.inactiveSelectionColor = Color.LIGHT_GRAY;
        this.inactiveSelectionBackgroundColor = Color.BLACK;
    }

    @Override
    public void install(Component component) {
        super.install(component);
        TextArea textArea = (TextArea)component;
        textArea.getTextAreaListeners().add((Object)this);
        textArea.getTextAreaSelectionListeners().add((Object)this);
        textArea.setCursor(Cursor.TEXT);
        Document document = textArea.getDocument();
        if (document != null) {
            this.documentView = (DocumentView)this.createNodeView(document);
            this.documentView.attach();
            this.updateSelection();
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public int getPreferredWidth(int n) {
        int n2;
        if (this.documentView == null) {
            n2 = 0;
        } else {
            this.documentView.setBreakWidth(Integer.MAX_VALUE);
            this.documentView.validate();
            n2 = this.documentView.getWidth() + this.margin.left + this.margin.right;
        }
        return n2;
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2;
        if (this.documentView == null || n == -1) {
            n2 = 0;
        } else {
            int n3 = this.wrapText ? Math.max(n - (this.margin.left + this.margin.right), 0) : Integer.MAX_VALUE;
            this.documentView.setBreakWidth(n3);
            this.documentView.validate();
            n2 = this.documentView.getHeight() + this.margin.top + this.margin.bottom;
        }
        return n2;
    }

    @Override
    public Dimensions getPreferredSize() {
        int n;
        int n2;
        if (this.documentView == null) {
            n2 = 0;
            n = 0;
        } else {
            this.documentView.setBreakWidth(Integer.MAX_VALUE);
            this.documentView.validate();
            n2 = this.documentView.getWidth() + this.margin.left + this.margin.right;
            n = this.documentView.getHeight() + this.margin.top + this.margin.bottom;
        }
        return new Dimensions(n2, n);
    }

    @Override
    public int getBaseline(int n, int n2) {
        LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
        float f = lineMetrics.getAscent();
        return this.margin.top + Math.round(f);
    }

    @Override
    public void layout() {
        if (this.documentView != null) {
            TextArea textArea = (TextArea)this.getComponent();
            int n = this.getWidth();
            this.documentView.setBreakWidth(Math.max(n - (this.margin.left + this.margin.right), 0));
            this.documentView.validate();
            this.updateSelection();
            this.caretX = this.caret.x;
            if (textArea.isFocused()) {
                this.scrollCharacterToVisible(textArea.getSelectionStart());
            }
            this.showCaret(textArea.isFocused() && textArea.getSelectionLength() == 0);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        TextArea textArea = (TextArea)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.backgroundColor != null) {
            graphics2D.setColor(this.backgroundColor);
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (this.documentView != null) {
            if (this.selection != null) {
                graphics2D.setColor(textArea.isFocused() && textArea.isEditable() ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor);
                graphics2D.fill(this.selection);
            }
            graphics2D.translate(this.margin.left, this.margin.top);
            this.documentView.paint(graphics2D);
            graphics2D.translate(-this.margin.left, -this.margin.top);
            if (this.selection == null && this.caretOn && textArea.isFocused()) {
                graphics2D.setColor(textArea.isEditable() ? this.color : this.inactiveColor);
                graphics2D.fill(this.caret);
            }
        }
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    @Override
    public int getInsertionPoint(int n, int n2) {
        int n3;
        if (this.documentView == null) {
            n3 = -1;
        } else {
            n = Math.min(this.documentView.getWidth() - 1, Math.max(n - this.margin.left, 0));
            n3 = n2 < this.margin.top ? this.documentView.getNextInsertionPoint(n, -1, Direction.FORWARD) : (n2 > this.documentView.getHeight() + this.margin.top ? this.documentView.getNextInsertionPoint(n, -1, Direction.BACKWARD) : this.documentView.getInsertionPoint(n, n2 - this.margin.top));
        }
        return n3;
    }

    @Override
    public int getNextInsertionPoint(int n, int n2, Direction direction) {
        int n3 = this.documentView == null ? -1 : this.documentView.getNextInsertionPoint(n - this.margin.left, n2, direction);
        return n3;
    }

    @Override
    public int getRowIndex(int n) {
        int n2 = this.documentView == null ? -1 : this.documentView.getRowIndex(n);
        return n2;
    }

    @Override
    public int getRowCount() {
        int n = this.documentView == null ? 0 : this.documentView.getRowCount();
        return n;
    }

    @Override
    public Bounds getCharacterBounds(int n) {
        Bounds bounds;
        if (this.documentView == null) {
            bounds = null;
        } else {
            bounds = this.documentView.getCharacterBounds(n);
            if (bounds != null) {
                bounds = bounds.translate(this.margin.left, this.margin.top);
            }
        }
        return bounds;
    }

    private void scrollCharacterToVisible(int n) {
        TextArea textArea = (TextArea)this.getComponent();
        Bounds bounds = this.getCharacterBounds(n);
        if (bounds != null) {
            textArea.scrollAreaToVisible(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getInactiveColor() {
        return this.inactiveColor;
    }

    public void setInactiveColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveColor is null.");
        }
        this.inactiveColor = color;
        this.repaintComponent();
    }

    public final void setInactiveColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveColor is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(string));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TextAreaSkin.decodeFont(string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = color;
        this.repaintComponent();
    }

    public final void setSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = color;
        this.repaintComponent();
    }

    public final void setInactiveSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setInactiveSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor(string));
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.margin = insets;
        this.invalidateComponent();
    }

    public final void setMargin(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.setMargin(new Insets(dictionary));
    }

    public final void setMargin(int n) {
        this.setMargin(new Insets(n));
    }

    public final void setMargin(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.setMargin(number.intValue());
    }

    public final void setMargin(String string) {
        if (string == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.setMargin(Insets.decode(string));
    }

    public boolean getWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean bl) {
        if (this.wrapText != bl) {
            this.wrapText = bl;
            if (this.documentView != null) {
                this.documentView.invalidate();
            }
        }
    }

    @Override
    public boolean mouseMove(Component component, int n, int n2) {
        boolean bl = super.mouseMove(component, n, n2);
        if (Mouse.getCapturer() == component) {
            TextArea textArea = (TextArea)this.getComponent();
            Bounds bounds = textArea.getVisibleArea();
            bounds = new Bounds(bounds.x, bounds.y, bounds.width, bounds.height);
            if (n2 >= bounds.y && n2 < bounds.y + bounds.height) {
                if (this.scheduledScrollSelectionCallback != null) {
                    this.scheduledScrollSelectionCallback.cancel();
                    this.scheduledScrollSelectionCallback = null;
                }
                this.scrollDirection = null;
                int n3 = this.getInsertionPoint(n, n2);
                if (n3 != -1) {
                    if (n3 > this.anchor) {
                        textArea.setSelection(this.anchor, n3 - this.anchor);
                    } else {
                        textArea.setSelection(n3, this.anchor - n3);
                    }
                }
            } else if (this.scheduledScrollSelectionCallback == null) {
                this.scrollDirection = n2 < bounds.y ? Direction.BACKWARD : Direction.FORWARD;
                this.scheduledScrollSelectionCallback = ApplicationContext.scheduleRecurringCallback(this.scrollSelectionCallback, 30L);
                this.scrollSelectionCallback.run();
            }
            this.mouseX = n;
        } else if (Mouse.isPressed(Mouse.Button.LEFT) && Mouse.getCapturer() == null && this.anchor != -1) {
            Mouse.capture(component);
        }
        return bl;
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        if (button == Mouse.Button.LEFT) {
            TextArea textArea = (TextArea)component;
            this.anchor = this.getInsertionPoint(n, n2);
            if (this.anchor != -1) {
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    int n3 = textArea.getSelectionStart();
                    if (this.anchor > n3) {
                        textArea.setSelection(n3, this.anchor - n3);
                    } else {
                        textArea.setSelection(this.anchor, n3 - this.anchor);
                    }
                } else {
                    textArea.setSelection(this.anchor, 0);
                    bl = true;
                }
            }
            this.caretX = this.caret.x;
            textArea.requestFocus();
        }
        return bl;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        if (Mouse.getCapturer() == component) {
            if (this.scheduledScrollSelectionCallback != null) {
                this.scheduledScrollSelectionCallback.cancel();
                this.scheduledScrollSelectionCallback = null;
            }
            Mouse.release();
        }
        this.anchor = -1;
        this.scrollDirection = null;
        this.mouseX = -1;
        return bl;
    }

    @Override
    public boolean keyTyped(Component component, char c) {
        Document document;
        boolean bl = super.keyTyped(component, c);
        TextArea textArea = (TextArea)this.getComponent();
        if (textArea.isEditable() && (document = textArea.getDocument()) != null && c > '\u001f' && c != '\u007f' && !Keyboard.isPressed(Keyboard.Modifier.META)) {
            textArea.insertText(c);
            this.showCaret(true);
        }
        return bl;
    }

    @Override
    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        TextArea textArea = (TextArea)this.getComponent();
        Document document = textArea.getDocument();
        Keyboard.Modifier modifier = Platform.getCommandModifier();
        if (document != null) {
            if (n == 10 && textArea.isEditable()) {
                textArea.insertParagraph();
                bl = true;
            } else if (n == 127 && textArea.isEditable()) {
                textArea.delete(Direction.FORWARD);
                bl = true;
            } else if (n == 8 && textArea.isEditable()) {
                textArea.delete(Direction.BACKWARD);
                bl = true;
            } else if (n == 37) {
                int n2 = textArea.getSelectionStart();
                int n3 = textArea.getSelectionLength();
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    if (n2 > 0) {
                        --n2;
                        ++n3;
                    }
                } else {
                    if (n3 == 0 && n2 > 0) {
                        --n2;
                    }
                    n3 = 0;
                }
                textArea.setSelection(n2, n3);
                this.scrollCharacterToVisible(n2);
                this.caretX = this.caret.x;
                bl = true;
            } else if (n == 39) {
                int n4 = textArea.getSelectionStart();
                int n5 = textArea.getSelectionLength();
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    if (n4 + n5 < document.getCharacterCount()) {
                        ++n5;
                    }
                    textArea.setSelection(n4, n5);
                    this.scrollCharacterToVisible(n4 + n5);
                } else {
                    if (n5 > 0) {
                        n4 += n5 - 1;
                    }
                    if (n4 < document.getCharacterCount() - 1) {
                        ++n4;
                    }
                    textArea.setSelection(n4, 0);
                    this.scrollCharacterToVisible(n4);
                    this.caretX = this.caret.x;
                }
                bl = true;
            } else if (n == 38) {
                int n6;
                int n7 = textArea.getSelectionStart();
                int n8 = this.getNextInsertionPoint(this.caretX, n7, Direction.BACKWARD);
                if (n8 == -1) {
                    n8 = 0;
                }
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    int n9 = n7 + textArea.getSelectionLength() - 1;
                    n6 = n9 - n8 + 1;
                } else {
                    n6 = 0;
                }
                textArea.setSelection(n8, n6);
                this.scrollCharacterToVisible(n8);
                bl = true;
            } else if (n == 40) {
                int n10 = textArea.getSelectionStart();
                int n11 = textArea.getSelectionLength();
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    int n12;
                    int n13;
                    if (n11 == 0) {
                        n13 = n10;
                        n12 = this.caretX;
                    } else {
                        n13 = n10 + n11 - 1;
                        Bounds bounds = this.getCharacterBounds(n13);
                        n12 = bounds.x + bounds.width;
                    }
                    int n14 = this.getNextInsertionPoint(n12, n13, Direction.FORWARD);
                    if (n14 == -1) {
                        n14 = this.documentView.getCharacterCount() - 1;
                    } else if (document.getCharacterAt(n14) == '\n' && n14 < this.documentView.getCharacterCount() - 1) {
                        ++n14;
                    }
                    textArea.setSelection(n10, n14 - n10);
                    this.scrollCharacterToVisible(n14);
                } else {
                    int n15 = n11 == 0 ? n10 : n10 + n11 - 1;
                    int n16 = this.getNextInsertionPoint(this.caretX, n15, Direction.FORWARD);
                    if (n16 == -1) {
                        n16 = this.documentView.getCharacterCount() - 1;
                    }
                    textArea.setSelection(n16, 0);
                    this.scrollCharacterToVisible(n16);
                }
                bl = true;
            } else if (Keyboard.isPressed(modifier)) {
                if (n == 65) {
                    textArea.setSelection(0, document.getCharacterCount());
                    bl = true;
                } else if (n == 88 && textArea.isEditable()) {
                    textArea.cut();
                    bl = true;
                } else if (n == 67) {
                    textArea.copy();
                    bl = true;
                } else if (n == 86 && textArea.isEditable()) {
                    textArea.paste();
                    bl = true;
                } else if (n == 90 && textArea.isEditable()) {
                    if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                        textArea.undo();
                    } else {
                        textArea.redo();
                    }
                    bl = true;
                }
            } else {
                bl = super.keyPressed(component, n, keyLocation);
            }
        }
        return bl;
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    @Override
    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        TextArea textArea = (TextArea)this.getComponent();
        if (textArea.isFocused() && textArea.getSelectionLength() == 0) {
            this.scrollCharacterToVisible(textArea.getSelectionStart());
            this.showCaret(true);
        } else {
            this.showCaret(false);
        }
        this.repaintComponent();
    }

    @Override
    public void documentChanged(TextArea textArea, Document document) {
        Document document2;
        if (this.documentView != null) {
            this.documentView.detach();
            this.documentView = null;
        }
        if ((document2 = textArea.getDocument()) != null) {
            this.documentView = (DocumentView)this.createNodeView(document2);
            this.documentView.attach();
        }
        this.invalidateComponent();
    }

    @Override
    public void editableChanged(TextArea textArea) {
    }

    @Override
    public void textKeyChanged(TextArea textArea, String string) {
    }

    @Override
    public void selectionChanged(TextArea textArea, int n, int n2) {
        if (this.documentView != null && this.documentView.isValid()) {
            Rectangle rectangle;
            if (this.selection == null) {
                textArea.repaint(this.caret.x, this.caret.y, this.caret.width, this.caret.height);
            } else {
                rectangle = this.selection.getBounds();
                textArea.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.updateSelection();
            if (this.selection == null) {
                this.showCaret(textArea.isFocused());
            } else {
                this.showCaret(false);
                rectangle = this.selection.getBounds();
                textArea.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private NodeView createNodeView(Node node) {
        NodeView nodeView = null;
        if (node instanceof Document) {
            nodeView = new DocumentView((Document)node);
        } else if (node instanceof Paragraph) {
            nodeView = new ParagraphView((Paragraph)node);
        } else if (node instanceof TextNode) {
            nodeView = new TextNodeView((TextNode)node);
        } else if (node instanceof ImageNode) {
            nodeView = new ImageNodeView((ImageNode)node);
        } else {
            throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
        }
        return nodeView;
    }

    private void updateSelection() {
        if (this.documentView.getCharacterCount() > 0) {
            TextArea textArea = (TextArea)this.getComponent();
            int n = textArea.getSelectionStart();
            Bounds bounds = this.getCharacterBounds(n);
            this.caret = bounds.toRectangle();
            this.caret.width = 1;
            int n2 = textArea.getSelectionLength();
            if (n2 > 0) {
                int n3;
                int n4 = n + n2 - 1;
                Bounds bounds2 = this.getCharacterBounds(n4);
                this.selection = new Area();
                int n5 = this.getRowIndex(n);
                if (n5 == (n3 = this.getRowIndex(n4))) {
                    this.selection.add(new Area(new Rectangle(bounds.x, bounds.y, bounds2.x + bounds2.width - bounds.x, bounds2.y + bounds2.height - bounds.y)));
                } else {
                    int n6 = this.getWidth();
                    this.selection.add(new Area(new Rectangle(bounds.x, bounds.y, n6 - this.margin.right - bounds.x, bounds.height)));
                    if (n3 - n5 > 0) {
                        this.selection.add(new Area(new Rectangle(this.margin.left, bounds.y + bounds.height, n6 - (this.margin.left + this.margin.right), bounds2.y - (bounds.y + bounds.height))));
                    }
                    this.selection.add(new Area(new Rectangle(this.margin.left, bounds2.y, bounds2.x + bounds2.width - this.margin.left, bounds2.height)));
                }
            } else {
                this.selection = null;
            }
        } else {
            this.caret = new Rectangle();
            this.selection = null;
        }
    }

    private void showCaret(boolean bl) {
        if (this.scheduledBlinkCaretCallback != null) {
            this.scheduledBlinkCaretCallback.cancel();
        }
        if (bl) {
            this.caretOn = true;
            this.scheduledBlinkCaretCallback = ApplicationContext.scheduleRecurringCallback(this.blinkCaretCallback, Platform.getCursorBlinkRate());
            this.blinkCaretCallback.run();
        } else {
            this.scheduledBlinkCaretCallback = null;
        }
    }

    private class ScrollSelectionCallback
    implements Runnable {
        private ScrollSelectionCallback() {
        }

        @Override
        public void run() {
            TextArea textArea = (TextArea)TextAreaSkin.this.getComponent();
            int n = textArea.getSelectionStart();
            int n2 = textArea.getSelectionLength();
            int n3 = n + n2 - 1;
            switch (TextAreaSkin.this.scrollDirection) {
                case FORWARD: {
                    int n4 = TextAreaSkin.this.getNextInsertionPoint(TextAreaSkin.this.mouseX, n3, TextAreaSkin.this.scrollDirection);
                    if (n4 == -1) break;
                    Document document = textArea.getDocument();
                    if (document.getCharacterAt(n4) == '\n' && n4 < TextAreaSkin.this.documentView.getCharacterCount() - 1) {
                        ++n4;
                    }
                    textArea.setSelection(n, n4 - n);
                    TextAreaSkin.this.scrollCharacterToVisible(n4 - 1);
                    break;
                }
                case BACKWARD: {
                    int n5 = TextAreaSkin.this.getNextInsertionPoint(TextAreaSkin.this.mouseX, n, TextAreaSkin.this.scrollDirection);
                    if (n5 == -1) break;
                    textArea.setSelection(n5, n3 - n5 + 1);
                    TextAreaSkin.this.scrollCharacterToVisible(n5 + 1);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class BlinkCaretCallback
    implements Runnable {
        private BlinkCaretCallback() {
        }

        @Override
        public void run() {
            TextAreaSkin.this.caretOn = !TextAreaSkin.this.caretOn;
            if (TextAreaSkin.this.selection == null) {
                TextArea textArea = (TextArea)TextAreaSkin.this.getComponent();
                textArea.repaint(((TextAreaSkin)TextAreaSkin.this).caret.x, ((TextAreaSkin)TextAreaSkin.this).caret.y, ((TextAreaSkin)TextAreaSkin.this).caret.width, ((TextAreaSkin)TextAreaSkin.this).caret.height, true);
            }
        }
    }

    public class ImageNodeView
    extends NodeView
    implements ImageNodeListener,
    ImageListener {
        public ImageNodeView(ImageNode imageNode) {
            super(imageNode);
        }

        @Override
        protected void attach() {
            super.attach();
            ImageNode imageNode = (ImageNode)this.getNode();
            imageNode.getImageNodeListeners().add((Object)this);
            Image image = imageNode.getImage();
            if (image != null) {
                image.getImageListeners().add((Object)this);
            }
        }

        @Override
        protected void detach() {
            super.detach();
            ImageNode imageNode = (ImageNode)this.getNode();
            imageNode.getImageNodeListeners().remove((Object)this);
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                ImageNode imageNode = (ImageNode)this.getNode();
                Image image = imageNode.getImage();
                if (image == null) {
                    this.setSize(0, 0);
                } else {
                    this.setSize(image.getWidth(), image.getHeight());
                }
                super.validate();
            }
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            ImageNode imageNode = (ImageNode)this.getNode();
            Image image = imageNode.getImage();
            if (image != null) {
                image.paint(graphics2D);
            }
        }

        @Override
        public NodeView getNext() {
            return null;
        }

        @Override
        public int getInsertionPoint(int n, int n2) {
            return 0;
        }

        @Override
        public int getNextInsertionPoint(int n, int n2, Direction direction) {
            return n2 == -1 ? 0 : -1;
        }

        @Override
        public int getRowIndex(int n) {
            return -1;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public Bounds getCharacterBounds(int n) {
            return new Bounds(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public void imageChanged(ImageNode imageNode, Image image) {
            this.invalidate();
            Image image2 = imageNode.getImage();
            if (image2 != null) {
                image2.getImageListeners().add((Object)this);
            }
            if (image != null) {
                image.getImageListeners().remove((Object)this);
            }
        }

        @Override
        public void sizeChanged(Image image, int n, int n2) {
            this.invalidate();
        }

        @Override
        public void baselineChanged(Image image, int n) {
        }

        @Override
        public void regionUpdated(Image image, int n, int n2, int n3, int n4) {
        }
    }

    public class TextNodeView
    extends NodeView
    implements TextNodeListener {
        private int start;
        private int length;
        private GlyphVector glyphVector;
        private TextNodeView next;

        public TextNodeView(TextNode textNode) {
            this(textNode, 0);
        }

        public TextNodeView(TextNode textNode, int n) {
            super(textNode);
            this.length = 0;
            this.glyphVector = null;
            this.next = null;
            this.start = n;
        }

        @Override
        protected void attach() {
            super.attach();
            TextNode textNode = (TextNode)this.getNode();
            textNode.getTextNodeListeners().add((Object)this);
        }

        @Override
        protected void detach() {
            super.detach();
            TextNode textNode = (TextNode)this.getNode();
            textNode.getTextNodeListeners().remove((Object)this);
        }

        @Override
        public void invalidate() {
            this.length = 0;
            this.next = null;
            this.glyphVector = null;
            super.invalidate();
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                Rectangle2D rectangle2D;
                int n;
                TextNode textNode = (TextNode)this.getNode();
                int n2 = this.getBreakWidth();
                CharacterIterator characterIterator = textNode.getCharacterIterator(this.start);
                float f = 0.0f;
                int n3 = -1;
                char c = characterIterator.first();
                while (c != '\uffff' && f < (float)n2) {
                    if (Character.isWhitespace(c)) {
                        n3 = characterIterator.getIndex();
                    }
                    n = characterIterator.getIndex();
                    rectangle2D = TextAreaSkin.this.font.getStringBounds(characterIterator, n, n + 1, FONT_RENDER_CONTEXT);
                    f = (float)((double)f + rectangle2D.getWidth());
                    c = characterIterator.current();
                }
                if (f <= (float)n2) {
                    n = characterIterator.getEndIndex();
                } else if (n3 == -1) {
                    n = characterIterator.getIndex() - 1;
                    if (n <= this.start) {
                        n = this.start + 1;
                    }
                } else {
                    n = n3 + 1;
                }
                this.glyphVector = TextAreaSkin.this.font.createGlyphVector(FONT_RENDER_CONTEXT, textNode.getCharacterIterator(this.start, n));
                if (n < characterIterator.getEndIndex()) {
                    this.length = n - this.start;
                    this.next = new TextNodeView(textNode, n);
                } else {
                    this.length = characterIterator.getEndIndex() - this.start;
                }
                rectangle2D = this.glyphVector.getLogicalBounds();
                this.setSize((int)Math.ceil(rectangle2D.getWidth()), (int)Math.ceil(rectangle2D.getHeight()));
            }
            super.validate();
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            if (this.glyphVector != null) {
                TextArea textArea = (TextArea)TextAreaSkin.this.getComponent();
                if (FONT_RENDER_CONTEXT.isAntiAliased()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Platform.getTextAntialiasingHint());
                }
                if (FONT_RENDER_CONTEXT.usesFractionalMetrics()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                }
                LineMetrics lineMetrics = TextAreaSkin.this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
                float f = lineMetrics.getAscent();
                graphics2D.setFont(TextAreaSkin.this.font);
                int n = textArea.getSelectionStart();
                int n2 = textArea.getSelectionLength();
                Span span = new Span(n, n + n2 - 1);
                int n3 = this.getDocumentOffset();
                Span span2 = new Span(n3, n3 + this.getCharacterCount() - 1);
                if (n2 > 0 && span2.intersects(span)) {
                    int n4;
                    Serializable serializable;
                    int n5;
                    int n6 = this.getWidth();
                    int n7 = this.getHeight();
                    if (span.start > span2.start) {
                        Bounds bounds = this.getCharacterBounds(span.start - n3);
                        n5 = bounds.x;
                    } else {
                        n5 = 0;
                    }
                    if (span.end < span2.end) {
                        serializable = this.getCharacterBounds(span.end - n3);
                        n4 = ((Bounds)serializable).x + ((Bounds)serializable).width;
                    } else {
                        n4 = n6;
                    }
                    serializable = new Rectangle(n5, 0, n4 - n5, n7);
                    Area area = new Area();
                    area.add(new Area(new Rectangle(0, 0, n6, n7)));
                    area.subtract(new Area((Shape)((Object)serializable)));
                    Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                    graphics2D2.setColor(TextAreaSkin.this.color);
                    graphics2D2.clip(area);
                    graphics2D2.drawGlyphVector(this.glyphVector, 0.0f, f);
                    graphics2D2.dispose();
                    Color color = textArea.isFocused() ? TextAreaSkin.this.selectionColor : TextAreaSkin.this.inactiveSelectionColor;
                    Graphics2D graphics2D3 = (Graphics2D)graphics2D.create();
                    graphics2D3.setColor(textArea.isFocused() && textArea.isEditable() ? color : TextAreaSkin.this.inactiveSelectionColor);
                    graphics2D3.clip(((Rectangle)serializable).getBounds());
                    graphics2D3.drawGlyphVector(this.glyphVector, 0.0f, f);
                    graphics2D3.dispose();
                } else {
                    graphics2D.setColor(TextAreaSkin.this.color);
                    graphics2D.drawGlyphVector(this.glyphVector, 0.0f, f);
                }
            }
        }

        @Override
        public int getOffset() {
            return super.getOffset() + this.start;
        }

        @Override
        public int getCharacterCount() {
            return this.length;
        }

        @Override
        public NodeView getNext() {
            return this.next;
        }

        @Override
        public int getInsertionPoint(int n, int n2) {
            int n3;
            LineMetrics lineMetrics = TextAreaSkin.this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
            float f = lineMetrics.getAscent();
            int n4 = this.glyphVector.getNumGlyphs();
            for (n3 = 0; n3 < n4; ++n3) {
                Shape shape = this.glyphVector.getGlyphLogicalBounds(n3);
                if (!shape.contains(n, (float)n2 - f)) continue;
                Rectangle2D rectangle2D = shape.getBounds2D();
                if (!((double)n - rectangle2D.getX() > rectangle2D.getWidth() / 2.0) || n3 >= n4 - 1) break;
                ++n3;
                break;
            }
            return n3;
        }

        @Override
        public int getNextInsertionPoint(int n, int n2, Direction direction) {
            int n3 = -1;
            if (n2 == -1) {
                int n4 = this.glyphVector.getNumGlyphs();
                for (int i = 0; i < n4; ++i) {
                    Shape shape = this.glyphVector.getGlyphLogicalBounds(i);
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    float f = (float)rectangle2D.getX();
                    float f2 = (float)rectangle2D.getWidth();
                    if (!((float)n >= f) || !((float)n < f + f2)) continue;
                    if ((float)n - f > f2 / 2.0f && i < n4 - 1) {
                        ++i;
                    }
                    n3 = i;
                    break;
                }
            }
            return n3;
        }

        @Override
        public int getRowIndex(int n) {
            return -1;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public Bounds getCharacterBounds(int n) {
            Shape shape = this.glyphVector.getGlyphLogicalBounds(n);
            Rectangle2D rectangle2D = shape.getBounds2D();
            return new Bounds((int)Math.floor(rectangle2D.getX()), 0, (int)Math.ceil(rectangle2D.getWidth()), this.getHeight());
        }

        @Override
        public void charactersInserted(TextNode textNode, int n, int n2) {
            this.invalidate();
        }

        @Override
        public void charactersRemoved(TextNode textNode, int n, String string) {
            this.invalidate();
        }

        public String toString() {
            TextNode textNode = (TextNode)this.getNode();
            String string = textNode.getText();
            return "[" + string.substring(this.start, this.start + this.length) + "]";
        }
    }

    public class ParagraphView
    extends ElementView {
        private ArrayList<Row> rows;
        private Bounds terminatorBounds;

        public ParagraphView(Paragraph paragraph) {
            super(paragraph);
            this.rows = null;
            this.terminatorBounds = new Bounds(0, 0, 0, 0);
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.terminatorBounds = null;
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                int n;
                int n2 = this.getBreakWidth();
                Paragraph paragraph = (Paragraph)this.getNode();
                this.rows = new ArrayList();
                Row row = new Row();
                for (Node node : paragraph) {
                    NodeView nodeView = TextAreaSkin.this.createNodeView(node);
                    nodeView.setBreakWidth(Math.max(n2 - (row.width + 4), 0));
                    nodeView.validate();
                    n = nodeView.getWidth();
                    if (row.width + n > n2 && row.width > 0) {
                        this.rows.add((Object)row);
                        row = new Row();
                        row.width = 0;
                    }
                    row.nodeViews.add((Object)nodeView);
                    row.width += n;
                    for (nodeView = nodeView.getNext(); nodeView != null; nodeView = nodeView.getNext()) {
                        this.rows.add((Object)row);
                        row = new Row();
                        nodeView.setBreakWidth(n2);
                        nodeView.validate();
                        row.nodeViews.add((Object)nodeView);
                        row.width = nodeView.getWidth();
                    }
                }
                if (row.nodeViews.getLength() > 0) {
                    this.rows.add((Object)row);
                }
                this.remove(0, this.getLength());
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = this.rows.getLength();
                for (n = 0; n < n6; ++n) {
                    row = (Row)this.rows.get(n);
                    row.y = n5;
                    n4 = Math.max(n4, row.width);
                    for (NodeView nodeView : row.nodeViews) {
                        row.height = Math.max(row.height, nodeView.getHeight());
                    }
                    n3 = 0;
                    for (NodeView nodeView : row.nodeViews) {
                        int n7 = row.height - nodeView.getHeight();
                        nodeView.setLocation(n3, n7 + n5);
                        n3 += nodeView.getWidth();
                        this.add(nodeView);
                    }
                    n5 += row.height;
                }
                LineMetrics lineMetrics = TextAreaSkin.this.font.getLineMetrics("", 0, 0, FONT_RENDER_CONTEXT);
                n6 = (int)Math.ceil(lineMetrics.getHeight());
                int n8 = this.getCharacterCount() == 1 ? 0 : n5 - n6;
                this.terminatorBounds = new Bounds(n3, n8, 4, n6);
                n5 = Math.max(n5, this.terminatorBounds.height);
                this.setSize(n4 += this.terminatorBounds.width, n5);
            }
            super.validate();
        }

        @Override
        public NodeView getNext() {
            return null;
        }

        @Override
        public int getInsertionPoint(int n, int n2) {
            int n3;
            block3: {
                block4: {
                    n3 = -1;
                    int n4 = this.rows.getLength();
                    if (n4 <= 0) break block4;
                    for (int i = 0; i < n4; ++i) {
                        block5: {
                            Row row;
                            block7: {
                                Object object;
                                block6: {
                                    row = (Row)this.rows.get(i);
                                    if (n2 < row.y || n2 >= row.y + row.height) break block5;
                                    if (n >= row.x) break block6;
                                    object = (NodeView)row.nodeViews.get(0);
                                    n3 = ((NodeView)object).getOffset();
                                    break block5;
                                }
                                if (n <= row.x + row.width - 1) break block7;
                                object = (NodeView)row.nodeViews.get(row.nodeViews.getLength() - 1);
                                n3 = ((NodeView)object).getOffset() + ((NodeView)object).getCharacterCount();
                                if (n3 >= this.getCharacterCount() - 1) break block5;
                                --n3;
                                break block5;
                            }
                            for (NodeView nodeView : row.nodeViews) {
                                Bounds bounds = nodeView.getBounds();
                                if (!bounds.contains(n, n2)) continue;
                                n3 = nodeView.getInsertionPoint(n - nodeView.getX(), n2 - nodeView.getY()) + nodeView.getOffset();
                                break;
                            }
                        }
                        if (n3 == -1) {
                            continue;
                        }
                        break block3;
                    }
                    break block3;
                }
                n3 = this.getCharacterCount() - 1;
            }
            return n3;
        }

        @Override
        public int getNextInsertionPoint(int n, int n2, Direction direction) {
            int n3 = -1;
            int n4 = this.rows.getLength();
            if (n4 == 0 && n2 == -1) {
                n3 = 0;
            } else {
                NodeView nodeView;
                Object object;
                Row row;
                int n5;
                if (n2 == -1) {
                    n5 = direction == Direction.FORWARD ? -1 : this.rows.getLength();
                } else if (n2 == this.getCharacterCount() - 1) {
                    n5 = this.rows.getLength() - 1;
                } else {
                    for (n5 = 0; n5 < n4; ++n5) {
                        row = (Row)this.rows.get(n5);
                        object = (NodeView)row.nodeViews.get(0);
                        nodeView = (NodeView)row.nodeViews.get(row.nodeViews.getLength() - 1);
                        if (n2 >= ((NodeView)object).getOffset() && n2 < nodeView.getOffset() + nodeView.getCharacterCount()) break;
                    }
                }
                n5 = direction == Direction.FORWARD ? ++n5 : --n5;
                if (n5 >= 0 && n5 < n4) {
                    row = (Row)this.rows.get(n5);
                    object = row.nodeViews.iterator();
                    while (object.hasNext()) {
                        nodeView = (NodeView)object.next();
                        Bounds bounds = nodeView.getBounds();
                        if (n < bounds.x || n >= bounds.x + bounds.width) continue;
                        n3 = nodeView.getNextInsertionPoint(n - nodeView.getX(), -1, direction) + nodeView.getOffset();
                        break;
                    }
                    if (n3 == -1 && (n3 = ((NodeView)(object = (NodeView)row.nodeViews.get(row.nodeViews.getLength() - 1))).getOffset() + ((NodeView)object).getCharacterCount()) < this.getCharacterCount() - 1) {
                        --n3;
                    }
                }
            }
            return n3;
        }

        @Override
        public int getRowIndex(int n) {
            int n2 = -1;
            if (n == this.getCharacterCount() - 1) {
                n2 = this.rows.getLength() == 0 ? 0 : this.rows.getLength() - 1;
            } else {
                int n3 = this.rows.getLength();
                for (int i = 0; i < n3; ++i) {
                    Row row = (Row)this.rows.get(i);
                    NodeView nodeView = (NodeView)row.nodeViews.get(0);
                    NodeView nodeView2 = (NodeView)row.nodeViews.get(row.nodeViews.getLength() - 1);
                    if (n < nodeView.getOffset() || n >= nodeView2.getOffset() + nodeView2.getCharacterCount()) continue;
                    n2 = i;
                    break;
                }
            }
            return n2;
        }

        @Override
        public int getRowCount() {
            return Math.max(this.rows.getLength(), 1);
        }

        @Override
        public Bounds getCharacterBounds(int n) {
            Bounds bounds = n == this.getCharacterCount() - 1 ? this.terminatorBounds : super.getCharacterBounds(n);
            return bounds;
        }

        private class Row {
            public int x = 0;
            public int y = 0;
            public int width = 0;
            public int height = 0;
            public ArrayList<NodeView> nodeViews = new ArrayList();

            private Row() {
            }
        }
    }

    public class DocumentView
    extends ElementView {
        public DocumentView(Document document) {
            super(document);
        }

        @Override
        public void attach() {
            super.attach();
            Document document = (Document)this.getNode();
            for (Node node : document) {
                this.add(TextAreaSkin.this.createNodeView(node));
            }
        }

        @Override
        public void repaint(int n, int n2, int n3, int n4) {
            super.repaint(n, n2, n3, n4);
            TextAreaSkin.this.repaintComponent(n, n2, n3, n4);
        }

        @Override
        public void invalidate() {
            super.invalidate();
            TextAreaSkin.this.invalidateComponent();
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                int n = this.getBreakWidth();
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = this.getLength();
                while (n4 < n5) {
                    NodeView nodeView = this.get(n4++);
                    nodeView.setBreakWidth(n);
                    nodeView.validate();
                    nodeView.setLocation(0, n3);
                    n2 = Math.max(n2, nodeView.getWidth());
                    n3 += nodeView.getHeight();
                }
                this.setSize(n2, n3);
                super.validate();
            }
        }

        @Override
        public int getInsertionPoint(int n, int n2) {
            int n3 = -1;
            int n4 = this.getLength();
            for (int i = 0; i < n4; ++i) {
                NodeView nodeView = this.get(i);
                Bounds bounds = nodeView.getBounds();
                if (n2 < bounds.y || n2 >= bounds.y + bounds.height) continue;
                n3 = nodeView.getInsertionPoint(n - nodeView.getX(), n2 - nodeView.getY()) + nodeView.getOffset();
                break;
            }
            return n3;
        }

        @Override
        public int getNextInsertionPoint(int n, int n2, Direction direction) {
            int n3 = -1;
            if (this.getLength() > 0) {
                if (n2 == -1) {
                    int n4 = direction == Direction.FORWARD ? 0 : this.getLength() - 1;
                    NodeView nodeView = this.get(n4);
                    n3 = nodeView.getNextInsertionPoint(n - nodeView.getX(), -1, direction);
                    if (n3 != -1) {
                        n3 += nodeView.getOffset();
                    }
                } else {
                    NodeView nodeView;
                    int n5;
                    int n6 = this.getLength();
                    for (n5 = 0; n5 < n6; ++n5) {
                        nodeView = this.get(n5);
                        int n7 = nodeView.getOffset();
                        int n8 = nodeView.getCharacterCount();
                        if (n2 >= n7 && n2 < n7 + n8) break;
                    }
                    if (n5 < n6) {
                        nodeView = this.get(n5);
                        n3 = nodeView.getNextInsertionPoint(n - nodeView.getX(), n2 - nodeView.getOffset(), direction);
                        if (n3 == -1) {
                            if (direction == Direction.FORWARD) {
                                nodeView = n5 < n6 - 1 ? this.get(n5 + 1) : null;
                            } else {
                                NodeView nodeView2 = nodeView = n5 > 0 ? this.get(n5 - 1) : null;
                            }
                            if (nodeView != null) {
                                n3 = nodeView.getNextInsertionPoint(n - nodeView.getX(), -1, direction);
                            }
                        }
                        if (n3 != -1) {
                            n3 += nodeView.getOffset();
                        }
                    }
                }
            }
            return n3;
        }

        @Override
        public int getRowIndex(int n) {
            int n2 = 0;
            for (NodeView nodeView : this) {
                int n3 = nodeView.getOffset();
                int n4 = nodeView.getCharacterCount();
                if (n >= n3 && n < n3 + n4) {
                    n2 += nodeView.getRowIndex(n - nodeView.getOffset());
                    break;
                }
                n2 += nodeView.getRowCount();
            }
            return n2;
        }

        @Override
        public int getRowCount() {
            int n = 0;
            for (NodeView nodeView : this) {
                n += nodeView.getRowCount();
            }
            return n;
        }

        @Override
        public NodeView getNext() {
            return null;
        }

        @Override
        public void nodeInserted(Element element, int n) {
            super.nodeInserted(element, n);
            Document document = (Document)this.getNode();
            this.insert(TextAreaSkin.this.createNodeView(document.get(n)), n);
        }

        @Override
        public void nodesRemoved(Element element, int n, Sequence<Node> sequence) {
            this.remove(n, sequence.getLength());
            super.nodesRemoved(element, n, sequence);
        }
    }

    public abstract class ElementView
    extends NodeView
    implements Sequence<NodeView>,
    Iterable<NodeView>,
    ElementListener {
        private ArrayList<NodeView> nodeViews;

        public ElementView(Element element) {
            super(element);
            this.nodeViews = new ArrayList();
        }

        @Override
        protected void attach() {
            super.attach();
            Element element = (Element)this.getNode();
            element.getElementListeners().add((Object)this);
        }

        @Override
        protected void detach() {
            Element element = (Element)this.getNode();
            element.getElementListeners().remove((Object)this);
            for (NodeView nodeView : this) {
                nodeView.detach();
            }
            super.detach();
        }

        public int add(NodeView nodeView) {
            int n = this.getLength();
            this.insert(nodeView, n);
            return n;
        }

        public void insert(NodeView nodeView, int n) {
            nodeView.setParent(this);
            nodeView.attach();
            this.nodeViews.insert((Object)nodeView, n);
        }

        public NodeView update(int n, NodeView nodeView) {
            throw new UnsupportedOperationException();
        }

        public int remove(NodeView nodeView) {
            int n = this.indexOf(nodeView);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<NodeView> remove(int n, int n2) {
            Sequence sequence = this.nodeViews.remove(n, n2);
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                NodeView nodeView = (NodeView)sequence.get(i);
                nodeView.setParent(null);
                nodeView.detach();
            }
            return sequence;
        }

        public NodeView get(int n) {
            return (NodeView)this.nodeViews.get(n);
        }

        public int indexOf(NodeView nodeView) {
            return this.nodeViews.indexOf((Object)nodeView);
        }

        public int getLength() {
            return this.nodeViews.getLength();
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            Bounds bounds = new Bounds(0, 0, this.getWidth(), this.getHeight());
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle != null) {
                bounds = bounds.intersect(new Bounds(rectangle));
            }
            for (NodeView nodeView : this.nodeViews) {
                Bounds bounds2 = nodeView.getBounds();
                if (!bounds2.intersects(bounds)) continue;
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                graphics2D2.translate(bounds2.x, bounds2.y);
                nodeView.paint(graphics2D2);
                graphics2D2.dispose();
            }
        }

        @Override
        public Bounds getCharacterBounds(int n) {
            Bounds bounds = null;
            int n2 = this.nodeViews.getLength();
            for (int i = 0; i < n2; ++i) {
                NodeView nodeView = (NodeView)this.nodeViews.get(i);
                int n3 = nodeView.getOffset();
                int n4 = nodeView.getCharacterCount();
                if (n < n3 || n >= n3 + n4) continue;
                bounds = nodeView.getCharacterBounds(n - n3);
                if (bounds == null) break;
                bounds = bounds.translate(nodeView.getX(), nodeView.getY());
                break;
            }
            if (bounds != null) {
                bounds = bounds.intersect(0, 0, this.getWidth(), this.getHeight());
            }
            return bounds;
        }

        @Override
        public void nodeInserted(Element element, int n) {
            this.invalidate();
        }

        @Override
        public void nodesRemoved(Element element, int n, Sequence<Node> sequence) {
            this.invalidate();
        }

        @Override
        public Iterator<NodeView> iterator() {
            return new ImmutableIterator((Iterator)this.nodeViews.iterator());
        }
    }

    public abstract class NodeView
    implements Visual,
    NodeListener {
        private Node node = null;
        private ElementView parent = null;
        private int width = 0;
        private int height = 0;
        private int x = 0;
        private int y = 0;
        private int breakWidth = -1;
        private boolean valid = false;

        public NodeView(Node node) {
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }

        public ElementView getParent() {
            return this.parent;
        }

        protected void setParent(ElementView elementView) {
            this.parent = elementView;
        }

        protected void attach() {
            this.node.getNodeListeners().add((Object)this);
        }

        protected void detach() {
            this.node.getNodeListeners().remove((Object)this);
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public int getBaseline() {
            return -1;
        }

        public Dimensions getSize() {
            return new Dimensions(this.width, this.height);
        }

        protected void setSize(int n, int n2) {
            assert (n >= 0);
            assert (n2 >= 0);
            this.repaint();
            this.width = n;
            this.height = n2;
            this.repaint();
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Point getLocation() {
            return new Point(this.x, this.y);
        }

        protected void setLocation(int n, int n2) {
            this.repaint();
            this.x = n;
            this.y = n2;
            this.repaint();
        }

        public Bounds getBounds() {
            return new Bounds(this.x, this.y, this.width, this.height);
        }

        public void repaint() {
            this.repaint(0, 0, this.width, this.height);
        }

        public void repaint(int n, int n2, int n3, int n4) {
            assert (n3 >= 0);
            assert (n4 >= 0);
            if (this.parent != null) {
                this.parent.repaint(n + this.x, n2 + this.y, n3, n4);
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public void invalidate() {
            this.valid = false;
            if (this.parent != null) {
                this.parent.invalidate();
            }
        }

        public void validate() {
            this.valid = true;
        }

        public int getBreakWidth() {
            return this.breakWidth;
        }

        public void setBreakWidth(int n) {
            int n2 = this.breakWidth;
            if (n2 != n) {
                this.breakWidth = n;
                this.valid = false;
            }
        }

        public int getOffset() {
            return this.node.getOffset();
        }

        public int getDocumentOffset() {
            return this.parent == null ? 0 : this.parent.getDocumentOffset() + this.getOffset();
        }

        public int getCharacterCount() {
            return this.node.getCharacterCount();
        }

        public abstract NodeView getNext();

        public abstract int getInsertionPoint(int var1, int var2);

        public abstract int getNextInsertionPoint(int var1, int var2, Direction var3);

        public abstract int getRowIndex(int var1);

        public abstract int getRowCount();

        public abstract Bounds getCharacterBounds(int var1);

        @Override
        public void parentChanged(Node node, Element element) {
        }

        @Override
        public void offsetChanged(Node node, int n) {
        }

        @Override
        public void rangeInserted(Node node, int n, int n2) {
        }

        @Override
        public void rangeRemoved(Node node, int n, int n2) {
        }
    }
}

