/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowListener;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class WindowSkin
extends ContainerSkin
implements Window.Skin,
WindowListener,
WindowStateListener {
    public WindowSkin() {
        this.setBackgroundColor(Color.WHITE);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Window window = (Window)component;
        window.getWindowListeners().add((Object)this);
        window.getWindowStateListeners().add((Object)this);
        window.setFocusTraversalPolicy(new WindowFocusTraversalPolicy());
    }

    @Override
    public int getPreferredWidth(int n) {
        Window window = (Window)this.getComponent();
        Component component = window.getContent();
        return component != null ? component.getPreferredWidth(n) : 0;
    }

    @Override
    public int getPreferredHeight(int n) {
        Window window = (Window)this.getComponent();
        Component component = window.getContent();
        return component != null ? component.getPreferredHeight(n) : 0;
    }

    @Override
    public Dimensions getPreferredSize() {
        Window window = (Window)this.getComponent();
        Component component = window.getContent();
        return component != null ? component.getPreferredSize() : new Dimensions(0, 0);
    }

    @Override
    public void layout() {
        Window window = (Window)this.getComponent();
        Component component = window.getContent();
        if (component != null) {
            component.setSize(window.getSize());
        }
    }

    @Override
    public Bounds getClientArea() {
        return new Bounds(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(container, button, n, n2);
        Window window = (Window)container;
        window.moveToFront();
        return bl;
    }

    @Override
    public void titleChanged(Window window, String string) {
    }

    @Override
    public void iconChanged(Window window, Image image) {
    }

    @Override
    public void contentChanged(Window window, Component component) {
        this.invalidateComponent();
    }

    @Override
    public void activeChanged(Window window, Window window2) {
    }

    @Override
    public void maximizedChanged(Window window) {
    }

    @Override
    public Vote previewWindowOpen(Window window, Display display) {
        return Vote.APPROVE;
    }

    @Override
    public void windowOpenVetoed(Window window, Vote vote) {
    }

    @Override
    public void windowOpened(Window window) {
    }

    @Override
    public Vote previewWindowClose(Window window) {
        return Vote.APPROVE;
    }

    @Override
    public void windowCloseVetoed(Window window, Vote vote) {
    }

    @Override
    public void windowClosed(Window window, Display display, Window window2) {
    }

    public static class WindowFocusTraversalPolicy
    implements FocusTraversalPolicy {
        @Override
        public Component getNextComponent(Container container, Component component, Direction direction) {
            assert (container instanceof Window) : "container is not a Window";
            if (direction == null) {
                throw new IllegalArgumentException("direction is null.");
            }
            Window window = (Window)container;
            return window.getContent();
        }
    }
}

