/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.text.ElementListener;
import org.apache.pivot.wtk.text.Node;

public abstract class Element
extends Node
implements Sequence<Node>,
Iterable<Node> {
    private int characterCount = 0;
    private ArrayList<Node> nodes = new ArrayList();
    private ElementListenerList elementListeners = new ElementListenerList();

    public Element() {
    }

    public Element(Element element, boolean bl) {
        if (bl) {
            for (Node node : element) {
                this.add(node.duplicate(true));
            }
        }
    }

    @Override
    public void insertRange(Node node, int n) {
        if (!(node instanceof Element)) {
            throw new IllegalArgumentException("range is not an element.");
        }
        if (n < 0 || n > this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        Element element = (Element)node;
        int n2 = element.getLength();
        if (n2 > 0) {
            Sequence<Node> sequence = element.remove(0, n2);
            if (n == this.characterCount) {
                for (int i = 0; i < n2; ++i) {
                    this.add((Node)sequence.get(i));
                }
            } else {
                Node node2;
                int n3 = this.getIndexAt(n);
                Node node3 = this.get(n3);
                int n4 = n - node3.getOffset();
                if (n4 > 0) {
                    node2 = node3.removeRange(n4, node3.getCharacterCount() - n4);
                    ++n3;
                } else {
                    node2 = null;
                }
                for (int i = 0; i < n2; ++i) {
                    this.insert((Node)sequence.get(i), n3 + i);
                }
                if (node2 != null) {
                    this.insert(node2, n3 + n2);
                }
            }
        }
    }

    @Override
    public Node removeRange(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("characterCount is negative.");
        }
        if (n < 0 || n + n2 > this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        Node node = this.duplicate(false);
        if (n2 > 0) {
            int n3;
            Element element = (Element)node;
            int n4 = this.getIndexAt(n);
            if (n4 == (n3 = this.getIndexAt(n + n2 - 1))) {
                Node node2;
                Node node3 = this.get(n4);
                int n5 = node3.getOffset();
                int n6 = node3.getCharacterCount();
                if (n == n5 && n2 == n6) {
                    node2 = node3;
                    this.remove(n4, 1);
                } else {
                    node2 = node3.removeRange(n - node3.getOffset(), n2);
                }
                element.add(node2);
            } else {
                Node node4 = this.get(n4);
                int n7 = n - node4.getOffset();
                Node node5 = this.get(n3);
                int n8 = n + n2 - node5.getOffset();
                Node node6 = null;
                if (n7 > 0) {
                    node6 = node4.removeRange(n7, node4.getCharacterCount() - n7);
                    ++n4;
                }
                Node node7 = null;
                if (n8 < node5.getCharacterCount()) {
                    node7 = node5.removeRange(0, n8);
                    --n3;
                }
                int n9 = n3 - n4 + 1;
                Sequence<Node> sequence = this.remove(n4, n9);
                if (node6 != null && node6.getCharacterCount() > 0) {
                    element.add(node6);
                }
                int n10 = sequence.getLength();
                for (int i = 0; i < n10; ++i) {
                    element.add((Node)sequence.get(i));
                }
                if (node7 != null && node7.getCharacterCount() > 0) {
                    element.add(node7);
                }
            }
        }
        return node;
    }

    @Override
    public Node getRange(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("characterCount is negative.");
        }
        if (n < 0 || n + n2 > this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        Node node = this.duplicate(false);
        if (n2 > 0) {
            int n3;
            Element element = (Element)node;
            int n4 = this.getIndexAt(n);
            if (n4 == (n3 = this.getIndexAt(n + n2 - 1))) {
                Node node2 = this.get(n4);
                Node node3 = node2.getRange(n - node2.getOffset(), n2);
                element.add(node3);
            } else {
                int n5;
                Node node4;
                Node node5 = null;
                if (n4 < 0) {
                    n4 = -(n4 + 1);
                } else {
                    node4 = this.get(n4);
                    n5 = n - node4.getOffset();
                    node5 = node4.getRange(n5, node4.getCharacterCount() - n5);
                }
                node4 = null;
                if (n3 < 0) {
                    n3 = -(n3 + 1);
                } else {
                    Node node6 = this.get(n3);
                    int n6 = n + n2 - node6.getOffset();
                    node4 = node6.getRange(0, n6);
                }
                if (node5 != null && node5.getCharacterCount() > 0) {
                    element.add(node5);
                    ++n4;
                }
                for (n5 = n4; n5 < n3; ++n5) {
                    element.add(this.get(n5).duplicate(true));
                }
                if (node4 != null && node4.getCharacterCount() > 0) {
                    element.add(node4);
                }
            }
        }
        return node;
    }

    @Override
    public char getCharacterAt(int n) {
        Node node = this.getNodeAt(n);
        return node.getCharacterAt(n - node.getOffset());
    }

    @Override
    public int getCharacterCount() {
        return this.characterCount;
    }

    public int add(Node node) {
        int n = this.nodes.getLength();
        this.insert(node, n);
        return n;
    }

    public void insert(Node node, int n) {
        if (n < 0 || n > this.nodes.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (node == null) {
            throw new IllegalArgumentException("node is null.");
        }
        if (node.getParent() != null) {
            throw new IllegalArgumentException("node already has a parent.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add an element to itself.");
        }
        node.setParent(this);
        this.nodes.insert((Object)node, n);
        int n2 = node.getCharacterCount();
        this.characterCount += n2;
        if (n == 0) {
            node.setOffset(0);
        } else {
            Node node2 = (Node)this.nodes.get(n - 1);
            node.setOffset(node2.getOffset() + node2.getCharacterCount());
        }
        int n3 = this.nodes.getLength();
        for (int i = n + 1; i < n3; ++i) {
            Node node3 = (Node)this.nodes.get(i);
            node3.setOffset(node3.getOffset() + n2);
        }
        super.rangeInserted(node.getOffset(), n2);
        this.elementListeners.nodeInserted(this, n);
    }

    public Node update(int n, Node node) {
        throw new UnsupportedOperationException();
    }

    public int remove(Node node) {
        int n = this.indexOf(node);
        if (n != -1) {
            this.remove(n, 1);
        }
        return n;
    }

    public Sequence<Node> remove(int n, int n2) {
        if (n < 0 || n + n2 > this.nodes.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence sequence = this.nodes.remove(n, n2);
        if ((n2 = sequence.getLength()) > 0) {
            Node node;
            int n3;
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                Node node2 = (Node)sequence.get(n4);
                node2.setParent(null);
                n5 += node2.getCharacterCount();
            }
            this.characterCount -= n5;
            n4 = this.nodes.getLength();
            for (n3 = n; n3 < n4; ++n3) {
                node = (Node)this.nodes.get(n3);
                node.setOffset(node.getOffset() - n5);
            }
            if (n < n4) {
                node = this.get(n);
                n3 = node.getOffset();
            } else {
                n3 = this.characterCount;
            }
            super.rangeRemoved(n3, n5);
            this.elementListeners.nodesRemoved(this, n, (Sequence<Node>)sequence);
        }
        return sequence;
    }

    public Node get(int n) {
        if (n < 0 || n > this.nodes.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return (Node)this.nodes.get(n);
    }

    public int indexOf(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null.");
        }
        return this.nodes.indexOf((Object)node);
    }

    public int getLength() {
        return this.nodes.getLength();
    }

    public int getIndexAt(int n) {
        if (n < 0 || n >= this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = -1;
        int n3 = this.nodes.getLength();
        for (int i = 0; i < n3; ++i) {
            Node node = (Node)this.nodes.get(i);
            int n4 = node.getOffset();
            int n5 = node.getCharacterCount();
            if (n < n4 || n >= n4 + n5) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public Sequence<Integer> getPathAt(int n) {
        Sequence<Integer> sequence;
        int n2 = this.getIndexAt(n);
        Node node = this.get(n2);
        if (node instanceof Element) {
            Element element = (Element)node;
            sequence = element.getPathAt(n - element.getOffset());
        } else {
            sequence = new Sequence<Integer>();
        }
        sequence.insert((Object)n2, 0);
        return sequence;
    }

    public Node getNodeAt(int n) {
        if (n < 0 || n >= this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.getIndexAt(n);
        Node node = (Node)this.nodes.get(n2);
        return node;
    }

    public Node getDescendantAt(int n) {
        Node node = this.getNodeAt(n);
        if (node instanceof Element) {
            Element element = (Element)node;
            node = element.getDescendantAt(n - element.getOffset());
        }
        return node;
    }

    @Override
    protected void rangeInserted(int n, int n2) {
        this.characterCount += n2;
        int n3 = this.getIndexAt(n);
        int n4 = this.nodes.getLength();
        for (int i = n3 + 1; i < n4; ++i) {
            Node node = (Node)this.nodes.get(i);
            node.setOffset(node.getOffset() + n2);
        }
        super.rangeInserted(n, n2);
    }

    @Override
    protected void rangeRemoved(int n, int n2) {
        this.characterCount -= n2;
        if (n < this.characterCount) {
            int n3 = this.getIndexAt(n);
            int n4 = this.nodes.getLength();
            for (int i = n3 + 1; i < n4; ++i) {
                Node node = (Node)this.nodes.get(i);
                node.setOffset(node.getOffset() - n2);
            }
        }
        super.rangeRemoved(n, n2);
    }

    @Override
    public Iterator<Node> iterator() {
        return new ImmutableIterator((Iterator)this.nodes.iterator());
    }

    public void dumpOffsets() {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = this.get(i);
            System.out.println("[" + i + "] " + node.getOffset() + ":" + node.getCharacterCount());
        }
        System.out.println();
    }

    public ListenerList<ElementListener> getElementListeners() {
        return this.elementListeners;
    }

    private static class ElementListenerList
    extends ListenerList<ElementListener>
    implements ElementListener {
        private ElementListenerList() {
        }

        @Override
        public void nodeInserted(Element element, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ElementListener elementListener = (ElementListener)iterator.next();
                elementListener.nodeInserted(element, n);
            }
        }

        @Override
        public void nodesRemoved(Element element, int n, Sequence<Node> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ElementListener elementListener = (ElementListener)iterator.next();
                elementListener.nodesRemoved(element, n, sequence);
            }
        }
    }
}

