/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.text.ImageNodeListener;
import org.apache.pivot.wtk.text.Node;

public class ImageNode
extends Node {
    private Image image = null;
    private ImageNodeListenerList imageNodeListeners = new ImageNodeListenerList();

    public ImageNode() {
    }

    public ImageNode(ImageNode imageNode) {
        this.setImage(imageNode.getImage());
    }

    public ImageNode(Image image) {
        this.setImage(image);
    }

    public ImageNode(URL uRL) {
        this.setImage(uRL);
    }

    public ImageNode(String string) {
        this.setImage(string);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image image2 = this.image;
        if (image2 != image) {
            this.image = image;
            this.imageNodeListeners.imageChanged(this, image2);
        }
    }

    public void setImage(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("imageURL is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(uRL);
        if (image == null) {
            try {
                image = Image.load(uRL);
            }
            catch (TaskExecutionException taskExecutionException) {
                throw new IllegalArgumentException(taskExecutionException);
            }
            ApplicationContext.getResourceCache().put(uRL, (Object)image);
        }
        this.setImage(image);
    }

    public void setImage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("image is null.");
        }
        ClassLoader classLoader = ThreadUtilities.getClassLoader();
        this.setImage(classLoader.getResource(string));
    }

    @Override
    public char getCharacterAt(int n) {
        return '\u0000';
    }

    @Override
    public int getCharacterCount() {
        return 1;
    }

    @Override
    public void insertRange(Node node, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeRange(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getRange(int n, int n2) {
        if (n < 0 || n > 1) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 != 1) {
            throw new IllegalArgumentException("Invalid characterCount.");
        }
        return new ImageNode(this);
    }

    @Override
    public Node duplicate(boolean bl) {
        return new ImageNode(this);
    }

    public ListenerList<ImageNodeListener> getImageNodeListeners() {
        return this.imageNodeListeners;
    }

    private static class ImageNodeListenerList
    extends ListenerList<ImageNodeListener>
    implements ImageNodeListener {
        private ImageNodeListenerList() {
        }

        @Override
        public void imageChanged(ImageNode imageNode, Image image) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ImageNodeListener imageNodeListener = (ImageNodeListener)iterator.next();
                imageNodeListener.imageChanged(imageNode, image);
            }
        }
    }
}

