/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.NodeListener;

public abstract class Node {
    private Element parent = null;
    private int offset = 0;
    private NodeListenerList nodeListeners = new NodeListenerList();

    public Element getParent() {
        return this.parent;
    }

    protected void setParent(Element element) {
        Element element2 = this.parent;
        if (element2 != element) {
            this.parent = element;
            this.nodeListeners.parentChanged(this, element2);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int n) {
        int n2 = this.offset;
        if (n2 != n) {
            this.offset = n;
            this.nodeListeners.offsetChanged(this, n2);
        }
    }

    public int getDocumentOffset() {
        return this.parent == null ? 0 : this.parent.getDocumentOffset() + this.offset;
    }

    public abstract void insertRange(Node var1, int var2);

    public abstract Node removeRange(int var1, int var2);

    public Node replaceRange(int n, int n2, Node node) {
        Node node2 = this.removeRange(n, n2);
        this.insertRange(node, n);
        return node2;
    }

    public abstract Node getRange(int var1, int var2);

    public abstract char getCharacterAt(int var1);

    public abstract int getCharacterCount();

    public abstract Node duplicate(boolean var1);

    protected void rangeInserted(int n, int n2) {
        if (this.parent != null) {
            this.parent.rangeInserted(n + this.offset, n2);
        }
        this.nodeListeners.rangeInserted(this, n, n2);
    }

    protected void rangeRemoved(int n, int n2) {
        if (this.parent != null) {
            this.parent.rangeRemoved(n + this.offset, n2);
        }
        this.nodeListeners.rangeRemoved(this, n, n2);
    }

    public ListenerList<NodeListener> getNodeListeners() {
        return this.nodeListeners;
    }

    private static class NodeListenerList
    extends ListenerList<NodeListener>
    implements NodeListener {
        private NodeListenerList() {
        }

        @Override
        public void parentChanged(Node node, Element element) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                NodeListener nodeListener = (NodeListener)iterator.next();
                nodeListener.parentChanged(node, element);
            }
        }

        @Override
        public void offsetChanged(Node node, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                NodeListener nodeListener = (NodeListener)iterator.next();
                nodeListener.offsetChanged(node, n);
            }
        }

        @Override
        public void rangeInserted(Node node, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                NodeListener nodeListener = (NodeListener)iterator.next();
                nodeListener.rangeInserted(node, n, n2);
            }
        }

        @Override
        public void rangeRemoved(Node node, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                NodeListener nodeListener = (NodeListener)iterator.next();
                nodeListener.rangeRemoved(node, n, n2);
            }
        }
    }
}

