/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.text.Block;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.TextNode;

public class Paragraph
extends Block {
    public Paragraph() {
    }

    public Paragraph(String string) {
        this.add(new TextNode(string));
    }

    public Paragraph(Paragraph paragraph, boolean bl) {
        super(paragraph, bl);
    }

    @Override
    public Node removeRange(int n, int n2) {
        if (n + n2 == this.getCharacterCount()) {
            --n2;
        }
        return super.removeRange(n, n2);
    }

    @Override
    public Node getRange(int n, int n2) {
        if (n + n2 == this.getCharacterCount()) {
            --n2;
        }
        return super.getRange(n, n2);
    }

    @Override
    public char getCharacterAt(int n) {
        char c = n == this.getCharacterCount() - 1 ? (char)'\n' : (char)super.getCharacterAt(n);
        return c;
    }

    @Override
    public int getCharacterCount() {
        return super.getCharacterCount() + 1;
    }

    public int add(String string) {
        return this.add(new TextNode(string));
    }

    @Override
    public void insert(Node node, int n) {
        if (node instanceof Block) {
            throw new IllegalArgumentException("Child node must not be an instance of " + Block.class.getName());
        }
        super.insert(node, n);
    }

    @Override
    public Sequence<Integer> getPathAt(int n) {
        ArrayList arrayList = n < super.getCharacterCount() ? super.getPathAt(n) : new ArrayList();
        return arrayList;
    }

    @Override
    public Node getDescendantAt(int n) {
        Node node = n < super.getCharacterCount() ? super.getDescendantAt(n) : this;
        return node;
    }

    @Override
    public Node duplicate(boolean bl) {
        return new Paragraph(this, bl);
    }
}

