/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.wtk.text.Document;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.Paragraph;
import org.apache.pivot.wtk.text.TextNode;

public class PlainTextSerializer
implements Serializer<Document> {
    private Charset charset = null;
    public static final String MIME_TYPE = "text/plain";
    public static final int BUFFER_SIZE = 2048;

    public PlainTextSerializer() {
        this(Charset.defaultCharset());
    }

    public PlainTextSerializer(String string) {
        this(string == null ? Charset.defaultCharset() : Charset.forName(string));
    }

    public PlainTextSerializer(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        this.charset = charset;
    }

    public Document readObject(InputStream inputStream) throws IOException, SerializationException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.charset);
        Document document = this.readObject(inputStreamReader);
        return document;
    }

    public Document readObject(Reader reader) throws IOException {
        Document document = new Document();
        BufferedReader bufferedReader = new BufferedReader(reader, 2048);
        String string = bufferedReader.readLine();
        while (string != null) {
            document.add(new Paragraph(string));
            string = bufferedReader.readLine();
        }
        return document;
    }

    public void writeObject(Document document, OutputStream outputStream) throws IOException, SerializationException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.charset);
        this.writeObject(document, outputStreamWriter);
    }

    public void writeObject(Document document, Writer writer) throws IOException, SerializationException {
        this.writeValue(document, writer);
    }

    private void writeValue(Object object, Writer writer) throws IOException, SerializationException {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null.");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(writer, 2048);
        if (object instanceof Element) {
            Element element = (Element)object;
            for (Node node : element) {
                this.writeValue(node, writer);
            }
            if (element instanceof Paragraph) {
                bufferedWriter.newLine();
            }
        } else {
            String string;
            if (object instanceof TextNode) {
                TextNode textNode = (TextNode)object;
                string = textNode.getText();
            } else {
                string = object.toString();
            }
            bufferedWriter.write(string);
        }
        bufferedWriter.flush();
    }

    public String getMIMEType(Document document) {
        return "text/plain; charset=" + this.charset.name();
    }
}

