/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text.validation;

import java.util.Locale;
import org.apache.pivot.wtk.text.validation.DoubleValidator;

public class DoubleRangeValidator
extends DoubleValidator {
    private double minValue;
    private double maxValue;

    public DoubleRangeValidator() {
        this.minValue = 0.0;
        this.maxValue = 1.0;
    }

    public DoubleRangeValidator(Locale locale) {
        super(locale);
        this.minValue = 0.0;
        this.maxValue = 1.0;
    }

    public DoubleRangeValidator(double d, double d2) {
        this.minValue = d;
        this.maxValue = d2;
    }

    public DoubleRangeValidator(Locale locale, double d, double d2) {
        super(locale);
        this.minValue = d;
        this.maxValue = d2;
    }

    public double getMinimum() {
        return this.minValue;
    }

    public void setMinimum(double d) {
        this.minValue = d;
    }

    public double getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(double d) {
        this.maxValue = d;
    }

    @Override
    public boolean isValid(String string) {
        boolean bl = false;
        if (super.isValid(string)) {
            double d = this.textToObject(string);
            bl = d >= this.minValue && d <= this.maxValue;
        }
        return bl;
    }

    private final Double textToObject(String string) {
        return this.parseNumber(string).doubleValue();
    }
}

