/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtkx;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.pivot.beans.BeanDictionary;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Resources;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtkx.BindException;
import org.apache.pivot.wtkx.Bindable;
import org.apache.pivot.wtkx.WTKX;

public class WTKXSerializer
implements Serializer<Object>,
Dictionary<String, Object> {
    private Resources resources;
    private HashMap<String, Object> namedObjects;
    private HashMap<String, WTKXSerializer> namedSerializers;
    private XMLInputFactory xmlInputFactory;
    private ScriptEngineManager scriptEngineManager;
    private URL location = null;
    private Element element = null;
    private Object root = null;
    private String language = "javascript";
    public static final char URL_PREFIX = '@';
    public static final char RESOURCE_KEY_PREFIX = '%';
    public static final char OBJECT_REFERENCE_PREFIX = '$';
    public static final String LANGUAGE_PROCESSING_INSTRUCTION = "language";
    public static final String WTKX_PREFIX = "wtkx";
    public static final String ID_ATTRIBUTE = "id";
    public static final String INCLUDE_TAG = "include";
    public static final String INCLUDE_SRC_ATTRIBUTE = "src";
    public static final String INCLUDE_RESOURCES_ATTRIBUTE = "resources";
    public static final String SCRIPT_TAG = "script";
    public static final String SCRIPT_SRC_ATTRIBUTE = "src";
    public static final String SCRIPT_LANGUAGE_ATTRIBUTE = "language";
    public static final String DEFINE_TAG = "define";
    public static final String DEFAULT_LANGUAGE = "javascript";
    public static final String MIME_TYPE = "application/wtkx";

    public WTKXSerializer() {
        this(null);
    }

    public WTKXSerializer(Resources resources) {
        this(resources, (HashMap<String, Object>)new HashMap(), (HashMap<String, WTKXSerializer>)new HashMap());
    }

    private WTKXSerializer(Resources resources, HashMap<String, Object> hashMap, HashMap<String, WTKXSerializer> hashMap2) {
        this.resources = resources;
        this.namedObjects = hashMap;
        this.namedSerializers = hashMap2;
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        this.scriptEngineManager = new ScriptEngineManager();
        this.scriptEngineManager.setBindings(new NamedObjectBindings());
    }

    public Resources getResources() {
        return this.resources;
    }

    public Object readObject(String string) throws IOException, SerializationException {
        if (string == null) {
            throw new IllegalArgumentException("resourceName is null.");
        }
        ClassLoader classLoader = ThreadUtilities.getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            throw new SerializationException("Could not find resource named \"" + string + "\".");
        }
        return this.readObject(uRL);
    }

    public Object readObject(Object object, String string) throws IOException, SerializationException {
        if (object == null) {
            throw new IllegalArgumentException("baseObject is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("resourceName is null.");
        }
        return this.readObject(object.getClass(), string);
    }

    public Object readObject(Class<?> clazz, String string) throws IOException, SerializationException {
        if (clazz == null) {
            throw new IllegalArgumentException("baseType is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("resourceName is null.");
        }
        return this.readObject(clazz.getResource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(URL uRL) throws IOException, SerializationException {
        if (uRL == null) {
            throw new IllegalArgumentException("location is null.");
        }
        this.location = uRL;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        try {
            Object object = this.readObject(bufferedInputStream);
            return object;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public Object readObject(InputStream inputStream) throws IOException, SerializationException {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        if (this.root != null) {
            throw new IllegalStateException("Serializer must be reset.");
        }
        this.element = null;
        try {
            try {
                object = this.xmlInputFactory.createXMLStreamReader(inputStream);
                while (object.hasNext()) {
                    int n = object.next();
                    switch (n) {
                        case 3: {
                            this.processProcessingInstruction((XMLStreamReader)object);
                            break;
                        }
                        case 4: {
                            this.processCharacters((XMLStreamReader)object);
                            break;
                        }
                        case 1: {
                            this.processStartElement((XMLStreamReader)object);
                            break;
                        }
                        case 2: {
                            this.processEndElement((XMLStreamReader)object);
                        }
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SerializationException((Throwable)xMLStreamException);
            }
        }
        catch (IOException iOException) {
            this.logException(iOException);
            throw iOException;
        }
        catch (SerializationException serializationException) {
            this.logException((Exception)((Object)serializationException));
            throw serializationException;
        }
        catch (RuntimeException runtimeException) {
            this.logException(runtimeException);
            throw runtimeException;
        }
        if (this.root instanceof Bindable) {
            this.bind(this.root);
            object = (Bindable)this.root;
            object.initialize();
        }
        return this.root;
    }

    private void processProcessingInstruction(XMLStreamReader xMLStreamReader) {
        String string = xMLStreamReader.getPITarget();
        String string2 = xMLStreamReader.getPIData();
        if (string.equals("language")) {
            this.language = string2;
        }
    }

    private void processCharacters(XMLStreamReader xMLStreamReader) throws SerializationException {
        if (!xMLStreamReader.isWhiteSpace()) {
            String string = xMLStreamReader.getText();
            switch (this.element.type) {
                case INSTANCE: {
                    if (!(this.element.value instanceof Sequence)) break;
                    Sequence sequence = (Sequence)this.element.value;
                    try {
                        Method method = sequence.getClass().getMethod("add", String.class);
                        method.invoke((Object)sequence, string);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new SerializationException("Text content cannot be added to " + sequence.getClass().getName() + ".", (Throwable)noSuchMethodException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new SerializationException((Throwable)invocationTargetException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SerializationException((Throwable)illegalAccessException);
                    }
                }
                case SCRIPT: 
                case WRITABLE_PROPERTY: {
                    this.element.value = string;
                    break;
                }
                default: {
                    throw new SerializationException("Unexpected characters in " + (Object)((Object)this.element.type) + " element.");
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processStartElement(XMLStreamReader xMLStreamReader) throws SerializationException {
        Class<?> clazz;
        String string;
        String string2 = xMLStreamReader.getNamespaceURI();
        String string3 = xMLStreamReader.getPrefix();
        String string4 = xMLStreamReader.getLocalName();
        String string5 = null;
        ArrayList arrayList = new ArrayList();
        int n = xMLStreamReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string = xMLStreamReader.getAttributePrefix(i);
            clazz = xMLStreamReader.getAttributeLocalName(i);
            String string6 = xMLStreamReader.getAttributeValue(i);
            if (string != null && string.equals(WTKX_PREFIX)) {
                if (!((String)((Object)clazz)).equals(ID_ATTRIBUTE)) throw new SerializationException("wtkx:" + (String)((Object)clazz) + " is not a valid attribute.");
                if (string6.length() == 0) {
                    throw new IllegalArgumentException("wtkx:id must not be empty.");
                }
                string5 = string6;
                continue;
            }
            String string7 = xMLStreamReader.getAttributeNamespace(i);
            if (string7 == null) {
                string7 = xMLStreamReader.getNamespaceURI("");
            }
            arrayList.add((Object)new Attribute(string7, (String)((Object)clazz), string6));
        }
        Element.Type type = null;
        Object object = null;
        if (string3 != null && string3.equals(WTKX_PREFIX)) {
            if (this.element == null) {
                throw new SerializationException(string3 + ":" + string4 + " is not a valid root element.");
            }
            if (string4.equals(INCLUDE_TAG)) {
                type = Element.Type.INCLUDE;
            } else if (string4.equals(SCRIPT_TAG)) {
                type = Element.Type.SCRIPT;
            } else {
                if (!string4.equals(DEFINE_TAG)) throw new SerializationException(string3 + ":" + string4 + " is not a valid element.");
                if (arrayList.getLength() > 0) {
                    throw new SerializationException("wtkx:define cannot have attributes.");
                }
                type = Element.Type.DEFINE;
            }
        } else if (Character.isUpperCase(string4.charAt(0))) {
            if (string2 == null) {
                throw new SerializationException("No XML namespace specified for " + string4 + " tag.");
            }
            string = string2 + "." + string4.replace('.', '$');
            try {
                clazz = Class.forName(string);
                type = Element.Type.INSTANCE;
                object = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new SerializationException((Throwable)exception);
            }
        } else {
            if (this.element == null || this.element.type != Element.Type.INSTANCE) {
                throw new SerializationException("Parent element must be a typed object.");
            }
            if (string3 != null && string3.length() > 0) {
                throw new SerializationException("Property elements cannot have a namespace prefix.");
            }
            string = new BeanDictionary(this.element.value);
            if (string.isReadOnly(string4)) {
                type = Element.Type.READ_ONLY_PROPERTY;
                object = string.get(string4);
                assert (object != null) : "Read-only properties cannot be null.";
                if (arrayList.getLength() > 0 && !(object instanceof Dictionary)) {
                    throw new SerializationException("Only read-only dictionaries can have attributes.");
                }
            } else {
                if (arrayList.getLength() > 0) {
                    throw new SerializationException("Writable property elements cannot have attributes.");
                }
                type = Element.Type.WRITABLE_PROPERTY;
            }
        }
        string = string4;
        if (string3 != null && string3.length() > 0) {
            string = string3 + ":" + string;
        }
        clazz = xMLStreamReader.getLocation();
        this.element = new Element(this.element, type, string5, string, clazz.getLineNumber(), (List<Attribute>)arrayList, object);
        if (this.element.parent != null) return;
        this.root = this.element.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEndElement(XMLStreamReader xMLStreamReader) throws SerializationException, IOException {
        String string = xMLStreamReader.getLocalName();
        switch (this.element.type) {
            case INSTANCE: 
            case INCLUDE: {
                Object object5;
                Object object2;
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                if (this.element.type == Element.Type.INCLUDE) {
                    Object object3;
                    object2 = null;
                    object5 = this.resources;
                    for (Object object4 : this.element.attributes) {
                        if (((Attribute)object4).localName.equals("src")) {
                            object2 = ((Attribute)object4).value;
                            continue;
                        }
                        if (((Attribute)object4).localName.equals(INCLUDE_RESOURCES_ATTRIBUTE)) {
                            object5 = new Resources((Resources)object5, ((Attribute)object4).value);
                            continue;
                        }
                        if (!Character.isUpperCase(((Attribute)object4).localName.charAt(0))) {
                            throw new SerializationException("Instance property setters are not supported for wtkx:include  tag.");
                        }
                        arrayList2.add(object4);
                    }
                    if (object2 == null) {
                        throw new SerializationException("src attribute is required for wtkx:include tag.");
                    }
                    if (this.element.id == null) {
                        object3 = new WTKXSerializer((Resources)object5, this.namedObjects, this.namedSerializers);
                    } else {
                        object3 = new WTKXSerializer((Resources)object5);
                        this.namedSerializers.put((Object)this.element.id, object3);
                    }
                    this.element.value = ((String)object2).charAt(0) == '/' ? ((WTKXSerializer)object3).readObject(((String)object2).substring(1)) : ((WTKXSerializer)object3).readObject(new URL(this.location, (String)object2));
                    if (this.element.id == null && !((WTKXSerializer)object3).isEmpty() && ((WTKXSerializer)object3).scriptEngineManager == null) {
                        System.err.println("Include \"" + (String)object2 + "\" defines unreachable objects.");
                    }
                } else {
                    for (Object object5 : this.element.attributes) {
                        if (Character.isUpperCase(((Attribute)object5).localName.charAt(0))) {
                            arrayList2.add(object5);
                            continue;
                        }
                        arrayList.add(object5);
                    }
                }
                if (this.element.id != null) {
                    this.namedObjects.put((Object)this.element.id, this.element.value);
                }
                object2 = this.element.value instanceof Dictionary ? (Dictionary)this.element.value : new BeanDictionary(this.element.value);
                for (Object object3 : arrayList) {
                    object2.put((Object)((Attribute)object3).localName, this.resolve(((Attribute)object3).value));
                }
                if (this.element.parent != null) {
                    if (this.element.parent.value instanceof Sequence) {
                        object5 = (Sequence)this.element.parent.value;
                        object5.add(this.element.value);
                    } else if (this.element.parent.value instanceof ListenerList) {
                        object5 = (ListenerList)this.element.parent.value;
                        object5.add(this.element.value);
                    }
                }
                if (this.element.value instanceof Dictionary) {
                    if (arrayList2.getLength() > 0) {
                        throw new SerializationException("Static setters are only supported for typed objects.");
                    }
                } else {
                    for (Object object3 : arrayList2) {
                        Object object6;
                        Object object7;
                        Object object8;
                        Object object9;
                        Object object10;
                        Object object11;
                        Object object4;
                        object4 = ((Attribute)object3).namespaceURI + "." + ((Attribute)object3).localName.substring(0, ((Attribute)object3).localName.lastIndexOf("."));
                        Class<?> clazz = null;
                        try {
                            clazz = Class.forName((String)object4);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new SerializationException((Throwable)classNotFoundException);
                        }
                        if (clazz.isInterface()) {
                            Method method;
                            object11 = ((String)object4).substring(((String)object4).lastIndexOf(46) + 1);
                            object10 = "get" + Character.toUpperCase(((String)object11).charAt(0)) + ((String)object11).substring(1) + "s";
                            try {
                                object9 = this.element.value.getClass();
                                object8 = ((Class)object9).getMethod((String)object10, new Class[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                throw new SerializationException((Throwable)noSuchMethodException);
                            }
                            try {
                                object9 = ((Method)object8).invoke(this.element.value, new Object[0]);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw new SerializationException((Throwable)invocationTargetException);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                throw new SerializationException((Throwable)illegalAccessException);
                            }
                            object7 = this.scriptEngineManager.getEngineByName(this.language);
                            object7.setBindings(new SimpleBindings(), 100);
                            object6 = new AttributeInvocationHandler((ScriptEngine)object7, ((Attribute)object3).localName.substring(((Attribute)object3).localName.lastIndexOf(".") + 1), ((Attribute)object3).value);
                            Object object12 = Proxy.newProxyInstance(ThreadUtilities.getClassLoader(), new Class[]{clazz}, (InvocationHandler)object6);
                            Class<?> clazz2 = object9.getClass();
                            try {
                                method = clazz2.getMethod("add", Object.class);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                throw new RuntimeException(noSuchMethodException);
                            }
                            try {
                                method.invoke(object9, object12);
                                continue;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                throw new SerializationException((Throwable)illegalAccessException);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw new SerializationException((Throwable)invocationTargetException);
                            }
                        }
                        object11 = this.resolve(((Attribute)object3).value);
                        object10 = this.element.value.getClass();
                        object8 = ((Attribute)object3).localName.substring(((Attribute)object3).localName.lastIndexOf(".") + 1);
                        object8 = Character.toUpperCase(((String)object8).charAt(0)) + ((String)object8).substring(1);
                        object9 = null;
                        if (object11 != null) {
                            object9 = this.getStaticSetterMethod(clazz, (String)object8, (Class<?>)object10, object11.getClass());
                        }
                        if (object9 == null && (object7 = this.getStaticGetterMethod(clazz, (String)object8, (Class<?>)object10)) != null) {
                            object6 = ((Method)object7).getReturnType();
                            object9 = this.getStaticSetterMethod(clazz, (String)object8, (Class<?>)object10, (Class<?>)object6);
                            if (object11 instanceof String) {
                                object11 = BeanDictionary.coerce((String)((String)object11), object6);
                            }
                        }
                        if (object9 == null) {
                            throw new SerializationException(((Attribute)object3).localName + " is not valid static property.");
                        }
                        try {
                            ((Method)object9).invoke(null, this.element.value, object11);
                        }
                        catch (Exception exception) {
                            throw new SerializationException((Throwable)exception);
                        }
                    }
                }
                if (this.element.parent == null || this.element.parent.type != Element.Type.WRITABLE_PROPERTY) break;
                this.element.parent.value = this.element.value;
                break;
            }
            case READ_ONLY_PROPERTY: {
                if (!(this.element.value instanceof Dictionary)) break;
                for (Attribute attribute : this.element.attributes) {
                    if (Character.isUpperCase(attribute.localName.charAt(0))) {
                        throw new SerializationException("Static setters are not supported for read-only properties.");
                    }
                    Dictionary dictionary = (Dictionary)this.element.value;
                    dictionary.put((Object)attribute.localName, this.resolve(attribute.value));
                }
                break;
            }
            case WRITABLE_PROPERTY: {
                BeanDictionary beanDictionary = new BeanDictionary(this.element.parent.value);
                beanDictionary.put(string, this.element.value);
                break;
            }
            case SCRIPT: {
                Method method;
                Serializable serializable;
                Object object;
                Type[] typeArray;
                Object object132;
                String string2 = null;
                String string3 = this.language;
                for (Object object132 : this.element.attributes) {
                    if (((Attribute)object132).localName.equals("src")) {
                        string2 = ((Attribute)object132).value;
                        continue;
                    }
                    if (((Attribute)object132).localName.equals("language")) {
                        string3 = ((Attribute)object132).value;
                        continue;
                    }
                    throw new SerializationException(((Attribute)object132).localName + " is not a valid" + " attribute for the " + WTKX_PREFIX + ":" + SCRIPT_TAG + " tag.");
                }
                Bindings bindings = this.element.parent.value instanceof ListenerList ? new SimpleBindings() : this.scriptEngineManager.getBindings();
                if (string2 != null) {
                    int n = string2.lastIndexOf(".");
                    if (n == -1) {
                        throw new SerializationException("Cannot determine type of script \"" + string2 + "\".");
                    }
                    typeArray = string2.substring(n + 1);
                    object132 = this.scriptEngineManager.getEngineByExtension((String)typeArray);
                    if (object132 == null) {
                        throw new SerializationException("Unable to find scripting engine for extension " + (String)typeArray + ".");
                    }
                    object132.setBindings(bindings, 100);
                    try {
                        if (string2.charAt(0) == '/') {
                            object = ThreadUtilities.getClassLoader();
                            serializable = ((ClassLoader)object).getResource(string2);
                        } else {
                            serializable = new URL(this.location, string2);
                        }
                        object = null;
                        try {
                            object = new BufferedReader(new InputStreamReader(((URL)serializable).openStream()));
                            object132.eval((Reader)object);
                        }
                        catch (ScriptException scriptException) {
                            scriptException.printStackTrace();
                        }
                        finally {
                            if (object != null) {
                                ((BufferedReader)object).close();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        throw new SerializationException((Throwable)iOException);
                    }
                } else {
                    object132 = this.scriptEngineManager.getEngineByName(string3);
                    if (object132 == null) {
                        throw new SerializationException("Unable to find scripting engine for language \"" + string3 + "\".");
                    }
                    object132.setBindings(bindings, 100);
                    String string4 = (String)this.element.value;
                    if (string4 != null) {
                        try {
                            object132.eval(string4);
                        }
                        catch (ScriptException scriptException) {
                            System.err.println(scriptException);
                            System.err.println(string4);
                        }
                    }
                }
                if (!(this.element.parent.value instanceof ListenerList)) break;
                Class<?> clazz = this.element.parent.value.getClass();
                typeArray = clazz.getGenericInterfaces();
                serializable = (Class)typeArray[0];
                object = new ElementInvocationHandler((ScriptEngine)object132);
                try {
                    method = clazz.getMethod("add", Object.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                Object object14 = Proxy.newProxyInstance(ThreadUtilities.getClassLoader(), new Class[]{serializable}, (InvocationHandler)object);
                try {
                    method.invoke(this.element.parent.value, object14);
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SerializationException((Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new SerializationException((Throwable)invocationTargetException);
                }
            }
        }
        if (this.element.parent != null) {
            this.element = this.element.parent;
        }
    }

    private void logException(Exception exception) {
        String string = "An error occurred while processing ";
        string = this.element == null ? string + " the root element" : string + " element <" + this.element.tagName + ">" + " starting at line number " + this.element.lineNumber;
        if (this.location != null) {
            string = string + " in file " + this.location.getPath();
        }
        string = string + ":";
        System.err.println(string);
        exception.printStackTrace();
    }

    public void writeObject(Object object, OutputStream outputStream) throws IOException, SerializationException {
        throw new UnsupportedOperationException();
    }

    public String getMIMEType(Object object) {
        return MIME_TYPE;
    }

    public Object get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is null.");
        }
        Object object = null;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            object = this.namedObjects.get((Object)string);
        } else {
            String string2 = string.substring(0, string.lastIndexOf(46));
            String string3 = string.substring(string2.length() + 1);
            WTKXSerializer wTKXSerializer = this.getSerializer(string2);
            if (wTKXSerializer != null) {
                object = wTKXSerializer.get(string3);
            }
        }
        return object;
    }

    public <T> T getValue(String string) {
        return (T)this.get(string);
    }

    public Object put(String string, Object object) {
        Object object2;
        if (string == null) {
            throw new IllegalArgumentException("name is null.");
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            object2 = this.namedObjects.put((Object)string, object);
        } else {
            String string2 = string.substring(0, string.lastIndexOf(46));
            String string3 = string.substring(string2.length() + 1);
            WTKXSerializer wTKXSerializer = this.getSerializer(string2);
            object2 = wTKXSerializer.put(string3, object);
        }
        return object2;
    }

    public Object remove(String string) {
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("name is null.");
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            object = this.namedObjects.remove((Object)string);
        } else {
            String string2 = string.substring(0, string.lastIndexOf(46));
            String string3 = string.substring(string2.length() + 1);
            WTKXSerializer wTKXSerializer = this.getSerializer(string2);
            object = wTKXSerializer.remove(string3);
        }
        return object;
    }

    public boolean containsKey(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is null.");
        }
        boolean bl = false;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            bl = this.namedObjects.containsKey((Object)string);
        } else {
            String string2 = string.substring(0, string.lastIndexOf(46));
            String string3 = string.substring(string2.length() + 1);
            WTKXSerializer wTKXSerializer = this.getSerializer(string2);
            if (wTKXSerializer != null) {
                bl = wTKXSerializer.containsKey(string3);
            }
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.namedObjects.isEmpty() && this.namedSerializers.isEmpty();
    }

    public void reset() {
        this.location = null;
        this.namedObjects.clear();
        this.namedSerializers.clear();
        this.root = null;
        this.language = DEFAULT_LANGUAGE;
    }

    public Object getRoot() {
        return this.root;
    }

    public WTKXSerializer getSerializer(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is null.");
        }
        WTKXSerializer wTKXSerializer = this;
        String[] stringArray = string.split("\\.");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2 && wTKXSerializer != null) {
            String string2 = stringArray[n++];
            wTKXSerializer = (WTKXSerializer)wTKXSerializer.namedSerializers.get((Object)string2);
        }
        return wTKXSerializer;
    }

    public URL getLocation() {
        return this.location;
    }

    public void bind(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this.bind(object, object.getClass());
    }

    public void bind(Object object, Class<?> clazz) throws BindException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException();
        }
        for (Field field : clazz.getDeclaredFields()) {
            String string;
            String string2 = field.getName();
            int n = field.getModifiers();
            WTKX wTKX = field.getAnnotation(WTKX.class);
            if (wTKX == null) continue;
            if ((n & 0x10) > 0) {
                throw new BindException(string2 + " is final.");
            }
            if ((n & 1) == 0) {
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    throw new BindException(string2 + " is not accessible.");
                }
            }
            if ((string = wTKX.id()).equals("\u0000")) {
                string = field.getName();
            }
            if (!this.containsKey(string)) continue;
            Object object2 = this.get(string);
            try {
                field.set(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BindException(illegalAccessException);
            }
        }
    }

    private Object resolve(String string) throws MalformedURLException {
        Object object = null;
        if (string.length() > 0) {
            if (string.charAt(0) == '@') {
                if (string.length() > 1) {
                    if (string.charAt(1) == '@') {
                        object = string.substring(1);
                    } else {
                        if (this.location == null) {
                            throw new IllegalStateException("Base location is undefined.");
                        }
                        object = new URL(this.location, string.substring(1));
                    }
                }
            } else if (string.charAt(0) == '%') {
                if (string.length() > 1) {
                    if (string.charAt(1) == '%') {
                        object = string.substring(1);
                    } else {
                        if (this.resources == null) {
                            throw new IllegalStateException("Resources is null.");
                        }
                        object = this.resources.get(string.substring(1));
                        if (object == null) {
                            object = string;
                        }
                    }
                }
            } else if (string.charAt(0) == '$') {
                if (string.length() > 1) {
                    if (string.charAt(1) == '$') {
                        object = string.substring(1);
                    } else {
                        object = this.get(string.substring(1));
                        if (object == null) {
                            object = string;
                        }
                    }
                }
            } else {
                object = string;
            }
        } else {
            object = string;
        }
        return object;
    }

    private Method getStaticGetterMethod(Class<?> clazz, String string, Class<?> clazz2) {
        Method method = null;
        if (clazz2 != null) {
            try {
                method = clazz.getMethod("get" + string, clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                try {
                    method = clazz.getMethod("is" + string, clazz2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (method == null) {
                method = this.getStaticGetterMethod(clazz, string, clazz2.getSuperclass());
            }
        }
        return method;
    }

    private Method getStaticSetterMethod(Class<?> clazz, String string, Class<?> clazz2, Class<?> clazz3) {
        Method method = null;
        if (clazz2 != null) {
            String string2 = "set" + string;
            try {
                method = clazz.getMethod(string2, clazz2, clazz3);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                try {
                    Field field = clazz3.getField("TYPE");
                    Class clazz4 = (Class)field.get(null);
                    try {
                        method = clazz.getMethod(string2, clazz2, clazz4);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (method == null) {
                method = this.getStaticSetterMethod(clazz, string, clazz2.getSuperclass(), clazz3);
            }
        }
        return method;
    }

    private static class ElementInvocationHandler
    implements InvocationHandler {
        private ScriptEngine scriptEngine;

        public ElementInvocationHandler(ScriptEngine scriptEngine) {
            this.scriptEngine = scriptEngine;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Class<?> clazz;
            Object object2 = null;
            String string = method.getName();
            Bindings bindings = this.scriptEngine.getBindings(100);
            if (bindings.containsKey(string)) {
                try {
                    clazz = (Invocable)((Object)this.scriptEngine);
                }
                catch (ClassCastException classCastException) {
                    throw new SerializationException((Throwable)classCastException);
                }
                object2 = clazz.invokeFunction(string, objectArray);
            }
            if (object2 == null) {
                clazz = method.getReturnType();
                if (clazz == Vote.class) {
                    object2 = Vote.APPROVE;
                } else if (clazz == Boolean.TYPE) {
                    object2 = false;
                }
            }
            return object2;
        }
    }

    private static class AttributeInvocationHandler
    implements InvocationHandler {
        private ScriptEngine scriptEngine;
        private String event;
        private String script;

        public AttributeInvocationHandler(ScriptEngine scriptEngine, String string, String string2) {
            this.scriptEngine = scriptEngine;
            this.event = string;
            this.script = string2;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Class<?> clazz;
            Object object2 = null;
            String string = method.getName();
            if (string.equals(this.event)) {
                try {
                    this.scriptEngine.eval(this.script);
                }
                catch (ScriptException scriptException) {
                    System.err.println(scriptException);
                    System.err.println(this.script);
                }
            }
            if ((clazz = method.getReturnType()) == Vote.class) {
                object2 = Vote.APPROVE;
            } else if (clazz == Boolean.TYPE) {
                object2 = false;
            }
            return object2;
        }
    }

    private static class Attribute {
        public final String namespaceURI;
        public final String localName;
        public final String value;

        public Attribute(String string, String string2, String string3) {
            this.namespaceURI = string;
            this.localName = string2;
            this.value = string3;
        }
    }

    private static class Element {
        public final Element parent;
        public final Type type;
        public final String id;
        public final String tagName;
        public final int lineNumber;
        public final List<Attribute> attributes;
        public Object value;

        public Element(Element element, Type type, String string, String string2, int n, List<Attribute> list, Object object) {
            this.parent = element;
            this.type = type;
            this.id = string;
            this.tagName = string2;
            this.lineNumber = n;
            this.attributes = list;
            this.value = object;
        }

        public static enum Type {
            DEFINE,
            INSTANCE,
            INCLUDE,
            SCRIPT,
            READ_ONLY_PROPERTY,
            WRITABLE_PROPERTY;

        }
    }

    private class NamedObjectBindings
    implements Bindings {
        private NamedObjectBindings() {
        }

        @Override
        public Object get(Object object) {
            return WTKXSerializer.this.namedObjects.get((Object)object.toString());
        }

        @Override
        public Object put(String string, Object object) {
            return WTKXSerializer.this.namedObjects.put((Object)string, object);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            for (String string : map.keySet()) {
                this.put(string, map.get(string));
            }
        }

        @Override
        public Object remove(Object object) {
            return WTKXSerializer.this.namedObjects.remove((Object)object.toString());
        }

        @Override
        public void clear() {
            WTKXSerializer.this.namedObjects.clear();
        }

        @Override
        public boolean containsKey(Object object) {
            return WTKXSerializer.this.namedObjects.containsKey((Object)object.toString());
        }

        @Override
        public boolean containsValue(Object object) {
            boolean bl = false;
            for (String string : WTKXSerializer.this.namedObjects) {
                if (!WTKXSerializer.this.namedObjects.get((Object)string).equals(object)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        @Override
        public boolean isEmpty() {
            return WTKXSerializer.this.namedObjects.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : WTKXSerializer.this.namedObjects) {
                hashSet.add(string);
            }
            return hashSet;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            java.util.HashMap<String, Object> hashMap = new java.util.HashMap<String, Object>();
            for (String string : WTKXSerializer.this.namedObjects) {
                hashMap.put(string, WTKXSerializer.this.namedObjects.get((Object)string));
            }
            return hashMap.entrySet();
        }

        @Override
        public int size() {
            return WTKXSerializer.this.namedObjects.getCount();
        }

        @Override
        public Collection<Object> values() {
            java.util.ArrayList<Object> arrayList = new java.util.ArrayList<Object>();
            for (String string : WTKXSerializer.this.namedObjects) {
                arrayList.add(WTKXSerializer.this.namedObjects.get((Object)string));
            }
            return arrayList;
        }
    }
}

