/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.web.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.util.Base64;
import org.apache.pivot.web.QueryDictionary;
import org.apache.pivot.web.server.ClientException;

public abstract class QueryServlet
extends HttpServlet {
    static final long serialVersionUID = -646654620936816287L;
    private boolean authenticationRequired = false;
    private boolean determineContentLength = false;
    private transient ThreadLocal<Credentials> credentials = new ThreadLocal();
    private transient ThreadLocal<String> hostname = new ThreadLocal();
    private transient ThreadLocal<String> contextPath = new ThreadLocal();
    private transient ThreadLocal<String> queryPath = new ThreadLocal();
    private transient ThreadLocal<Integer> port = new ThreadLocal();
    private transient ThreadLocal<Boolean> secure = new ThreadLocal();
    private transient ThreadLocal<Method> method = new ThreadLocal();
    private transient ThreadLocal<QueryDictionary> parameters = new ThreadLocal();
    private transient ThreadLocal<QueryDictionary> requestHeaders = new ThreadLocal();
    private transient ThreadLocal<QueryDictionary> responseHeaders = new ThreadLocal();
    private static final String BASIC_AUTHENTICATION_TAG = "Basic";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String URL_ENCODING = "UTF-8";

    public boolean isDetermineContentLength() {
        return this.determineContentLength;
    }

    public void setDetermineContentLength(boolean bl) {
        this.determineContentLength = bl;
    }

    public boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public void setAuthenticationRequired(boolean bl) {
        this.authenticationRequired = bl;
        if (!bl) {
            this.credentials.remove();
        }
    }

    protected abstract Serializer<?> newSerializer();

    public String getHostname() {
        return this.hostname.get();
    }

    public String getContextPath() {
        return this.contextPath.get();
    }

    public String getQueryPath() {
        return this.queryPath.get();
    }

    public int getPort() {
        return this.port.get();
    }

    public boolean isSecure() {
        return this.secure.get();
    }

    public String getProtocol() {
        return this.isSecure() ? HTTPS_PROTOCOL : HTTP_PROTOCOL;
    }

    public Method getMethod() {
        return this.method.get();
    }

    public Credentials getCredentials() {
        return this.credentials.get();
    }

    public QueryDictionary getParameters() {
        return this.parameters.get();
    }

    public QueryDictionary getRequestHeaders() {
        return this.requestHeaders.get();
    }

    public QueryDictionary getResponseHeaders() {
        return this.responseHeaders.get();
    }

    protected Object doGet() throws ServletException, ClientException {
        throw new UnsupportedOperationException();
    }

    protected URL doPost(Object object) throws ServletException, ClientException {
        throw new UnsupportedOperationException();
    }

    protected void doPut(Object object) throws ServletException, ClientException {
        throw new UnsupportedOperationException();
    }

    protected void doDelete() throws ServletException, ClientException {
        throw new UnsupportedOperationException();
    }

    protected void authorize() throws ServletException, LoginException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String[] stringArray;
            Object object;
            String string;
            Object object2;
            this.parameters.set(new QueryDictionary());
            this.requestHeaders.set(new QueryDictionary());
            this.responseHeaders.set(new QueryDictionary());
            boolean bl = true;
            if (this.authenticationRequired) {
                object2 = httpServletRequest.getHeader("Authorization");
                if (object2 == null) {
                    bl = false;
                    this.doUnauthorized(httpServletRequest, httpServletResponse);
                } else {
                    string = ((String)object2).substring(BASIC_AUTHENTICATION_TAG.length() + 1);
                    object = new String(Base64.decode((String)string));
                    String[] stringArray2 = object.split(":");
                    String string2 = stringArray2.length > 0 ? stringArray2[0] : "";
                    stringArray = stringArray2.length > 1 ? stringArray2[1] : "";
                    this.credentials.set(new Credentials(string2, (String)stringArray));
                }
            }
            if (bl) {
                try {
                    object2 = new URL(httpServletRequest.getRequestURL().toString());
                    string = httpServletRequest.getRequestURI();
                    object = httpServletRequest.getContextPath();
                    this.hostname.set(((URL)object2).getHost());
                    this.contextPath.set((String)object);
                    this.queryPath.set(string);
                    this.port.set(httpServletRequest.getLocalPort());
                    this.secure.set(((URL)object2).getProtocol().equalsIgnoreCase(HTTPS_PROTOCOL));
                    this.method.set(Method.valueOf(httpServletRequest.getMethod().toUpperCase()));
                    if (string.startsWith((String)object)) {
                        this.queryPath.set(string.substring(object.length()));
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    throw new ServletException((Throwable)malformedURLException);
                }
                object2 = httpServletRequest.getQueryString();
                if (object2 != null) {
                    string = this.parameters.get();
                    object = ((String)object2).split("&");
                    int n = ((String[])object).length;
                    for (int i = 0; i < n; ++i) {
                        stringArray = object[i].split("=");
                        String string3 = URLDecoder.decode(stringArray[0], URL_ENCODING);
                        String string4 = URLDecoder.decode(stringArray.length > 1 ? stringArray[1] : "", URL_ENCODING);
                        string.add(string3, string4);
                    }
                }
                string = this.requestHeaders.get();
                object = httpServletRequest.getHeaderNames();
                while (object.hasMoreElements()) {
                    String string5 = (String)object.nextElement();
                    String string6 = httpServletRequest.getHeader(string5);
                    string.add(string5, string6);
                }
                if (this.authenticationRequired) {
                    try {
                        this.authorize();
                    }
                    catch (LoginException loginException) {
                        bl = false;
                        this.doForbidden(httpServletRequest, httpServletResponse);
                    }
                }
            }
            if (bl) {
                super.service(httpServletRequest, httpServletResponse);
            }
        }
        finally {
            this.credentials.remove();
            this.hostname.remove();
            this.contextPath.remove();
            this.queryPath.remove();
            this.port.remove();
            this.secure.remove();
            this.method.remove();
            this.parameters.remove();
            this.requestHeaders.remove();
            this.responseHeaders.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        block13: {
            Serializer<?> serializer = this.newSerializer();
            try {
                Object object = this.doGet();
                httpServletResponse.setStatus(200);
                this.setResponseHeaders(httpServletResponse);
                httpServletResponse.setContentType(serializer.getMIMEType(object));
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                if (this.determineContentLength) {
                    File file = File.createTempFile("pivot", null);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    try {
                        serializer.writeObject(object, (OutputStream)fileOutputStream);
                    }
                    finally {
                        fileOutputStream.close();
                    }
                    httpServletResponse.setHeader("Content-Length", String.valueOf(file.length()));
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        do {
                            if ((n = fileInputStream.read(byArray)) <= 0) continue;
                            servletOutputStream.write(byArray, 0, n);
                        } while (n != -1);
                        break block13;
                    }
                    finally {
                        fileInputStream.close();
                    }
                }
                serializer.writeObject(object, (OutputStream)servletOutputStream);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.doMethodNotAllowed(httpServletResponse);
            }
            catch (ClientException clientException) {
                this.doBadRequest(httpServletResponse);
            }
            catch (SerializationException serializationException) {
                throw new ServletException((Throwable)serializationException);
            }
        }
    }

    protected final void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Serializer<?> serializer = this.newSerializer();
        try {
            Object object = serializer.readObject((InputStream)httpServletRequest.getInputStream());
            URL uRL = this.doPost(object);
            httpServletResponse.setStatus(201);
            this.setResponseHeaders(httpServletResponse);
            httpServletResponse.setHeader("Location", uRL.toString());
            httpServletResponse.setContentLength(0);
            httpServletResponse.flushBuffer();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.doMethodNotAllowed(httpServletResponse);
        }
        catch (ClientException clientException) {
            this.doBadRequest(httpServletResponse);
        }
        catch (SerializationException serializationException) {
            throw new ServletException((Throwable)serializationException);
        }
    }

    protected final void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Serializer<?> serializer = this.newSerializer();
        try {
            Object object = serializer.readObject((InputStream)httpServletRequest.getInputStream());
            this.doPut(object);
            httpServletResponse.setStatus(204);
            this.setResponseHeaders(httpServletResponse);
            httpServletResponse.setContentLength(0);
            httpServletResponse.flushBuffer();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.doMethodNotAllowed(httpServletResponse);
        }
        catch (ClientException clientException) {
            this.doBadRequest(httpServletResponse);
        }
        catch (SerializationException serializationException) {
            throw new ServletException((Throwable)serializationException);
        }
    }

    protected final void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            this.doDelete();
            httpServletResponse.setStatus(204);
            this.setResponseHeaders(httpServletResponse);
            httpServletResponse.setContentLength(0);
            httpServletResponse.flushBuffer();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.doMethodNotAllowed(httpServletResponse);
        }
        catch (ClientException clientException) {
            this.doBadRequest(httpServletResponse);
        }
    }

    protected final void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doMethodNotAllowed(httpServletResponse);
    }

    protected final void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doMethodNotAllowed(httpServletResponse);
    }

    protected final void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doMethodNotAllowed(httpServletResponse);
    }

    private void doUnauthorized(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader("WWW-Authenticate", "BASIC realm=\"" + httpServletRequest.getServletPath() + "\"");
        httpServletResponse.setStatus(401);
        httpServletResponse.setContentLength(0);
        httpServletResponse.flushBuffer();
    }

    private void doForbidden(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(403);
        httpServletResponse.setContentLength(0);
        httpServletResponse.flushBuffer();
    }

    private void doMethodNotAllowed(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(405);
        httpServletResponse.setContentLength(0);
        httpServletResponse.flushBuffer();
    }

    private void doBadRequest(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(400);
        httpServletResponse.setContentLength(0);
        httpServletResponse.flushBuffer();
    }

    private void setResponseHeaders(HttpServletResponse httpServletResponse) {
        QueryDictionary queryDictionary = this.responseHeaders.get();
        for (String string : queryDictionary) {
            int n = queryDictionary.getLength(string);
            for (int i = 0; i < n; ++i) {
                httpServletResponse.addHeader(string, queryDictionary.get(string, i));
            }
        }
    }

    public static final class Credentials {
        private String username;
        private String password;

        private Credentials(String string, String string2) {
            this.username = string;
            this.password = string2;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

